/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.batch;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintpaas.batch.engine.executor.core.batch.BatchDataUtil;
import com.irdstudio.allintpaas.batch.engine.executor.core.batch.BatchRunProcess;
import com.irdstudio.allintpaas.batch.engine.executor.core.batch.BatchTaskThread;
import com.irdstudio.allintpaas.batch.engine.executor.core.dao.BatInstTaskDao;
import com.irdstudio.allintpaas.batch.engine.executor.core.dao.BatTaskUnitConfigDao;
import com.irdstudio.allintpaas.batch.engine.executor.core.dao.domain.BatBatchInfoConfig;
import com.irdstudio.allintpaas.batch.engine.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allintpaas.batch.engine.executor.core.dao.domain.BatInstTask;
import com.irdstudio.allintpaas.batch.engine.executor.core.dao.domain.BatTaskUnitConfig;
import com.irdstudio.allintpaas.batch.engine.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.jdbc.util.DataMoveUtil;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.jdbc.util.TableMove;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.date.DateCalculate;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.date.DateConvert;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.pub.ConnectionUtil;
import com.irdstudio.framework.beans.core.util.MapBeanUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchRunEngine {
    private static final String BATCH_RUN = "run";
    private static final String BATCH_STOP = "stop";
    private static final String BATCH_RERUN = "rerun";
    private static final String BATCH_CONTINUE = "continue";
    private static final String BATCH_FAIL_TRY = "failtry";
    private String batchAction;
    private String batchId;
    private String batchSerialNo;
    private String envId;
    private Map<String, Object> param;

    public BatchRunEngine(String batchAction, String batchId) {
        this.batchId = batchId;
        this.batchAction = batchAction.toLowerCase();
    }

    public BatchRunEngine(String batchSerialNo, String batchAction, String batchId) {
        this.batchSerialNo = batchSerialNo;
        this.batchId = batchId;
        this.batchAction = batchAction.toLowerCase();
    }

    public BatchRunEngine(String batchSerialNo, String batchAction, String batchId, String envId, Map<String, Object> param) {
        this.batchSerialNo = batchSerialNo;
        this.batchId = batchId;
        this.batchAction = batchAction.toLowerCase();
        this.envId = envId;
        this.param = param;
    }

    public void start() throws Exception {
        if (BATCH_RUN.equals(this.batchAction)) {
            this.doRunBatch();
        } else if (BATCH_STOP.equals(this.batchAction)) {
            this.doStopBatch();
        } else if (BATCH_RERUN.equals(this.batchAction)) {
            this.doRerunBatch();
        } else if (BATCH_CONTINUE.equals(this.batchAction)) {
            this.doContinueBatch();
        } else if (BATCH_FAIL_TRY.equals(this.batchAction)) {
            this.doTaskFailTry();
        }
    }

    private void doRunBatch() throws Exception {
        Connection conn = null;
        try {
            String genAlDesc;
            conn = TConnPool.getDefaultPool().getConnection();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            BatBatchInfoConfig batchConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u3010" + this.batchId + "\u3011\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            BatInstBatch batchInst = null;
            String subsId = batchConfig.getSubsId();
            SSubsInfo sSubsInfo = null;
            if (StringUtils.isNotBlank((CharSequence)subsId)) {
                sSubsInfo = BatchDataUtil.getSSubsInfo(conn, subsId);
            }
            if (sSubsInfo == null) {
                sSubsInfo = new SSubsInfo();
                batchInst = null;
            }
            if (StringUtils.isBlank((CharSequence)sSubsInfo.getSubsBatDate())) {
                sSubsInfo.setSubsBatDate(format.format(new Date()));
            }
            if (batchInst != null) {
                if (!"9".equals(batchInst.getBatchState())) {
                    throw new Exception("\u6279\u6b21\u5c1a\u672a\u5b8c\u6210\uff01");
                }
                String subsBatDate = sSubsInfo.getSubsBatDate();
                if (StringUtils.isBlank((CharSequence)subsBatDate)) {
                    throw new Exception("\u83b7\u53d6\u5b50\u7cfb\u7edf\u6279\u6b21\u5b8c\u6210\u65e5\u671f\u4e3a\u7a7a\uff01");
                }
                String batchDate = batchInst.getBatchDate();
                if (StringUtils.isBlank((CharSequence)batchDate)) {
                    throw new Exception("\u83b7\u53d6\u6279\u6b21\u5b9e\u4f8b\u8868\u4e2d\u7684\u6279\u6b21\u65e5\u671f\u4e3a\u7a7a\uff01");
                }
                if (format.parse(subsBatDate).before(format.parse(batchDate)) && !"Y".equals(batchConfig.getIsRunAgain())) {
                    throw new Exception("\u4e0a\u4e00\u65e5\u671f\u3010" + subsBatDate + "\u3011\u7684\u6279\u6b21\u5c1a\u672a\u8fd0\u884c\u6210\u529f\uff01");
                }
                if (format.parse(subsBatDate).after(format.parse(batchDate)) && !"Y".equals(batchConfig.getIsRunAgain())) {
                    throw new Exception("\u4e0a\u6b21\u6279\u6b21\u5b8c\u6210\u65e5\u671f\u3010" + subsBatDate + "\u3011\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            if (StringUtils.isBlank((CharSequence)this.batchSerialNo)) {
                String cond = " where batch_id = '" + this.batchId + "'";
                this.dataMove(conn, "bat_inst_batch", "bat_inst_batch_h", cond);
                this.dataMove(conn, "bat_inst_task", "bat_inst_task_h", cond);
                this.dataMove(conn, "plugin_exec_log", "plugin_exec_log_h", " where batch_sn like '" + this.batchId + "%'");
            }
            String condition1 = " where batch_id = '" + this.batchId + "'";
            TableMove batchDataMoveInst = DataMoveUtil.createTableMoveInst(conn, "bat_batch_info_config", "bat_inst_batch");
            String batchDate = DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(sSubsInfo.getSubsBatDate()), 1));
            String preString = this.batchId + batchDate.replace("-", "");
            String no = "1";
            String batchSerialNo = preString + no;
            if (batchInst != null && StringUtils.isBlank((CharSequence)this.batchSerialNo)) {
                String bab = batchInst.getBatchSerialNo().substring(0, preString.length());
                no = batchInst.getBatchSerialNo().substring(preString.length(), batchInst.getBatchSerialNo().length());
                if ("M".equals(batchConfig.getIsRunAgain()) && bab.equals(preString)) {
                    batchSerialNo = preString + (Integer.valueOf(no) + 1);
                }
            } else {
                batchSerialNo = this.batchSerialNo;
                if (StringUtils.isBlank((CharSequence)sSubsInfo.getSubsId()) && StringUtils.isBlank((CharSequence)subsId) && this.param != null) {
                    subsId = MapUtils.getString(this.param, (Object)"subsId");
                    sSubsInfo.setSubsId(subsId);
                }
            }
            String alDesc = batchConfig.getBatchName();
            String startTime = CurrentDateUtil.getTodayDateEx2();
            batchDataMoveInst.addValueMapping("batch_serial_no", batchSerialNo);
            batchDataMoveInst.addValueMapping("subs_id", sSubsInfo.getSubsId());
            batchDataMoveInst.addValueMapping("subs_code", sSubsInfo.getSubsCode());
            batchDataMoveInst.addValueMapping("batch_order", no);
            batchDataMoveInst.addValueMapping("batch_date", batchDate);
            batchDataMoveInst.addValueMapping("start_time", startTime);
            batchDataMoveInst.addValueMapping("batch_state", String.valueOf(8));
            batchDataMoveInst.addValueMapping("batch_intervene_state", String.valueOf(0));
            if (this.param != null) {
                batchDataMoveInst.addValueMapping("ext_param", MapUtils.getString(this.param, (Object)"extParam"));
                if (MapUtils.getString(this.param, (Object)"subsId") != null) {
                    batchDataMoveInst.addValueMapping("subs_id", MapUtils.getString(this.param, (Object)"subsId"));
                }
            }
            HashMap<String, Object> genParam = new HashMap<String, Object>();
            genParam.put("batchSerialNo", batchSerialNo);
            genParam.put("subsId", sSubsInfo.getSubsId());
            genParam.put("batchOrder", no);
            genParam.put("batchDate", batchDate);
            genParam.put("startTime", startTime);
            genParam.put("batchInterveneState", String.valueOf(0));
            genParam.put("envId", this.envId);
            if (this.param != null) {
                genParam.putAll(this.param);
            }
            if (StringUtils.isNotBlank((CharSequence)sSubsInfo.getSubsId()) && (sSubsInfo = BatchDataUtil.getSSubsInfo(conn, sSubsInfo.getSubsId())) != null) {
                genParam.put("subsCode", sSubsInfo.getSubsCode());
                genParam.put("subsName", sSubsInfo.getSubsName());
            }
            if (StringUtils.isNotBlank((CharSequence)(genAlDesc = this.genAlDesc(batchConfig.getAlDescTemplate(), batchConfig, genParam)))) {
                alDesc = genAlDesc;
            }
            batchDataMoveInst.addValueMapping("al_desc", alDesc);
            batchDataMoveInst.setCondition(condition1);
            batchDataMoveInst.executeCopy();
            String sql1 = "insert into bat_inst_task(batch_id,batch_order,batch_date,task_id,task_name,stage_id,stage_name,task_run_state,task_intervene_state,batch_serial_no)";
            String sql2 = "select a.batch_id,'" + no + "' as batch_order,'" + batchDate + "' as batch_date,a.task_id,a.task_name,a.stage_id,b.stage_name,\t'" + 0 + "' as task_run_state,'" + 0 + "' as task_intervene_state, '" + batchSerialNo + "' as batch_serial_no  from bat_task_unit_config a,bat_batch_stage_config b where a.batch_id='" + this.batchId + "' and a.task_use_state='0' and (a.task_use_area = '1' or a.task_use_area = '2') and a.batch_id = b.batch_id  and a.stage_id = b.stage_id ";
            boolean moveFlag = DataMoveUtil.executeCustomCopy(conn, sql1, sql2);
            if (moveFlag) {
                BatchRunProcess batRunProcess = new BatchRunProcess(batchSerialNo, batchConfig);
                batRunProcess.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private String genAlDesc(String alDescTemplate, BatBatchInfoConfig batchConfig, Map<String, Object> param) {
        if (StringUtils.isBlank((CharSequence)alDescTemplate)) {
            return null;
        }
        try {
            Map root = MapBeanUtil.beanToMap((Object)batchConfig);
            root.putAll(param);
            String extParam = MapUtils.getString(param, (Object)"extParam");
            try {
                Map extParamMap = (Map)JSON.parseObject((String)extParam, Map.class);
                root.put("extParam", extParamMap);
            }
            catch (Exception extParamMap) {
                // empty catch block
            }
            String alDesc = ExpressionUtil.parse(alDescTemplate, root);
            return alDesc;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void doStopBatch() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            BatBatchInfoConfig batBatchInfoConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batBatchInfoConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            BatInstTaskDao batInstTaskDao = new BatInstTaskDao(conn);
            String szCondition = "where batch_id = '" + this.batchId + "' and task_run_state = '2'";
            List<BatInstTask> batInstTaskList = batInstTaskDao.queryWithCond(szCondition, "");
            if (batInstTaskList.size() == 0) {
                throw new Exception("\u5f53\u524d\u6279\u6b21\u4e0d\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff01");
            }
            for (BatInstTask instTask : batInstTaskList) {
                String batchSerialNo = instTask.getBatchSerialNo();
                String taskId = instTask.getTaskId();
                BatTaskUnitConfigDao batTaskUnitConfigDao = new BatTaskUnitConfigDao(conn);
                String condition = " where previous_task_id = '" + taskId + "'";
                List<BatTaskUnitConfig> batTaskUnitConfigList = batTaskUnitConfigDao.queryWithCond(condition, "");
                if (batTaskUnitConfigList.size() == 0) continue;
                Iterator<BatTaskUnitConfig> batTaskUnitConfigIt = batTaskUnitConfigList.iterator();
                while (batTaskUnitConfigIt.hasNext()) {
                    String nextTaskId = batTaskUnitConfigIt.next().getTaskId();
                    String condi = " set task_run_state = '7' where batch_id = '" + this.batchId + "' and task_id = '" + nextTaskId + "' and batch_serial_no = '" + batchSerialNo + "'";
                    batInstTaskDao.updateBatInstTask(condi);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doRerunBatch() throws Exception {
        Connection conn = null;
        try {
            conn = ConnectionUtil.getConnection();
            BatBatchInfoConfig batchConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String isRunAgain = batchConfig.getIsRunAgain();
            if (StringUtils.isBlank((CharSequence)isRunAgain)) {
                throw new Exception("\u67e5\u8be2\u662f\u5426\u5141\u8bb8\u91cd\u8dd1\u6807\u8bc6\u4e3a\u7a7a\uff01");
            }
            if ("N".equals(isRunAgain)) {
                throw new Exception("\u8be5\u6279\u6b21\u4e0d\u652f\u6301\u91cd\u8dd1\uff01");
            }
            BatInstBatch batchInst = BatchDataUtil.getBatInstBatch(conn, this.batchId);
            if (batchInst == null) {
                throw new Exception("\u672a\u627e\u5230\u91cd\u8dd1\u7684\u6279\u6b21\uff01");
            }
            String batchState = batchInst.getBatchState();
            if ("3".equals(batchState) || "8".equals(batchState)) {
                throw new Exception("\u6279\u6b21\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u91cd\u8dd1\uff01");
            }
            String cond = " where batch_id = '" + this.batchId + "'";
            this.dataMove(conn, "bat_inst_batch", "bat_inst_batch_h", cond);
            this.dataMove(conn, "bat_inst_task", "bat_inst_task_h", cond);
            String condi1 = " where batch_id = '" + this.batchId + "'";
            TableMove batchDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "bat_inst_batch", "bat_inst_batch");
            batchDataMoveUtil.setCondition(condi1);
            String batchSerialNo = batchInst.getBatchSerialNo();
            String lastTwoSerial = batchSerialNo.substring(batchSerialNo.length() - 1, batchSerialNo.length());
            lastTwoSerial = Integer.parseInt(lastTwoSerial) < 10 ? "0" + (Integer.parseInt(lastTwoSerial) + 1) : "" + (Integer.parseInt(lastTwoSerial) + 1);
            batchSerialNo = batchSerialNo.substring(0, batchSerialNo.length() - 2) + lastTwoSerial;
            batchDataMoveUtil.addValueMapping("batch_serial_no", batchSerialNo);
            batchDataMoveUtil.addValueMapping("batch_order", batchInst.getBatchOrder() + 1);
            batchDataMoveUtil.executeCopy();
            String condi = " where batch_id = '" + this.batchId + "' and task_use_state='0' and (task_use_area = '1' or task_use_area = '3') ";
            TableMove taskDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "bat_task_unit_config", "bat_inst_task");
            taskDataMoveUtil.setCondition(condi);
            taskDataMoveUtil.executeCopy();
            BatchRunProcess batRunProcess = new BatchRunProcess(batchConfig);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ConnectionUtil.releaseConnection(conn);
        }
    }

    private void doContinueBatch() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            BatBatchInfoConfig batchConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.batchSerialNo)) {
                throw new Exception("\u6279\u6b21\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BatInstTaskDao taskInstDao = new BatInstTaskDao(conn);
            taskInstDao.resetFaildTask(this.batchId, this.batchSerialNo);
            BatchRunProcess batRunProcess = new BatchRunProcess(batchConfig);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doTaskFailTry() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            BatInstTaskDao batInstTaskDao = new BatInstTaskDao(conn);
            BatBatchInfoConfig batchConfig = BatchDataUtil.getBatBatchInfoConfig(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u6279\u6b21\u6807\u8bc6\u67e5\u8be2\u6279\u6b21\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.batchSerialNo)) {
                throw new Exception("\u6279\u6b21\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BatInstBatch batInstBatch = BatchDataUtil.getBatInstBatchByBatchSerialNo(conn, this.batchSerialNo);
            Map extParam = (Map)JSON.parseObject((String)MapUtils.getString(this.param, (Object)"extParam"), Map.class);
            String taskId = MapUtils.getString((Map)extParam, (Object)"taskId");
            String condition = " where batch_id = '" + this.batchId + "' and task_id = '" + taskId + "'";
            BatTaskUnitConfigDao batTaskUnitConfigDao = new BatTaskUnitConfigDao(conn);
            List<BatTaskUnitConfig> batTaskUnitConfigList = batTaskUnitConfigDao.queryWithCond(condition, "");
            BatTaskUnitConfig taskConf = batTaskUnitConfigList.get(0);
            BatInstTask taskInst = new BatInstTask();
            taskInst.setBatchSerialNo(this.batchSerialNo);
            taskInst.setBatchId(batchConfig.getBatchId());
            taskInst.setTaskId(taskConf.getTaskId());
            taskInst.setTaskName(taskConf.getTaskName());
            String condi = " set task_run_state = '2' where batch_id = '" + this.batchId + "' and task_id = '" + taskId + "' and batch_serial_no = '" + this.batchSerialNo + "'";
            batInstTaskDao.updateBatInstTask(condi);
            BatchRunProcess batRunProcess = new BatchRunProcess(this.batchSerialNo, batchConfig);
            BatchTaskThread taskThread = new BatchTaskThread(batInstBatch, taskInst, taskConf, batRunProcess);
            taskThread.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    public void dataMove(Connection conn, String srcTableName, String destTableName, String cond) throws SQLException {
        TableMove dataMoveInst = DataMoveUtil.createTableMoveInst(conn, srcTableName, destTableName);
        dataMoveInst.setCondition(cond);
        dataMoveInst.executeCut();
    }
}

