/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.dao;

import com.irdstudio.allintpaas.batch.engine.executor.core.dao.domain.BatInstBatchH;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatInstBatchHDao {
    Connection conn = null;

    public BatInstBatchHDao(Connection conn) {
        this.conn = conn;
    }

    public BatInstBatchH queryWithKeys(String batchSerialNo) throws SQLException {
        BatInstBatchH dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch_h WHERE batch_serial_no=?");
            ps.setString(1, batchSerialNo);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (BatInstBatchH)POJOUtils.generatePOJO((ResultSet)rs, BatInstBatchH.class);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchHWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatInstBatchH> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatInstBatchH> dcList = new ArrayList<BatInstBatchH>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch_h " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatInstBatchH dc = (BatInstBatchH)POJOUtils.generatePOJO((ResultSet)rs, BatInstBatchH.class);
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchHWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

