/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.util.sequence;

import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.log.ILogger;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.log.TLogger;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.pub.ConnectionUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class SequenceService {
    private static final ILogger logger = TLogger.getLogger("SEQ");
    private static String sequenceDate = null;
    private static final int BUFFER_STEP = 20;
    private static HashMap<String, SerialNumber> serialNumberBuffer = new HashMap();
    private static SequenceService seqUtil = new SequenceService();

    public static synchronized String getNextValue(String bizType, String owner, Connection connection) throws Exception {
        String symbol = bizType + owner;
        SerialNumber sbean = null;
        String openday = ConnectionUtil.getSysTime();
        if (!openday.equals(sequenceDate)) {
            serialNumberBuffer.clear();
            sequenceDate = openday;
        }
        if (serialNumberBuffer.containsKey(symbol)) {
            sbean = serialNumberBuffer.get(symbol);
            if (sbean.currentValue.equals(sbean.bufferedValue)) {
                SerialNumber serialNumber = sbean = SequenceService.querySequenceFromDB2(bizType, owner);
                serialNumber.currentValue = serialNumber.currentValue + (long)sbean.step;
                serialNumberBuffer.put(symbol, sbean);
            } else {
                SerialNumber serialNumber = sbean;
                serialNumber.currentValue = serialNumber.currentValue + (long)sbean.step;
            }
        } else {
            SequenceService sequenceService = seqUtil;
            sequenceService.getClass();
            sbean = sequenceService.new SerialNumber();
            sbean = SequenceService.querySequenceFromDB2(bizType, owner);
            serialNumberBuffer.put(symbol, sbean);
        }
        return new Long(sbean.currentValue).toString();
    }

    private static synchronized SerialNumber querySequenceFromDB2(String bizType, String owner) throws Exception {
        ResultSet rs = null;
        SequenceService sequenceService = seqUtil;
        sequenceService.getClass();
        SerialNumber sbean = sequenceService.new SerialNumber();
        Statement pstmt2 = null;
        Statement pstmt = null;
        Connection connection = null;
        try {
            connection = ConnectionUtil.getConnection();
            String sqlStr = "select INITCYCLE, CUR_SERNUM from s_autocode where ATYPE=? and OWNER=?";
            String sqlStr2 = "update s_autocode set CUR_SERNUM = ? where ATYPE=? and OWNER=?";
            pstmt = connection.prepareStatement(sqlStr);
            pstmt.setString(1, bizType);
            pstmt.setString(2, owner);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                logger.error("Can not found the sequence by [bizType=" + bizType + " and owner=" + owner + "], beacuse Sequence next is erro ");
                throw new Exception("Can not found the sequence by [bizType=" + bizType + " and owner=" + owner + "], beacuse Sequence  next is erro ");
            }
            sbean.step = new Integer(rs.getString("INITCYCLE"));
            sbean.currentValue = new Long(rs.getString("CUR_SERNUM"));
            sbean.bufferedValue = sbean.currentValue + (long)sbean.bufferStep - 1L;
            sbean.flag = false;
            pstmt2 = connection.prepareStatement(sqlStr2);
            pstmt2.setLong(1, sbean.bufferedValue);
            pstmt2.setString(2, bizType);
            pstmt2.setString(3, owner);
            pstmt2.executeUpdate();
            SerialNumber serialNumber = sbean;
            return serialNumber;
        }
        catch (Exception e) {
            logger.error("The CMISSequenceService4Oracle occur an error:" + e.getMessage());
            throw new Exception(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (pstmt2 != null) {
                try {
                    pstmt2.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ConnectionUtil.releaseConnection(connection);
        }
    }

    public static synchronized String querySequenceFromDB(String sequenceName, Connection connection) throws Exception {
        String sqlStr = null;
        ResultSet rs = null;
        String cur_sernum = null;
        Statement stmt = null;
        try {
            sqlStr = "select to_char(" + sequenceName + ".nextval) from dual";
            stmt = connection.createStatement();
            rs = stmt.executeQuery(sqlStr);
            if (!rs.next()) {
                logger.error("Can not found the sequence: " + sequenceName + ", beacuse Sequence  next is erro ");
                throw new Exception("Can not found the sequence: " + sequenceName + ", beacuse Sequence  next is erro ");
            }
            cur_sernum = rs.getString(1);
            cur_sernum = String.format("%1$6s", cur_sernum).replaceAll("\\s", "0");
            String string = cur_sernum;
            return string;
        }
        catch (Exception e) {
            logger.error("The CMISSequenceService4Oracle occur an error:" + e.getMessage());
            throw new Exception(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class SerialNumber {
        public Long currentValue;
        public int step;
        public int bufferStep = 20;
        public Long bufferedValue;
        public boolean flag;

        private SerialNumber() {
        }
    }
}

