/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.plugin;

import com.irdstudio.allintpaas.batch.engine.executor.core.plugin.common.SSubsDatasource;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.parse.VariableParserUtil;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.vo.VariableValue;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PluginContext {
    private VariableValue vv;
    private String szLastErrorMsg = "";
    private int nFaildSkipCount = 0;
    private int nPluginId;
    private String szPluginName;
    private int nPluginConfType;
    private String szPluginConfId;
    private String szBatchSn;
    private String szBatchId;
    private String szTaskId;
    private String szTaskName;
    private String szSubsCode;
    private String szSubsDsCode;
    private SSubsDatasource dsInfo = null;
    private IConnPool connPool = null;
    private long startMills;

    public PluginContext(int nPluginId, String szPluginName, int nPluginConfType, String szPluginConfIdentify, String szBatchSn, String szTaskId, String szTaskName) {
        this.nPluginId = nPluginId;
        this.szPluginName = szPluginName;
        this.szBatchSn = szBatchSn;
        this.szTaskId = szTaskId;
        this.szTaskName = szTaskName;
        this.szLastErrorMsg = "";
        this.startMills = System.currentTimeMillis();
    }

    public PluginContext() {
        this.startMills = System.currentTimeMillis();
    }

    public String toParseSysVariable(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        return VariableParserUtil.parseString(str, this.vv);
    }

    public String toParseFieldVariable(String str, ResultSet rs) {
        if (str == null || "".equals(str)) {
            return "";
        }
        return VariableParserUtil.parseString(str, rs);
    }

    public String getCurrentDataDate() {
        return this.vv.getValue("subs_data_date");
    }

    public String getLastDataDate() {
        return this.vv.getValue("subs_last_data_date");
    }

    public String getLoadFinishedDate() {
        return this.vv.getValue("subs_load_date");
    }

    public String getBatFinishedDate() {
        return this.vv.getValue("subs_bat_date");
    }

    public String getNextDataDate() {
        return this.vv.getValue("subs_next_data_date");
    }

    public String getSubsCode() {
        return this.vv.getValue("subs_code");
    }

    public SSubsDatasource getDataSourceInfo() {
        return this.dsInfo;
    }

    public void setDataSourceInfo(SSubsDatasource dsInfo) {
        this.dsInfo = dsInfo;
    }

    public VariableValue getVv() {
        return this.vv;
    }

    public void setVv(VariableValue vv) {
        this.vv = vv;
    }

    public String getLastErrorMsg() {
        if (this.szLastErrorMsg == null) {
            return "";
        }
        return this.szLastErrorMsg;
    }

    public long getStartMills() {
        return this.startMills;
    }

    public void setConnPool(IConnPool pluginConnPool) {
        this.connPool = pluginConnPool;
    }

    public Connection getPluginConnection() throws SQLException {
        return this.connPool.getConnection();
    }

    public void releasePluginConnection(Connection conn) {
        this.connPool.releaseConnection(conn);
    }

    public String getSzLastErrorMsg() {
        return this.szLastErrorMsg;
    }

    public void setSzLastErrorMsg(String szLastErrorMsg) {
        this.szLastErrorMsg = szLastErrorMsg;
    }

    public int getnFaildSkipCount() {
        return this.nFaildSkipCount;
    }

    public void setnFaildSkipCount(int nFaildSkipCount) {
        this.nFaildSkipCount = nFaildSkipCount;
    }

    public int getnPluginId() {
        return this.nPluginId;
    }

    public void setnPluginId(int nPluginId) {
        this.nPluginId = nPluginId;
    }

    public String getSzPluginName() {
        return this.szPluginName;
    }

    public void setSzPluginName(String szPluginName) {
        this.szPluginName = szPluginName;
    }

    public int getnPluginConfType() {
        return this.nPluginConfType;
    }

    public void setnPluginConfType(int nPluginConfType) {
        this.nPluginConfType = nPluginConfType;
    }

    public String getSzPluginConfId() {
        return this.szPluginConfId;
    }

    public void setSzPluginConfId(String szPluginConfId) {
        this.szPluginConfId = szPluginConfId;
    }

    public String getSzBatchSn() {
        return this.szBatchSn;
    }

    public void setSzBatchSn(String szBatchSn) {
        this.szBatchSn = szBatchSn;
    }

    public String getSzBatchId() {
        return this.szBatchId;
    }

    public void setSzBatchId(String szBatchId) {
        this.szBatchId = szBatchId;
    }

    public String getSzTaskId() {
        return this.szTaskId;
    }

    public void setSzTaskId(String szTaskId) {
        this.szTaskId = szTaskId;
    }

    public String getSzTaskName() {
        return this.szTaskName;
    }

    public void setSzTaskName(String szTaskName) {
        this.szTaskName = szTaskName;
    }

    public String getSzSubsCode() {
        return this.szSubsCode;
    }

    public void setSzSubsCode(String szSubsCode) {
        this.szSubsCode = szSubsCode;
    }

    public String getSzSubsDsCode() {
        return this.szSubsDsCode;
    }

    public void setSzSubsDsCode(String szSubsDsCode) {
        this.szSubsDsCode = szSubsDsCode;
    }

    public SSubsDatasource getDsInfo() {
        return this.dsInfo;
    }

    public void setDsInfo(SSubsDatasource dsInfo) {
        this.dsInfo = dsInfo;
    }

    public IConnPool getConnPool() {
        return this.connPool;
    }

    public void setStartMills(long startMills) {
        this.startMills = startMills;
    }
}

