/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.assembly.etl;

import com.irdstudio.allintpaas.batch.engine.executor.core.assembly.etl.conf.GlobalConf;
import com.irdstudio.allintpaas.batch.engine.executor.core.assembly.etl.conf.ReadProperties;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.pub.Convert;

public class ETLConfigure {
    private static ETLConfigure instance = new ETLConfigure();

    private ETLConfigure() {
    }

    public static ETLConfigure getInstance() {
        return instance;
    }

    public boolean loadGlobal() {
        if (GlobalConf.getFILE_PATH() != null) {
            return true;
        }
        ReadProperties read = new ReadProperties();
        boolean isOk = true;
        System.out.println("Loading global config...");
        switch (read.openFile("etl.conf")) {
            case 1: {
                GlobalConf.setRAR_FILE_PATH(read.get("etl.RarFilePath"));
                GlobalConf.setRAR_BAK_PATH_TMP(read.get("etl.RarBakPathTmp"));
                GlobalConf.setRAR_DECOMP_CMD(read.get("etl.RarDecompCmd"));
                GlobalConf.setROOT_PATH(read.get("etl.RootPath"));
                GlobalConf.setFILE_PATH(read.get("etl.FilePath"));
                GlobalConf.setBACKUP_PATH(read.get("etl.BackupPath"));
                GlobalConf.setLOG_PATH(read.get("etl.LogPath"));
                GlobalConf.setTABLECONF_PATH(read.get("etl.tableconf"));
                GlobalConf.setCONN_CLASSNAME(read.get("service.pool.classname"));
                GlobalConf.setCONN_URL(read.get("service.pool.datasource.url"));
                GlobalConf.setCONN_USER(read.get("service.pool.datasource.user"));
                GlobalConf.setCONN_PASS(read.get("service.pool.datasource.pass"));
                GlobalConf.setCONN_MIN(Convert.StrToInt(read.get("service.pool.connection.min"), 5));
                GlobalConf.setCONN_MAX(Convert.StrToInt(read.get("service.pool.connection.max"), 10));
                GlobalConf.setSTART_ON_INIT(Convert.StrToBoolean(read.get("service.pool.start_on_init")));
                GlobalConf.setFTP_IP(read.get("ftp.ip"));
                GlobalConf.setFTP_USER(read.get("ftp.user"));
                GlobalConf.setFTP_PASS(read.get("ftp.pass"));
                GlobalConf.setFTP_PATH(read.get("ftp.filePath"));
                GlobalConf.setPATH_SEPARATOR(read.get("path.separator"));
                GlobalConf.setCHECK_CONTENT(Convert.StrToBoolean(read.get("Import.CheckContent")));
                GlobalConf.setIS_BACKUP(Convert.StrToBoolean(read.get("etl.backup")));
                GlobalConf.setINTERVAL(Convert.StrToInt(read.get("etl.interval"), -1));
                String tmp = read.get("etl.CharacterSet");
                GlobalConf.setCHAR_SET(tmp == null || tmp.equals("") ? "ISO8859-1" : tmp);
                GlobalConf.setIsAllOnTrans(Convert.StrToBoolean(read.get("Logic.isAllOnTrans")));
                GlobalConf.setIsOnTrans(Convert.StrToBoolean(read.get("Logic.isOnTrans")));
                break;
            }
            case 2: {
                isOk = false;
                System.out.println("\u6ca1\u6709\u627e\u5230etl.conf\u6587\u4ef6!");
                break;
            }
            case 3: {
                isOk = false;
                System.out.println("io\u5f02\u5e38!");
            }
        }
        read.closeFile();
        return isOk;
    }
}

