/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.assembly.license;

import com.irdstudio.allintpaas.batch.engine.executor.core.assembly.license.dm.SInstLicense;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.crypt.DesBinaryFileReader;
import com.irdstudio.allintpaas.batch.engine.executor.core.util.crypt.DesBinaryFileWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUtil {
    private static final Logger logger = LoggerFactory.getLogger(LicenseUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLicenseFile(String licenseFileName, String sysCode, String ip, String port, String sysName, String authTarget, String authBeginDate, String authEndDate, String remarks) {
        DesBinaryFileWriter dbfw = null;
        try {
            dbfw = new DesBinaryFileWriter(new DataOutputStream(new FileOutputStream(licenseFileName)));
            dbfw.writeEncryptString(sysCode);
            dbfw.writeEncryptString(ip);
            dbfw.writeEncryptString(port);
            dbfw.writeEncryptString(sysName);
            dbfw.writeEncryptString(authTarget);
            dbfw.writeEncryptString(authBeginDate);
            dbfw.writeEncryptString(authEndDate);
            dbfw.writeEncryptString(remarks);
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IO\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (dbfw != null) {
                try {
                    dbfw.close();
                    dbfw = null;
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edDesBinaryFileWriter\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SInstLicense readLicenseFile(String licenseFileName) {
        SInstLicense instLicense = null;
        DesBinaryFileReader dbfr = null;
        try {
            dbfr = new DesBinaryFileReader(new DataInputStream(new FileInputStream(licenseFileName)));
            instLicense = new SInstLicense();
            instLicense.setSysCode(dbfr.readDecryptString().toUpperCase());
            instLicense.setHostName(dbfr.readDecryptString());
            instLicense.setWebPort(dbfr.readDecryptString());
            instLicense.setSysName(dbfr.readDecryptString());
            instLicense.setAuthTarget(dbfr.readDecryptString());
            instLicense.setAuthBeginDate(dbfr.readDecryptString());
            instLicense.setAuthEndDate(dbfr.readDecryptString());
            instLicense.setRemark(dbfr.readDecryptString());
            instLicense.setSysInstId(instLicense.getSysCode() + "_" + instLicense.getHostName() + "_" + instLicense.getWebPort());
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IO\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (dbfr != null) {
                try {
                    dbfr.close();
                    dbfr = null;
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edDesBinaryFileReader\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return instLicense;
    }

    public static void main(String[] args) {
    }
}

