/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.dao;

import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageDao {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPageDao.class);
    private Connection conn = null;

    public AbstractPageDao(Connection conn) {
        this.conn = conn;
    }

    public String buildPageSql(BaseInfo pageInfo, String sql) {
        int offset = (pageInfo.getPage() - 1) * pageInfo.getSize();
        return sql + " limit " + offset + "," + pageInfo.getSize();
    }

    public String buildCountSql(String sql) {
        return "select count(1) from (" + sql + ") t";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryTotalRecord(String sql, BaseInfo page, List params) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            String countSql = this.buildCountSql(sql);
            ps = this.conn.prepareStatement(countSql);
            for (int i = 0; i < params.size(); ++i) {
                ps.setObject(i + 1, params.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                int totalRecord = rs.getInt(1);
                page.setTotal(Integer.valueOf(totalRecord));
                logger.info("\u67e5\u8be2\u5230\u7684\u603b\u9875\u6570\u4e3a:" + totalRecord);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u67e5\u8be2\u603b\u9875\u6570sql\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

