/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.admin.autoconfigure;

import com.irdstudio.allintpaas.sdk.admin.web.operation.E4AController;
import com.irdstudio.allintpaas.sdk.admin.web.ssm.session.SessionManager;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.web.filter.CORSFilter;
import javax.servlet.Filter;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={E4AController.class})
@ComponentScan(value={"com.irdstudio.allintpaas.sdk.admin"})
public class SdkAdminAutoConfiguration {
    @Value(value="${e4a.sessionTimeOut:3600000}")
    private int sessionTimeOut;

    @Bean
    public MapperScannerConfigurer adminMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintpaas.sdk.admin.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils() {
        return new SpringContextUtils();
    }

    @Bean
    @ConditionalOnMissingBean(value={SessionManager.class})
    public SessionManager sessionManager() {
        SessionManager sessionManager = new SessionManager();
        sessionManager.setSessionTimeOut(this.sessionTimeOut);
        return sessionManager;
    }

    public Filter corsFilter() {
        CORSFilter corsFilter = new CORSFilter();
        return corsFilter;
    }

    public FilterRegistrationBean corsFilterReg() {
        FilterRegistrationBean reg = new FilterRegistrationBean();
        reg.setFilter(this.corsFilter());
        reg.setName("corsFilter");
        reg.setOrder(1);
        return reg;
    }

    @Configuration
    @EnableWebMvc
    public class AdminMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

