/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.report.manual.application.operation;

import com.irdstudio.allintpaas.sdk.job.application.operation.JobAbstractServiceImpl;
import com.irdstudio.allintpaas.sdk.job.facade.operation.JobBaseService;
import com.irdstudio.allintpaas.sdk.job.facade.operation.dto.JobExecuteParamDTO;
import com.irdstudio.allintpaas.sdk.report.acl.repository.RptInstInfoRepository;
import com.irdstudio.allintpaas.sdk.report.acl.repository.RptModelInfoRepository;
import com.irdstudio.allintpaas.sdk.report.domain.entity.RptInstInfoDO;
import com.irdstudio.allintpaas.sdk.report.domain.entity.RptModelInfoDO;
import com.irdstudio.allintpaas.sdk.report.types.StdPubYnEnum;
import com.irdstudio.framework.beans.core.spring.ExpressionUtil;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service(value="InstanceReportServiceImpl")
public class InstanceReportServiceImpl
extends JobAbstractServiceImpl
implements JobBaseService,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static final String JOB_ID = "\u62a5\u8868\u5b9e\u4f8b\u5316";
    @Autowired
    private RptModelInfoRepository rptModelInfoRepository;
    @Autowired
    private RptInstInfoRepository rptInstInfoRepository;

    public int execute(JobExecuteParamDTO param) {
        int output = 0;
        try {
            RptModelInfoDO rptModelParam = new RptModelInfoDO();
            rptModelParam.setRptInstFlag(StdPubYnEnum.Y.getCode());
            List rptModelList = this.rptModelInfoRepository.queryList((Object)rptModelParam);
            if (CollectionUtils.isNotEmpty((Collection)rptModelList)) {
                for (RptModelInfoDO rptModel : rptModelList) {
                    String sql = rptModel.getRptInstSql();
                    HashMap rootParams = new HashMap();
                    Map rptModelMap = BeanUtility.bean2Map((Object)rptModel);
                    Set keys = rptModelMap.keySet();
                    for (String key : keys) {
                        rootParams.put(POJOUtils.javaPropToColName((String)key), rptModelMap.get(key));
                    }
                    if (StringUtils.isBlank((CharSequence)sql)) {
                        RptInstInfoDO rptInst = this.copyRpt(rptModel);
                        String instId = ExpressionUtil.parse((String)rptModel.getRptInstId(), rootParams);
                        String instPage = ExpressionUtil.parse((String)rptModel.getRptInstPage(), rootParams);
                        String instName = ExpressionUtil.parse((String)rptModel.getRptInstName(), rootParams);
                        rptInst.setRptInstId(instId);
                        rptInst.setRptInstName(instName);
                        rptInst.setRptInstPage(instPage);
                        boolean bl = this.saveRptInst(rptInst);
                        continue;
                    }
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("sql", sql);
                    List result = this.getSqlSession().selectList("com.irdstudio.allintpaas.sdk.report.manual.infra.persistence.mapper.RptInstInfoManualMapper.selectInstSql", params);
                    if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                    for (Map el : result) {
                        rootParams.putAll(el);
                        RptInstInfoDO rptInst = this.copyRpt(rptModel);
                        String instId = ExpressionUtil.parse((String)rptModel.getRptInstId(), rootParams);
                        String instPage = ExpressionUtil.parse((String)rptModel.getRptInstPage(), rootParams);
                        String instName = ExpressionUtil.parse((String)rptModel.getRptInstName(), rootParams);
                        rptInst.setRptInstId(instId);
                        rptInst.setRptInstName(instName);
                        rptInst.setRptInstPage(instPage);
                        boolean bl = this.saveRptInst(rptInst);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5ffd\u7565\u4f5c\u4e1a{}\u6267\u884cSQL\u5f02\u5e38{}", new Object[]{JOB_ID, e.getMessage(), e});
        }
        return output;
    }

    private RptInstInfoDO copyRpt(RptModelInfoDO rptModel) {
        RptInstInfoDO rptInst = new RptInstInfoDO();
        BeanUtility.beanCopy((Object)rptModel, (Object)rptInst);
        rptInst.setRptModelId(rptModel.getRptModelId());
        rptInst.setRptInstCode(rptModel.getRptModelCode());
        rptInst.setRptInstName(rptModel.getRptModelName());
        rptInst.setRptInstCategory(rptModel.getRptModelCategory());
        rptInst.setRptInstType(rptModel.getRptModelType());
        rptInst.setRptInstCycle(rptModel.getRptModelCycle());
        rptInst.setRptInstRealtime(rptModel.getRptModelRealtime());
        rptInst.setRptInstExcel(rptModel.getRptModelExcel());
        rptInst.setRptInstPage(rptModel.getRptModelPage());
        rptInst.setRptInstParams(rptModel.getRptModelParams());
        rptInst.setRptSubscribeFlag(rptModel.getRptSubscribeFlag());
        rptInst.setRptFillFlag(rptModel.getRptFillFlag());
        rptInst.setRptInstVisit(rptModel.getRptModelVisit());
        return rptInst;
    }

    private boolean saveRptInst(RptInstInfoDO rptInst) {
        int num = 0;
        num = this.rptInstInfoRepository.updateByPk((Object)rptInst);
        if (num <= 0) {
            num = this.rptInstInfoRepository.insert((Object)rptInst);
        }
        return num == 1;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.initService(applicationContext);
    }
}

