/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.report.manual.application.operation;

import com.irdstudio.allintpaas.sdk.report.facade.operation.RptInstInfoService;
import com.irdstudio.allintpaas.sdk.report.facade.operation.dto.RptInstInfoDTO;
import com.irdstudio.allintpaas.sdk.report.manual.facade.operation.RptExportManualService;
import com.irdstudio.framework.beans.core.util.CookiesUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.print.PageSize;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service(value="RptExportManualServiceImpl")
public class RptExportManualServiceImpl
implements RptExportManualService {
    private static Logger logger = LoggerFactory.getLogger(RptExportManualServiceImpl.class);
    @Autowired
    private RptInstInfoService rptInstInfoService;
    @Value(value="${allintpaas.sdk.report.export.path:/var/tmp/apps/}")
    private String pdfFileStorageRoot;
    @Value(value="${chromium.webdriver:}")
    private String webDriver;
    @Value(value="${cas.client-host-url:}")
    private String serverHost;
    @Value(value="${server.servlet.contextPath:}")
    private String serverContextPath;
    @Autowired
    private HttpServletRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportToPdf(String rptInstId, String rptModelId, String startDate, String endDate) {
        RptInstInfoDTO instInfo = new RptInstInfoDTO();
        instInfo.setRptInstId(rptInstId);
        instInfo = this.rptInstInfoService.queryByPk(instInfo);
        String JSESSIONID = CookiesUtil.getCookieValue((HttpServletRequest)this.request, (String)"JSESSIONID");
        String TGC = CookiesUtil.getCookieValue((HttpServletRequest)this.request, (String)"TGC");
        String signUserId = CookiesUtil.getCookieValue((HttpServletRequest)this.request, (String)"signUserId");
        String ssoclient = CookiesUtil.getCookieValue((HttpServletRequest)this.request, (String)"ssoclient");
        String ssomd5 = CookiesUtil.getCookieValue((HttpServletRequest)this.request, (String)"ssomd5");
        String ssottp = CookiesUtil.getCookieValue((HttpServletRequest)this.request, (String)"ssottp");
        ChromeDriver driver = null;
        try {
            String url;
            System.setProperty("webdriver.chrome.driver", this.webDriver);
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"--headless"});
            options.addArguments(new String[]{"headless", "no-sandbox"});
            options.addArguments(new String[]{"--no-sandbox"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--window-size=1920,1024"});
            options.addArguments(new String[]{"--remote-allow-origins=*"});
            driver = new ChromeDriver(options);
            String serverHost = this.serverHost;
            if (StringUtils.endsWith((CharSequence)serverHost, (CharSequence)"/")) {
                serverHost = serverHost.substring(0, serverHost.length() - 1);
            }
            url = StringUtils.startsWith((CharSequence)(url = instInfo.getRptInstPage()), (CharSequence)"/") ? String.format("%s%s%s", serverHost, this.serverContextPath, url) : String.format("%s%s/%s", serverHost, this.serverContextPath, url);
            url = url + String.format("&startDate=%s&endDate=%s&mode=print", startDate, endDate);
            driver.get(url);
            String domain = serverHost.replace("https:", "").replace("http:", "").replace("/", "");
            driver.manage().addCookie(new Cookie("JSESSIONID", JSESSIONID, domain, this.serverContextPath, null));
            driver.manage().addCookie(new Cookie("TGC", JSESSIONID, domain, this.serverContextPath, null));
            driver.manage().addCookie(new Cookie("signUserId", JSESSIONID, domain, this.serverContextPath, null));
            driver.manage().addCookie(new Cookie("ssoclient", JSESSIONID, domain, this.serverContextPath, null));
            driver.manage().addCookie(new Cookie("ssomd5", JSESSIONID, domain, this.serverContextPath, null));
            driver.manage().addCookie(new Cookie("ssottp", JSESSIONID, domain, this.serverContextPath, null));
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, Duration.ofSeconds(60L));
            wait.until((Function)ExpectedConditions.visibilityOfAllElementsLocatedBy((By)By.className((String)"el-table__row")));
            PrintOptions printOptions = new PrintOptions();
            printOptions.setShrinkToFit(false);
            printOptions.setPageSize(new PageSize(38.6, 68.6));
            printOptions.setScale(1.2);
            Pdf webPdf = driver.print(printOptions);
            String base64Pdf = webPdf.getContent();
            byte[] decodedBytes = Base64Utils.decodeFromString((String)base64Pdf);
            File file = new File(this.pdfFileStorageRoot, rptInstId + ".pdf");
            try (FileOutputStream fop = new FileOutputStream(file);){
                IOUtils.write((byte[])decodedBytes, (OutputStream)fop);
            }
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            logger.error("\u62a5\u8868\u5bfc\u51fapdf\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
        return null;
    }
}

