/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.bi.application.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintpaas.sdk.bi.acl.repository.RdmModuleInfoRepository;
import com.irdstudio.allintpaas.sdk.bi.domain.entity.RdmModuleInfoDO;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.FilterItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RdmModuleInfoServiceImpl")
public class RdmModuleInfoServiceImpl
extends BaseServiceImpl<RdmModuleInfoDTO, RdmModuleInfoDO, RdmModuleInfoRepository>
implements RdmModuleInfoService {
    @Autowired
    private SeqInstInfoService seqService;
    private static ConcurrentMap<String, RdmModuleInfoDTO> moduleMappingCache = new ConcurrentHashMap<String, RdmModuleInfoDTO>();

    public int insertSingle(RdmModuleInfoDTO input) {
        String owner1 = StringUtils.isNotBlank((CharSequence)input.getSubsId()) ? input.getSubsId() : input.getProjectId();
        input.setModuleId(this.seqService.nextAndSave("MODULE-ID", "\u6a21\u5757\u7f16\u53f7", "00", "1", "99999", "1", "08", "0", "{{owner1}}-MDL-{{SEQ}}", "5", "Y", owner1));
        int output = super.insertSingle((Object)input);
        return output;
    }

    public int updateByPk(RdmModuleInfoDTO input) {
        int output = super.updateByPk((BaseInfo)input);
        return output;
    }

    public RdmModuleInfoDTO queryByPk(RdmModuleInfoDTO input) {
        RdmModuleInfoDTO output = (RdmModuleInfoDTO)super.queryByPk((BaseInfo)input);
        return output;
    }

    public int deleteByPk(RdmModuleInfoDTO input) {
        int output = super.deleteByPk((BaseInfo)input);
        return output;
    }

    public RdmModuleInfoDTO findModuleMapping(String projectId, String moduleName) {
        String key = String.format("%s-%s", projectId, moduleName);
        if (moduleMappingCache.get(key) != null) {
            return (RdmModuleInfoDTO)moduleMappingCache.get(key);
        }
        RdmModuleInfoDO param = new RdmModuleInfoDO();
        param.setProjectId(projectId);
        param.setModuleName(moduleName);
        List list = ((RdmModuleInfoRepository)this.getRepository()).queryListByPage((Object)param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            param = new RdmModuleInfoDO();
            param.setProjectId(projectId);
            FilterItem filter = new FilterItem();
            filter.setKey("moduleMapping");
            filter.setOp(FilterItem.FilterOpEnum.Like.getCode());
            filter.setValues(Arrays.asList(moduleName));
            param.setFilterCond(JSON.toJSONString(Arrays.asList(filter)));
            list = ((RdmModuleInfoRepository)this.getRepository()).queryListByPage((Object)param);
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RdmModuleInfoDTO re = (RdmModuleInfoDTO)this.beanCopy(list.get(0), RdmModuleInfoDTO.class);
            moduleMappingCache.put(key, re);
            return re;
        }
        return null;
    }

    public int deleteByCond(RdmModuleInfoDTO input) {
        RdmModuleInfoDO rdmModuleInfoDO = new RdmModuleInfoDO();
        this.beanCopy(input, rdmModuleInfoDO);
        return ((RdmModuleInfoRepository)this.getRepository()).deleteByCond(rdmModuleInfoDO);
    }

    public int saveExcel(String userId, String subsId, String projectId, List<RdmModuleInfoDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            String now = CurrentDateUtil.getTodayDateEx2();
            for (RdmModuleInfoDTO module : list) {
                int re;
                module.setSubsId(subsId);
                module.setProjectId(projectId);
                if (StringUtils.isBlank((CharSequence)module.getModuleId())) {
                    module.setCreateUser(userId);
                    module.setCreateTime(now);
                    module.setUpdateUser(userId);
                    module.setUpdateTime(now);
                    re = this.insertSingle(module);
                    if (re <= 0) continue;
                    ++outputVo;
                    continue;
                }
                module.setUpdateUser(userId);
                module.setUpdateTime(now);
                re = this.updateByPk(module);
                if (re == 0) {
                    module.setCreateUser(userId);
                    module.setCreateTime(now);
                    re = this.insertSingle(module);
                }
                if (re <= 0) continue;
                ++outputVo;
            }
        }
        return outputVo;
    }
}

