/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.index.application.operation;

import com.irdstudio.allintpaas.sdk.index.acl.repository.IndModelInfoRepository;
import com.irdstudio.allintpaas.sdk.index.acl.repository.IndModelTransformRepository;
import com.irdstudio.allintpaas.sdk.index.domain.entity.IndModelInfoDO;
import com.irdstudio.allintpaas.sdk.index.domain.entity.IndModelTransformDO;
import com.irdstudio.allintpaas.sdk.index.facade.operation.IndModelInfoService;
import com.irdstudio.allintpaas.sdk.index.facade.operation.dto.IndModelInfoDTO;
import com.irdstudio.allintpaas.sdk.index.types.ModelStat;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.util.validation.Validation;
import net.sf.jsqlparser.util.validation.feature.DatabaseType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="IndModelInfoServiceImpl")
public class IndModelInfoServiceImpl
extends BaseServiceImpl<IndModelInfoDTO, IndModelInfoDO, IndModelInfoRepository>
implements IndModelInfoService {
    @Autowired
    private SeqInstInfoService seqService;
    @Autowired
    private IndModelTransformRepository indModelTransformRepository;

    public int insertSingle(IndModelInfoDTO input) {
        input.setIndId(this.seqService.nextAndSave("IND-ID", "\u6307\u6807\u7f16\u53f7", "00", "1", "99999", "1", "08", "0", "IND{{SEQ}}", "5", "Y", null));
        int output = super.insertSingle((Object)input);
        return output;
    }

    public int updateByPk(IndModelInfoDTO input) {
        int output = super.updateByPk((BaseInfo)input);
        return output;
    }

    public IndModelInfoDTO queryByPk(IndModelInfoDTO input) {
        IndModelInfoDTO output = (IndModelInfoDTO)super.queryByPk((BaseInfo)input);
        return output;
    }

    public int deleteByPk(IndModelInfoDTO input) {
        int output = super.deleteByPk((BaseInfo)input);
        return output;
    }

    public List<IndModelInfoDTO> queryList(IndModelInfoDTO input) {
        List output = super.queryListByPage((BaseInfo)input);
        return output;
    }

    public boolean validate(IndModelInfoDTO param) {
        param = this.queryByPk(param);
        IndModelTransformDO transParam = new IndModelTransformDO();
        transParam.setIndId(param.getIndId());
        List transList = this.indModelTransformRepository.queryList((Object)transParam);
        if (CollectionUtils.isNotEmpty((Collection)transList)) {
            ArrayList<String> modelErrors = new ArrayList<String>();
            for (IndModelTransformDO item : transList) {
                String sql = item.getIndTransformSql();
                Validation validation = new Validation(Arrays.asList(DatabaseType.MYSQL), new String[]{sql});
                List errors = validation.validate();
                if (!CollectionUtils.isNotEmpty((Collection)errors)) continue;
                String error = String.format("%s\u6307\u6807\u52a0\u5de5SQL\u8bed\u6cd5\u9519\u8bef", item.getIndTransformId());
                modelErrors.add(error);
            }
            if (modelErrors.isEmpty()) {
                param.setModelStat(ModelStat.Validated.getCode());
                this.updateByPk(param);
            } else {
                param.setAll(StringUtils.join(modelErrors, (String)","));
            }
        }
        return StringUtils.equals((CharSequence)param.getModelStat(), (CharSequence)ModelStat.Validated.getCode());
    }
}

