/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.report.manual.application.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintpaas.sdk.report.facade.operation.RptModelInfoService;
import com.irdstudio.allintpaas.sdk.report.facade.operation.dto.RptModelInfoDTO;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AutoLoadReportDataServiceImpl
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AutoLoadReportDataServiceImpl.class);
    @Autowired
    protected RptModelInfoService rptModelInfoService;

    public void afterPropertiesSet() {
        try {
            Resource[] jsonResources;
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            for (Resource json : jsonResources = pathMatchingResourcePatternResolver.getResources("classpath*:META-INF/report/*.json")) {
                try {
                    String jsonString = IOUtils.toString((InputStream)json.getInputStream(), (String)"UTF-8");
                    RptModelInfoDTO data = (RptModelInfoDTO)JSON.parseObject((String)jsonString, RptModelInfoDTO.class);
                    if (data == null) continue;
                    try {
                        this.rptModelInfoService.insert((Object)data);
                    }
                    catch (Exception e) {
                        this.rptModelInfoService.updateByPk(data);
                    }
                }
                catch (Exception e) {
                    logger.error("\u62a5\u8868\u6570\u636e\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u62a5\u8868\u6570\u636e\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

