/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.query.autoconfigure;

import com.irdstudio.allintpaas.sdk.query.manual.application.operation.AutoLoadQueryDataServiceImpl;
import com.irdstudio.allintpaas.sdk.query.manual.application.operation.QueryServiceImpl;
import com.irdstudio.allintpaas.sdk.query.manual.facade.operation.QueryService;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(value={"com.irdstudio.allintpaas.sdk.query"})
public class AllintpaasSdkQryAutoConfiguration {
    @Bean
    public MapperScannerConfigurer allintpaasSdkQryMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintpaas.sdk.query.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils(ApplicationContext ctx) {
        SpringContextUtils utils = new SpringContextUtils();
        utils.setApplicationContext(ctx);
        return utils;
    }

    @Bean
    @ConditionalOnMissingBean(value={QueryService.class})
    public QueryService queryService(SqlSessionFactory sqlSessionFactory) {
        QueryServiceImpl service = new QueryServiceImpl();
        service.setSqlSessionFactory(sqlSessionFactory);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean(value={AutoLoadQueryDataServiceImpl.class})
    public AutoLoadQueryDataServiceImpl autoLoadQueryDataService() {
        AutoLoadQueryDataServiceImpl service = new AutoLoadQueryDataServiceImpl();
        return service;
    }

    @Configuration
    @EnableWebMvc
    public class AllintpaasSdkQryMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

