/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.report.autoconfigure;

import com.irdstudio.allintpaas.sdk.report.manual.application.operation.AutoLoadReportDataServiceImpl;
import com.irdstudio.allintpaas.sdk.report.manual.application.operation.ReportServiceImpl;
import com.irdstudio.allintpaas.sdk.report.manual.facade.operation.ReportService;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(value={"com.irdstudio.allintpaas.sdk.report"})
public class AllintpaasSdkReportAutoConfiguration {
    @Bean
    public MapperScannerConfigurer allintpaasSdkReportMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintpaas.sdk.report.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils(ApplicationContext ctx) {
        SpringContextUtils utils = new SpringContextUtils();
        utils.setApplicationContext(ctx);
        return utils;
    }

    @Bean
    @ConditionalOnMissingBean(value={ReportService.class})
    public ReportService rptService(SqlSessionFactory sqlSessionFactory) {
        ReportServiceImpl service = new ReportServiceImpl();
        service.setSqlSessionFactory(sqlSessionFactory);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean(value={AutoLoadReportDataServiceImpl.class})
    @ConditionalOnProperty(value={"allintpaas.sdk.report.load.data.disabled"}, matchIfMissing=true)
    public AutoLoadReportDataServiceImpl autoLoadReportDataService() {
        AutoLoadReportDataServiceImpl service = new AutoLoadReportDataServiceImpl();
        return service;
    }

    @Configuration
    @EnableWebMvc
    public class AllintpaasSdkReportMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

