(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 指标加工
    exports.IndModelTransformInfo = {
        props: {
            indId: String
        },
        inject: ['searchParams', 'windowHeight', 'tabActive'],
        data() {
            return  {
                signUserId: signUserId,
                formData: {
                    "indTransformId": "",
                    "indTransformSql": "",
                    "orderValue": "",
                    "indId": "",
                },
                loading: false,
                disabled: false,
                updateFlag: false,
                refreshEditor: true,
            }
        },
        watch: {
            indId(val) {
                this.queryData()
            },
            "tabActive.value": {
                handler(val) {
                    if (val === "2") {
                        this.refreshEditor = false;
                        this.$nextTick(()=>this.refreshEditor=true)
                    }
                }
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryData() {
                const self = this;
                self.loading = true;
                if (self.indId) {
                   $.restfulPostJson(contextPath + 'api/IndModelTransform/queryList', { indId: self.indId}, function(data){
                       self.loading = false;
                       if (data.rows && data.rows.length > 0) {
                           self.formData = data.rows[0];
                           self.updateFlag = true;
                       } else {
                           self.formData.indId = self.indId;
                           self.updateFlag = false;
                       }
                   }, function(e) {
                       self.loading = false;
                   }, true)
                }

            },
            topTabOpen(title, url) {
                let pathname = window.location.pathname;
                let locationDeep = pathname.split("/");
                let pageLocationDeep = url.split("../");
                locationDeep.splice(locationDeep.length - pageLocationDeep.length , pageLocationDeep.length);
                let newUrl = `${locationDeep.join("/")}/${pageLocationDeep.join("")}`;
                window.top.addTab(title, newUrl)
            },
            doSave(){
                const self = this;
                const formData = self.formData;
                self.loading = true;
                self.$refs.formRef.validate((valid, fields) => {
                    if (valid) {
                        const jsonData = Vue.toRaw(self.formData);
                        let method = self.updateFlag ? 'updateByPk' : 'insertSingle'
                        $.restfulPostJson(contextPath + 'api/IndModelTransform/' + method, {
                            ...jsonData,
                        }, function(data) {
                            ElementPlus.ElMessage({showClose: true, message: '保存成功', type: 'success',})
                            ElementDialog.callback(data);
                            self.loading = false;
                        }, function(e){
                            self.loading = false;
                            ElementPlus.ElMessage({showClose: true, message: '保存失败', type: 'error',})
                        }, true);
                    } else {
                        self.loading = false;
                    }
                })
            },
            doClose(){
                const self = this;
                const formData = self.formData;
                if ($.getUrlParam('winTitle')) {
                    window.top.closeTab($.getUrlParam('winTitle'))
                }
                ElementDialog.closeDialog();
            },
        },
        provide() {
            return {
                DIC: this.DIC,
            }
        },
        computed: {
            rules(){
                return {
                    "indTransformId": [
                        { required: true, message: '指标加工标识不能为空' },
                    ],
                    "indId": [
                        { required: true, message: '指标标识不能为空' },
                    ],
                    "indTransformSql": [
                        { required: true, message: '指标加工sql不能为空' },
                    ],
                }
            },
            DIC() {
                return {
                }
            },
            breadcrumb() {
                if (tabTitle) {
                    return tabTitle.split('-')
                }
                return ['指标加工表表单模型', '修改'];
            },
        },
        mounted() {
            let self = this;
            self.queryData();
        },
        unmounted() {

        },
        template: `
            <el-row>
                <el-col :span="24">
                    <el-card class="box-card pure-theme" shadow="never">
                        <template #header>
                            <page-header class="inner-title" breadcrumb="指标加工表表单模型信息" card-header>

                            </page-header>
                        </template>

                        <el-form class="card-form" v-loading="loading" ref="formRef" :show-message="true"
                             :model="formData"
                             :rules="rules"
                             label-width="120px">
                            <el-row :gutter="1">
                                <el-col :span="24">
                                    <el-form-item label="指标加工sql" prop="indTransformSql">
                                        <code-editor  v-model="formData.indTransformSql" :disabled="disabled" language="sql" height="200px" v-if="refreshEditor"></code-editor>
                                    </el-form-item>
                                </el-col>
                                
                            </el-row>
                            
                            <div class="element-dialog-button" >
                                <div>
                                    <el-button class="button" type="primary" round v-loading="loading" size="small"  icon="Select"  @click="doSave(row)">保存</el-button>
                                    <el-button class="button" type="default" round v-loading="loading" size="small"  icon="Close"  @click="doClose(row)">关闭</el-button>
                                </div>
                            </div>
                        </el-form>
                    </el-card>
                </el-col>
            </el-row>
        `
    }

}));