(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 报表订阅
    exports.RptSubscribeInfoStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                formData: {
                    "subscribeId": "",
                    "subscribeDesc": "",
                    "pushMineRpt": "Y",
                    "pushEmailFlag": "",
                    "pushFollowRpt": "",
                    "pushSmsFlag": "",
                    "rptModelId": "",
                    "rptModelCode": "",
                    "rptModelName": "",
                    "rptModelCategory": "",
                    "rptModelType": "",
                    "rptModelPage": "",
                    "rptModelParams": "",
                    "rptModelDesc": "",
                    "subscribeUserId": "",
                    "subscribeUserName": "",
                    "createUser": "",
                    "createTime": "",
                    "lastUpdateUser": "",
                    "lastUpdateTime": "",
                },

                loading: false,
                disabled: true,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryData() {
                const self = this;
                _.assignWith(self.formData, self.params.rptModelInfo, (objValue, srcValue)=>{ return _.isUndefined(srcValue) ? objValue : srcValue });
                self.formData.subscribeUserId = self.params.subscribeUserId;
                self.formData.subscribeUserName = self.params.subscribeUserName;
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            handleCatalogChange() {
                this.formData.taskType = ''
            },
            submitForm() {
                const self = this;
                self.loading = true;
                self.loading = true;
                self.$refs.formRef.validate((valid, fields) => {
                    if (valid) {
                        const jsonData = Vue.toRaw(self.formData);
                        $.restfulPostJson(contextPath + 'api/RptSubscribeInfo/insertSingle', {
                            ...jsonData,
                        }, function(data) {
                            self.$emit('next', vue.toRaw(self.formData));
                            self.loading = false;
                        }, function(e){
                            self.loading = false;
                            ElementPlus.ElMessage({showClose: true, message: '保存失败', type: 'error',})
                        }, true);
                    } else {
                        self.loading = false;
                    }
                })

            },
        },
        computed:{
            breadcrumb() {
                return `报表开发信息`
            },

            rules(){
                return {
                    "rptModelId": [
                        { required: true, message: '报表模型标识不能为空' },
                    ],
                    "rptModelCode": [
                        { required: true, message: '报表模型代码不能为空' },
                    ],
                    "rptModelName": [
                        { required: true, message: '报表模型名称不能为空' },
                    ],
                    "rptModelCategory": [
                        { required: true, message: '报表类别不能为空' },
                    ],
                    "rptModelType": [
                        { required: true, message: '报表类型不能为空' },
                    ],
                }
            },
            DIC() {
                return {
                    RPT_MODEL_CATEGORY: [
                        { 'enname': 'F', 'cnname': '固定报表' },
                        { 'enname': 'S', 'cnname': '订阅报表' },
                    ],
                    RPT_MODEL_TYPE: [
                        { 'enname': 'D', 'cnname': '日报' },
                        { 'enname': 'M', 'cnname': '月报' },
                        { 'enname': 'S', 'cnname': '季报' },
                        { 'enname': 'W', 'cnname': '周报' },
                        { 'enname': 'Y', 'cnname': '年报' },
                    ],
                }
            },

            checkList: {
                get() {
                    let arr = []
                    if (this.formData.pushMineRpt == 'Y') {
                        arr.push('pushMineRpt')
                    }
                    if (this.formData.pushFollowRpt == 'Y') {
                        arr.push('pushFollowRpt')
                    }
                    if (this.formData.pushEmailFlag == 'Y') {
                        arr.push('pushEmailFlag')
                    }
                    if (this.formData.pushSmsFlag == 'Y') {
                        arr.push('pushSmsFlag')
                    }
                    return arr
                },
                set(val) {
                    const self = this;
                    this.formData.pushMineRpt = 'N'
                    this.formData.pushFollowRpt = 'N'
                    this.formData.pushEmailFlag = 'N'
                    this.formData.pushSmsFlag = 'N'
                    if (val) {
                        val.forEach(function(el) {
                            self.formData[el] = 'Y'
                        })
                    }
                }
            }
        },
        mounted() {
            const self = this;
            self.queryData();
        },
        unmounted() {

        },
        template: `
        <el-col :span="24">
            <el-card class="box-card pure-theme" shadow="never">
                <template #header>
                    <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                    </page-header>
                </template>
                <el-row>
                    <el-col :span="24">
                        <el-form class="card-form" v-loading="loading" ref="formRef" :show-message="true"
                             :model="formData"
                             :rules="rules"
                             label-width="120px">
                            <el-row :gutter="1">
                                <el-col :span="24"  >
                                    <el-form-item label="报表订阅描述" prop="subscribeDesc">
                                        <el-input v-model="formData.subscribeDesc" :disabled="false" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="报表编号" prop="rptModelId">
                                        <el-input v-model="formData.rptModelId" :disabled="disabled" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="报表模型代码" prop="rptModelCode">
                                        <el-input v-model="formData.rptModelCode" :disabled="disabled" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="报表模型名称" prop="rptModelName">
                                        <el-input v-model="formData.rptModelName" :disabled="disabled" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="报表类别" prop="rptModelCategory">
                                        <combobox v-model="formData.rptModelCategory" placeholder="请选择报表类别" clearable :disabled="disabled" :op-type="DIC.RPT_MODEL_CATEGORY" > </combobox>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="报表类型" prop="rptModelType">
                                        <combobox v-model="formData.rptModelType" placeholder="请选择报表类型" clearable :disabled="disabled" :op-type="DIC.RPT_MODEL_TYPE" > </combobox>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="24">
                                    <el-form-item label="订阅方式" prop="checkList">
                                        <el-checkbox-group v-model="checkList" :disabled="false">
                                            <el-checkbox label="pushMineRpt" disabled>展示到我的报表</el-checkbox>
                                            <el-checkbox label="pushFollowRpt" >展示到我关注的报表</el-checkbox>
                                            <el-checkbox label="pushEmailFlag" >邮件发送内容</el-checkbox>
                                            <el-checkbox label="pushSmsFlag" >短信通知</el-checkbox>
                                        </el-checkbox-group>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="24"  >
                                    <el-form-item label="报表对应的页面路径" prop="rptModelPage">
                                        <el-input v-model="formData.rptModelPage" :disabled="disabled" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="24"  >
                                    <el-form-item label="报表订阅参数" prop="rptModelParams">
                                        <rpt-model-params-editor v-model="formData.rptModelParams" :disabled="false" ></rpt-model-params-editor>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="24"  >
                                    <el-form-item label="报表模型说明" prop="rptModelDesc">
                                        <el-input v-model="formData.rptModelDesc" :disabled="disabled"  type="textarea" :autosize="{ minRows: 4, maxRows: 8 }"></el-input>
                                    </el-form-item>
                                </el-col>
                            </el-row>
                        </el-form>
                    </el-col>
                </el-row>
            </el-card>
            <div class="esaas-info-buttons" :style="{ bottom: 'inherit', top: windowHeight.value - 40 } ">
                <div>
                    <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
                    <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
                    <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
                </div>
            </div>
        </el-col>
        `
    }

}));