(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    // 我的报表
    exports.MyRptSubscribe = {
        props: {
            tabTitle: String,
            rootPath: String,
        },
        inject: ['searchParams', 'signUserId'],
        data() {
            return  {
                dgUrl: this.rootPath + 'api/RptSubscribeInfo/queryList',
                queryParams: {
                    "subscribeId": "",
                    "subscribeDesc": "",
                    "rptModelId": "",
                    "rptModelCode": "",
                    "rptModelName": "",
                    "subscribeUserId": this.signUserId,
                    "subscribeUserName": "",
                    "rptModelCategory": "",
                    "rptModelType": "",
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;

                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.toRaw(self.pageInfo),
                    ...Vue.toRaw(self.queryParams)
                }
                params[self.allName] = self.all
                self.queryParamsHandler(params)
                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            topTabOpen(title, url) {
                let pathname = window.location.pathname;
                let locationDeep = pathname.split("/");
                let pageLocationDeep = url.split("../");
                locationDeep.splice(locationDeep.length - pageLocationDeep.length , pageLocationDeep.length);
                let newUrl = `${locationDeep.join("/")}/${pageLocationDeep.join("")}`;
                window.top.addTab(title, newUrl)
            },
            doSubscribe(row){
                const self = this
                ElementDialog.createDialog(`订阅报表`,`${this.rootPath}page/allintpaas/sdk/report/manual/ReportSubscribeGuide.html?`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            doReportView(row){
                const self = this
                window.top.addTab(`${row.rptModelName}浏览`,`${this.rootPath}page/allintpaas/sdk/report/manual/ReportView.html?winTitle=${row.rptModelName}浏览&rptModelId=${row.rptModelId}&subscribeId=${row.subscribeId}&subscribeFlag=true`)
            },
            doUpdate(row){
                const self = this
                ElementDialog.createDialog(`${row.rptModelId}-${row.subscribeDesc}订阅修改`,`${this.rootPath}page/allintpaas/sdk/report/RptSubscribeInfoUpdate.html?subscribeId=${row.subscribeId}&subscribeUserId=${row.subscribeUserId}&rptModelId=${row.rptModelId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            doDelete(row){
                const self = this
                $.restfulPostJson(this.rootPath + 'api/RptSubscribeInfo/deleteByPk', {
                    'subscribeId' : row.subscribeId,
                    'rptModelId' : row.rptModelId,
                    'subscribeUserId' : row.subscribeUserId,
                }, function(data){
                    if (data.success) {
                        ElementPlus.ElMessage({
                            showClose: true,
                            message: data.message,
                            type: 'success',
                        })
                        self.queryList();
                    } else {
                        ElementPlus.ElMessage({
                            showClose: true,
                            message: data.message,
                            type: 'error',
                        })
                    }
                }, undefined, true);
            },
            doView(row) {
                ElementDialog.createDialog('报表订阅表表单模型-报表编号','RptSubscribeInfoView.html?' + 'subscribeId=' + row.subscribeId)
                    .then(()=>{
                        self.queryList()
                    });
            },
            rptModelIdColHandler(row) {
                ElementDialog.createDialog('报表订阅表表单模型-报表编号','RptModelInfoView.html?' + 'rptModelId=' + row.rptModelId)
                    .then(()=>{
                        self.queryList()
                    });
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item) {
                const queryParams = this.queryParams || {}
                delete queryParams.ascOrder;
                delete queryParams.descOrder;
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList) {
                    this.queryList()
                }
            }
        },
        provide() {
            return {
                DIC: this.DIC,
            }
        },
        computed: {
            DIC() {
                return {
                    GROUP_RPT_MODEL_CATEGORY: [
                        {'enname': '', 'cnname': '全部'},
                        { 'enname': 'A', 'cnname': '分析报表' },
                        { 'enname': 'C', 'cnname': '统计报表' },
                    ],
                    GROUP_RPT_MODEL_TYPE: [
                        {'enname': '', 'cnname': '全部'},
                        { 'enname': 'D', 'cnname': '日报' },
                        { 'enname': 'M', 'cnname': '月报' },
                        { 'enname': 'S', 'cnname': '季报' },
                        { 'enname': 'W', 'cnname': '周报' },
                        { 'enname': 'Y', 'cnname': '年报' },
                    ],

                    RPT_MODEL_CATEGORY: [
                        { 'enname': 'A', 'cnname': '分析报表' },
                        { 'enname': 'C', 'cnname': '统计报表' },
                    ],
                    RPT_MODEL_TYPE: [
                        { 'enname': 'D', 'cnname': '日报' },
                        { 'enname': 'M', 'cnname': '月报' },
                        { 'enname': 'S', 'cnname': '季报' },
                        { 'enname': 'W', 'cnname': '周报' },
                        { 'enname': 'Y', 'cnname': '年报' },
                    ],
                }
            },
            breadcrumb() {
                if (tabTitle) {
                    return tabTitle.split('-');
                }
                return ['报表订阅表表单模型列表']
            },
            filterConfig() {
                return [
                    { key: 'subscribeId', name: '订阅编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'subscribeDesc', name: '报表订阅描述', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'rptModelId', name: '报表编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'rptModelCode', name: '报表模型代码', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'rptModelName', name: '报表模型名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'subscribeUserId', name: '订阅用户', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'subscribeUserName', name: '订阅用户名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                ]
            },
            sortConfig() {
                return [
                ]
            },
            groupConfig() {
                return [
                    {
                        id: 0,
                        label: '按报表类别',
                        key: 'rptModelCategory',
                        dgUrl: this.dgUrl,
                        queryParams: this.queryParams,
                        queryParamsHandler: this.queryParamsHandler,
                        change: this.allSearch,
                        opType: this.DIC.GROUP_RPT_MODEL_CATEGORY,
                        restMethod: 'restfulPostJson'
                    },
                    {
                        id: 1,
                        label: '按报表类型',
                        key: 'rptModelType',
                        dgUrl: this.dgUrl,
                        queryParams: this.queryParams,
                        queryParamsHandler: this.queryParamsHandler,
                        change: this.allSearch,
                        opType: this.DIC.GROUP_RPT_MODEL_TYPE,
                        restMethod: 'restfulPostJson'
                    },
                ]
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            let self = this;
            self.groupItem = self.groupConfig[1];
            self.queryList();
        },
        template: `
            <el-row>
                <el-col :span="24">
                    <el-card class="box-card  pure-theme" shadow="never">
                        <template #header>
                            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                                <template #right>
                                    <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                                    
                                    <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                                </template>
                            </page-header>
                        </template>
                        <el-row>
                            <el-col :span="24">
                                <page-search ref="searchRef"
                                             enable-search
                                             :all-items="[]"
                                             @all-search="allSearch"
                                >
                                    <template #more>
                                        <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                                            <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                                            <el-row v-if="groupItem">
                                                <el-col :span="24">
                                                    <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                                </el-col>
                                            </el-row>
                                        </el-form>
                                    </template>
                                    <template #tool>
                                        <el-button type="default" text  icon="Plus"  @click="doSubscribe" >订阅</el-button>
                                    </template>
                                </page-search>
                                <template v-if="listView">
                                    <el-table :data="tableData"
                                            v-loading="loading"
                                            stripe
                                            highlight-current-row
                                            @current-change="handlerTableCurrentChange"
                                            tooltip-effect="light"
                                            :tooltip-options="{placement : 'bottom'}"
                                            style="width: 100%" >
                                        <el-table-column type="index" width="45" ></el-table-column>
                                        <el-table-column prop="subscribeId" label="订阅编号"  show-overflow-tooltip   >
                                            <template #default="{row, $index}">
                                                <el-link type="primary" :underline="false" @click="doView(row)">{{row.subscribeId}}</el-link>
                                            </template>
                                        </el-table-column>
                                        <el-table-column prop="subscribeDesc" label="报表订阅描述"  show-overflow-tooltip   >
                                        </el-table-column>
                                        <el-table-column prop="rptModelId" label="报表编号"  show-overflow-tooltip   >
                                            <template #default="{row, $index}">
                                                <el-link type="primary" :underline="false" @click="rptModelIdColHandler(row)">{{row.rptModelId}}</el-link>
                                            </template>
                                        </el-table-column>
                                        <el-table-column prop="rptModelName" label="报表模型名称"  show-overflow-tooltip   >
                                        </el-table-column>
                                        <el-table-column prop="rptModelCategory" label="报表类别"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('RPT_MODEL_CATEGORY', value)" >
                                        </el-table-column>
                                        <el-table-column prop="rptModelType" label="报表类型"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('RPT_MODEL_TYPE', value)" >
                                        </el-table-column>
                                        <el-table-column prop="rptModelDesc" label="报表模型说明"  show-overflow-tooltip   >
                                        </el-table-column>
                                        <el-table-column prop="subscribeUserName" label="订阅用户名称"  show-overflow-tooltip   >
                                        </el-table-column>
                                        <el-table-column label="操作" width="300" header-align="center">
                                            <template #default="{row, $index}">
                                            <el-button class="button" text type="default"  @click="doReportView(row)"><el-icon><i class="iconfont icon-yulan"></i></el-icon>浏览</el-button>
                                            <el-button class="button" text type="default"  icon="Edit"  @click="doUpdate(row)">修改</el-button>
                                                <el-dropdown @command="handlerCommand" type="primary">
                                                    <el-button type="default" text> <el-icon ><i class="iconfont icon-i-more" ></i></el-icon>更多</el-button>
                                                    <template #dropdown>
                                                        <el-dropdown-menu>
                                                                <el-dropdown-item :command="{ command: 'doDelete', row: row}"><el-icon><Delete></Delete></el-icon>删除</el-dropdown-item>
                                                        </el-dropdown-menu>
                                                    </template>
                                                </el-dropdown>
                                            </template>
                                        </el-table-column>
                                    </el-table>
                                    <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                                </template>
                            </el-col>
                        </el-row>
                    </el-card>

                </el-col>
            </el-row>
        `
    }


}));