(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 报表模型选择
    exports.RptInstInfoListStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                dgUrl: window.contextPath + 'api/RptInstInfo/queryList',
                signUserId: signUserId,
                queryParams: {
                    "rptSubscribeFlag": 'Y',
                    "rptInstId": "",
                    "rptInstName": "",
                    "rptInstType": "",
                    "rptInstRealtime": "",
                    "tableModelName": "",
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            doView(row){
                const self = this
                ElementDialog.createDialog(`查看`,`${contextPath}page/allintpaas/sdk/report/RptInstInfoView.html?rptInstId=${row.rptInstId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                queryParams.ascOrder = "";
                queryParams.descOrder = "";
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList  && !initFlag) {
                    this.queryList()
                }
            },
            handlerDblclick(row) {
                this.handlerTableCurrentChange(row);
                this.submitForm()
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            submitForm() {
                if (this.currentRow) {
                    this.$emit('next', Vue.unref(this.currentRow))
                } else {
                    ElementPlus.ElMessage({
                        showClose: true,
                        message: '请选择一条记录！',
                        type: 'warning',
                    })
                }
            }
        },
        computed:{
            breadcrumb() {
                return `报表模型列表`
            },

            DIC() {
                return {
                    GROUP_RPT_MODEL_TYPE: [
                        {'enname': '', 'cnname': '全部'},
                        { 'enname': 'C', 'cnname': '周期报表' },
                        { 'enname': 'R', 'cnname': '实时报表' },
                    ],

                    RPT_MODEL_CATEGORY: [
                        { 'enname': 'A', 'cnname': '分析报表' },
                        { 'enname': 'C', 'cnname': '统计报表' },
                    ],
                    RPT_MODEL_TYPE: [
                        { 'enname': 'C', 'cnname': '周期报表' },
                        { 'enname': 'I', 'cnname': '指标分析报表' },
                        { 'enname': 'R', 'cnname': '实时报表' },
                    ],
                    RPT_MODEL_CYCLE: [
                        { 'enname': 'D', 'cnname': '日报' },
                        { 'enname': 'M', 'cnname': '月报' },
                        { 'enname': 'R', 'cnname': '实时' },
                        { 'enname': 'S', 'cnname': '季报' },
                        { 'enname': 'W', 'cnname': '周报' },
                        { 'enname': 'Y', 'cnname': '年报' },
                    ],
                    STD_PUB_YN: [
                        { 'enname': 'N', 'cnname': '否' },
                        { 'enname': 'Y', 'cnname': '是' },
                    ],
                    RPT_MODEL_VISIT: [
                        { 'enname': 'C', 'cnname': '公共' },
                        { 'enname': 'P', 'cnname': '私有' },
                    ],
                }
            },
            filterConfig() {
                return [
                    { key: 'rptInstId', name: '报表编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstCode', name: '报表代码', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstName', name: '报表名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstCategory', name: '报表类别', type: 'checkbox', opType: this.DIC.RPT_MODEL_CATEGORY, opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstType', name: '报表类型', type: 'checkbox', opType: this.DIC.RPT_MODEL_TYPE, opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstCycle', name: '报表周期', type: 'checkbox', opType: this.DIC.RPT_MODEL_CYCLE, opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0),},
                ]
            },
            sortConfig() {
                return [
                    {label: '按报表编号顺序', key: 'rptInstId', type: 'asc'},
                    {label: '按报表编号倒序', key: 'rptInstId', type: 'desc'},
                    {label: '按报表排序字段顺序', key: 'orderValue', type: 'asc'},
                    {label: '按报表排序字段倒序', key: 'orderValue', type: 'desc'},
                ]
            },
            groupConfig() {
                return [
                    {
                        id: 1,
                        label: '按报表类型',
                        key: 'rptInstType',
                        dgUrl: this.dgUrl,
                        queryParams: this.queryParams,
                        queryParamsHandler: this.queryParamsHandler,
                        change: this.allSearch,
                        opType: this.DIC.GROUP_RPT_MODEL_TYPE,
                    },
                ]
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            const self = this;
            self.groupItem = self.groupConfig[0];
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                    <group-dropdown v-model="groupItem" :group-config="groupConfig"></group-dropdown>
                    <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                             enable-search
                             :all-items="[]"
                             @all-search="allSearch"
                >
                    <template #more>
                        <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                            <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                            <el-row v-if="groupItem">
                                <el-col :span="24">
                                    <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                </el-col>
                            </el-row>
                        </el-form>
                    </template>
                </page-search>
                <template v-if="listView">
                    <el-table :data="tableData"
                              v-loading="loading"
                              stripe
                              highlight-current-row
                              @current-change="handlerTableCurrentChange" @row-dblclick="handlerDblclick"
                              tooltip-effect="light"
                              :tooltip-options="{placement : 'bottom'}"
                              style="width: 100%" >
                        <el-table-column type="index" width="45" ></el-table-column>
                        <el-table-column prop="rptInstId" label="报表模型标识"  show-overflow-tooltip   >
                            <template #default="{row, $index}">
                                <el-link type="primary" :underline="false" @click="doView(row)">{{row.rptInstId}}</el-link>
                            </template>
                        </el-table-column>
                        <el-table-column prop="rptInstName" label="报表名称"  show-overflow-tooltip   >
                        </el-table-column>
                        <el-table-column prop="rptInstType" label="报表类型"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('RPT_MODEL_TYPE', value)" >
                        </el-table-column>
                        <el-table-column prop="rptInstCycle" label="报表周期"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('RPT_MODEL_CYCLE', value)" >
                        </el-table-column>
                    </el-table>
                    <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                </template>
            </el-col>
        </el-row>
    </el-card>
    <div class="esaas-info-buttons">
        <div>
            <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
            <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
            <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        </div>
    </div>
</el-col>
        `
    }

}));