(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 参数编辑
    exports.IndModelParamsEditor = {
        props: {
            modelValue: String,
            disabled: Boolean,
        },
        emits: ['update:modelValue', 'change'],
        data(){
            return {
                formItem: undefined, // 表单父级组件

                tableData: [],
                loading: false,
                currentRow: undefined,

            }
        },
        watch: {
            value(val) {
                this.queryList()
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            // 从moduleValue中解析出来变量名
            queryList() {
                const self = this;
                self.loading = true;
                if (self.modelValue && self.modelValue.length > 0 ) {
                    try {
                        self.tableData = JSON.parse(self.modelValue)
                    } catch(e) {
                        console.error(e)
                    }
                }
                self.loading = false;
            },
            handlerChange() {
                const self = this;
                const val = JSON.stringify(self.tableData);
                self.value = val;
                this.$emit('change', val)
                const { formItem } = this;
                formItem && formItem.validate();
            },
            doUpdate(row) {
                if (this.disabled) {
                    return ;
                }
                const { formId, fnId } = this;
                const self = this;

                ElementDialog.createDialog('编辑参数', `${contextPath}page/allintpaas/sdk/index/manual/IndModelParamUpdate.html?params=${Base64.encode(JSON.stringify(row))}` )
                    .then(result=>{
                        _.assign(row, result);
                        self.handlerChange()
                    });
            },
            doDelete(row, index) {
                const self = this
                if (row) {
                    const param = Vue.toRaw(row);
                    self.currentRow = param;
                    ElementPlus.ElMessageBox.confirm(
                        '你确定要删除这条记录?',
                        '提示',
                        {
                            confirmButtonText: '确定',
                            cancelButtonText: '取消',
                            type: 'warning',
                        }
                    ).then(() => {
                        self.tableData.splice(index, 1);
                        self.currentRow = undefined;
                        self.handlerChange();
                    })
                }
            },
            doUp(row, index) {
                if(row && index > 0) {
                    let up = index - 1;
                    let old = this.tableData[up];
                    this.tableData[index] = old;
                    this.tableData[up] = row
                }
            },
            doDown(row, index) {
                if(row && index < this.tableData.length - 1) {
                    let up = index + 1;
                    let old = this.tableData[up];
                    this.tableData[index] = old;
                    this.tableData[up] = row
                }
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
        },
        computed:{
            value: {
                get() {
                    return (this.modelValue || '') + ''
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
        },
        mounted() {
            this.formItem = vue.inject(ElementPlus.formItemContextKey)
            this.queryList();
        },
        unmounted() {

        },
        template: `
<div style="width: 100%; display: flex; flex-direction: column;">
    <el-table :data="tableData" 
              v-loading="loading"
              stripe
              highlight-current-row
              @current-change="handlerTableCurrentChange" @row-dblclick="doUpdate"
              tooltip-effect="light"
              :tooltip-options="{placement : 'bottom'}"
              style="width: 100%" >
        <el-table-column type="index" width="45" ></el-table-column>
        <el-table-column prop="varCode" label="参数代码" min-width="200" show-overflow-tooltip></el-table-column>
        <el-table-column prop="varName" label="参数名称" min-width="200" show-overflow-tooltip></el-table-column>
        <el-table-column prop="varValue" label="参数值" min-width="230" show-overflow-tooltip></el-table-column>
        <el-table-column label="操作" width="120" header-align="center" v-if="!disabled">
            <template #default="{row, $index}">
                <el-button class="button" text type="default" @click="doUpdate(row)"><el-icon><Edit ></Edit></el-icon>修改</el-button>
            </template>
        </el-table-column>
    </el-table>
</div>
        `
    }

}));