/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.report.manual.web.operation;

import com.irdstudio.allintpaas.sdk.report.facade.operation.RptInstInfoService;
import com.irdstudio.allintpaas.sdk.report.facade.operation.dto.RptInstInfoDTO;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RptInstInfoManualController
extends AbstractController {
    @Autowired
    private RptInstInfoService rptInstInfoService;
    @Value(value="${allintpaas.sdk.report.export.path:/var/tmp/apps/}")
    private String pdfFileStorageRoot;

    @RequestMapping(value={"/api/RptInstInfo/exportToPdf"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> exportToPdf(@RequestParam(value="rptInstId") String rptInstId, @RequestParam(value="indDate") String indDate, @RequestParam(value="rptModelId") String rptModelId, HttpServletResponse response) {
        RptInstInfoDTO instInfo = new RptInstInfoDTO();
        instInfo.setRptInstId(rptInstId);
        instInfo = this.rptInstInfoService.queryByPk(instInfo);
        String fileLocation = rptInstId + ".pdf";
        File file = new File(this.pdfFileStorageRoot, fileLocation);
        if (!file.exists()) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e22\u5931", instInfo.getRptInstName(), rptInstId));
        }
        String fileName = String.format("%s(%s)-%s.pdf", instInfo.getRptInstName(), rptInstId, indDate);
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            String contentType = "application/pdf";
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + new String(fileName.getBytes(), "iso-8859-1") + "\""})).body((Object)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38%s", instInfo.getRptInstName(), rptInstId, e.getMessage()));
        }
    }
}

