/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.report.manual.web.operation;

import com.irdstudio.allintpaas.sdk.report.facade.operation.RptInstInfoService;
import com.irdstudio.allintpaas.sdk.report.facade.operation.dto.RptInstInfoDTO;
import com.irdstudio.framework.beans.core.util.CookiesUtil;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.print.PageSize;
import org.openqa.selenium.print.PrintOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RptInstInfoManualController
extends AbstractController {
    @Autowired
    private RptInstInfoService rptInstInfoService;
    @Value(value="${allintpaas.sdk.report.export.path:/var/tmp/apps/}")
    private String pdfFileStorageRoot;
    @Value(value="${chromium.webdriver}")
    private String webDriver;
    @Value(value="${cas.client-host-url}")
    private String serverHost;
    @Value(value="${server.servlet.contextPath}")
    private String serverContextPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/RptInstInfo/exportToPdf"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> exportToPdf(@RequestParam(value="rptInstId") String rptInstId, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate, @RequestParam(value="rptModelId") String rptModelId, HttpServletRequest request, HttpServletResponse response) {
        RptInstInfoDTO instInfo = new RptInstInfoDTO();
        instInfo.setRptInstId(rptInstId);
        instInfo = this.rptInstInfoService.queryByPk(instInfo);
        String JSESSIONID = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"JSESSIONID");
        String TGC = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"TGC");
        String signUserId = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"signUserId");
        String ssoclient = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssoclient");
        String ssomd5 = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssomd5");
        String ssottp = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssottp");
        ChromeDriver driver = null;
        try {
            System.setProperty("webdriver.chrome.driver", this.webDriver);
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"--headless"});
            options.addArguments(new String[]{"--no-sandbox"});
            options.addArguments(new String[]{"headless", "no-sandbox"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--window-size=1920,1024"});
            options.addArguments(new String[]{"--remote-allow-origins=*"});
            driver = new ChromeDriver(options);
            driver.manage().addCookie(new Cookie("JSESSIONID", JSESSIONID, this.serverContextPath));
            driver.manage().addCookie(new Cookie("TGC", JSESSIONID, "/"));
            driver.manage().addCookie(new Cookie("signUserId", JSESSIONID, "/"));
            driver.manage().addCookie(new Cookie("ssoclient", JSESSIONID, "/"));
            driver.manage().addCookie(new Cookie("ssomd5", JSESSIONID, "/"));
            driver.manage().addCookie(new Cookie("ssottp", JSESSIONID, "/"));
            String url = instInfo.getRptInstPage();
            url = StringUtils.startsWith((CharSequence)url, (CharSequence)"/") ? String.format("%s%s%s", this.serverHost, this.serverContextPath, url) : String.format("%s%s/%s", this.serverHost, this.serverContextPath, url);
            url = url + String.format("&startDate=%s&endDate=%s&mode=print", startDate, endDate);
            driver.get(url);
            driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(1L));
            PrintOptions printOptions = new PrintOptions();
            printOptions.setPageSize(new PageSize(100.0, 141.4));
            Pdf webPdf = driver.print(printOptions);
            String string = webPdf.getContent();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u67b6\u6784\u56fe\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
        String fileLocation = rptInstId + ".pdf";
        File file = new File(this.pdfFileStorageRoot, fileLocation);
        if (!file.exists()) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e22\u5931", instInfo.getRptInstName(), rptInstId));
        }
        String fileName = String.format("%s(%s)-%s.pdf", instInfo.getRptInstName(), rptInstId, startDate);
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            String contentType = "application/pdf";
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + new String(fileName.getBytes(), "iso-8859-1") + "\""})).body((Object)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38%s", instInfo.getRptInstName(), rptInstId, e.getMessage()));
        }
    }
}

