/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.bi.web.operation;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.allintpaas.sdk.types.ModuleLevelEnum;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class RdmModuleInfoController
extends BaseController<RdmModuleInfoDTO, RdmModuleInfoService> {
    @RequestMapping(value={"/api/RdmModuleInfo/insertSingle"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSingle(@RequestBody RdmModuleInfoDTO input) {
        this.setUserInfoToVO(input);
        input.setCreateUser(input.getLoginUserId());
        input.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        input.setUpdateUser(input.getLoginUserId());
        input.setUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int output = ((RdmModuleInfoService)this.getService()).insertSingle(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/RdmModuleInfo/updateByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody RdmModuleInfoDTO input) {
        this.setUserInfoToVO(input);
        input.setUpdateUser(input.getLoginUserId());
        input.setUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int output = ((RdmModuleInfoService)this.getService()).updateByPk(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/RdmModuleInfo/queryByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<RdmModuleInfoDTO> queryByPk(@RequestBody RdmModuleInfoDTO input) {
        this.setUserInfoToVO(input);
        RdmModuleInfoDTO output = ((RdmModuleInfoService)this.getService()).queryByPk(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/RdmModuleInfo/deleteByPk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody RdmModuleInfoDTO input) {
        this.setUserInfoToVO(input);
        int output = ((RdmModuleInfoService)this.getService()).deleteByPk(input);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/RdmModuleInfo/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<RdmModuleInfoDTO>> queryList(@RequestBody RdmModuleInfoDTO input) {
        this.setUserInfoToVO(input);
        if (StringUtils.contains((CharSequence)input.getModuleLevel(), (CharSequence)",")) {
            String[] levels = StringUtils.split((String)input.getModuleLevel(), (String)",");
            input.setModuleLevelList(Arrays.asList(levels));
            input.setModuleLevel(null);
        }
        List output = ((RdmModuleInfoService)this.getService()).queryListByPage((Object)input);
        return this.getResponseData(output);
    }

    @PostMapping(value={"/api/rdm/module/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="subsId") String subsId, @RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="excelUploadType") String excelUploadType, @RequestPart(value="file") MultipartFile file) {
        try {
            AppResourceItemListener listener = new AppResourceItemListener();
            EasyExcel.read((InputStream)file.getInputStream(), CellItem.class, (ReadListener)listener).sheet().doRead();
            List<RdmModuleInfoDTO> list = listener.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                if (StringUtils.equals((CharSequence)"insert", (CharSequence)excelUploadType)) {
                    RdmModuleInfoDTO deleteParam = new RdmModuleInfoDTO();
                    deleteParam.setSubsId(subsId);
                    deleteParam.setProjectId(projectId);
                    ((RdmModuleInfoService)this.getService()).deleteByCond(deleteParam);
                }
                ((RdmModuleInfoService)this.getService()).saveExcel(this.getUserInfo().getUserId(), subsId, projectId, list);
            }
            return this.getResponseData("\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            logger.error(" \u6a21\u5757\u5bfc\u5165\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage("\u5bfc\u5165\u5931\u8d25");
            return resp;
        }
    }

    public static class CellItem {
        @ExcelProperty(value={"\u6a21\u5757\u7f16\u53f7"})
        private String moduleId;
        @ExcelProperty(value={"\u6a21\u5757\u540d\u79f0"})
        private String moduleName;
        @ExcelProperty(value={"\u6a21\u5757\u6620\u5c04"})
        private String moduleMapping;
        @ExcelProperty(value={"\u6a21\u5757\u5c42\u6b21"})
        private String moduleLevel;

        public String getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(String moduleId) {
            this.moduleId = moduleId;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getModuleMapping() {
            return this.moduleMapping;
        }

        public void setModuleMapping(String moduleMapping) {
            this.moduleMapping = moduleMapping;
        }

        public String getModuleLevel() {
            return this.moduleLevel;
        }

        public void setModuleLevel(String moduleLevel) {
            this.moduleLevel = moduleLevel;
        }
    }

    public static class AppResourceItemListener
    extends AnalysisEventListener<CellItem> {
        private List<RdmModuleInfoDTO> list = new ArrayList<RdmModuleInfoDTO>();

        public List<RdmModuleInfoDTO> getList() {
            return this.list;
        }

        public void invoke(CellItem data, AnalysisContext context) {
            RdmModuleInfoDTO vo = new RdmModuleInfoDTO();
            BeanUtility.beanCopy((Object)data, (Object)vo);
            vo.setModuleLevel(ModuleLevelEnum.codeByName((String)vo.getModuleLevel()));
            this.list.add(vo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

