/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.filesrv.application.log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.irdstudio.allintpaas.sdk.filesrv.application.log.ServiceLog;
import com.irdstudio.allintpaas.sdk.filesrv.facade.operation.FspInstFileService;
import com.irdstudio.allintpaas.sdk.filesrv.facade.operation.FspServiceLogService;
import com.irdstudio.allintpaas.sdk.filesrv.facade.operation.dto.FspInstFileDTO;
import com.irdstudio.allintpaas.sdk.filesrv.facade.operation.dto.FspServiceLogDTO;
import com.irdstudio.framework.beans.core.spring.ExpressionUtil;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.UserInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class ServiceLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLogAspect.class);
    @Autowired
    protected FspServiceLogService serviceLogService;
    @Autowired
    protected FspInstFileService fspInstFileService;
    @Autowired
    private HttpSession session;

    @Pointcut(value="@annotation(com.irdstudio.allintpaas.sdk.filesrv.application.log.ServiceLog)")
    public void pointcut() {
    }

    @AfterReturning(value="pointcut() && @annotation(serviceLog)", returning="result")
    public void serviceLoging(JoinPoint pjp, ServiceLog serviceLog, Object result) throws Throwable {
        logger.debug("\u52a8\u6001\u5207\u9762 \u7c7b\u540d\uff1a{}-{}", (Object)pjp.getSignature().getDeclaringType().getSimpleName(), (Object)pjp.getSignature().getName());
        try {
            Object[] args = pjp.getArgs();
            boolean doNotSave = false;
            FspServiceLogDTO logVo = new FspServiceLogDTO();
            logVo.setLogService(serviceLog.serviceType().getCode());
            logVo.setFileId(this.parseExp(serviceLog.bizKey(), args, result, pjp, serviceLog));
            String date = CurrentDateUtil.getTodayDateEx2();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String ip = ServiceLogAspect.getIpAddress(request);
            logVo.setLogIp(ip);
            UserInfo userInfo = this.getUserInfo();
            if (userInfo != null) {
                logVo.setCreateUser(userInfo.getUserId());
            }
            logVo.setCreateTime(date);
            if (StringUtils.isNotBlank((CharSequence)logVo.getFileId())) {
                FspInstFileDTO fileInst = new FspInstFileDTO();
                fileInst.setFileId(logVo.getFileId());
                fileInst = this.fspInstFileService.queryByPk(fileInst);
                if (fileInst != null) {
                    logVo.setSubsId(fileInst.getSubsId());
                    logVo.setAppId(fileInst.getAppId());
                    logVo.setProjectId(fileInst.getProjectId());
                }
            }
            if (args != null) {
                ArrayList<Object> params = new ArrayList<Object>();
                for (Object arg : args) {
                    if (arg instanceof MultipartFile) continue;
                    params.add(arg);
                }
                logVo.setLogParams(JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField, SerializerFeature.IgnoreErrorGetter}));
            }
            if (!doNotSave) {
                logVo.setLogId(UUIDUtil.getUUID());
                this.serviceLogService.insert((Object)logVo);
            }
        }
        catch (Exception e) {
            logger.error("\u52a8\u6001\u5207\u9762 \u7c7b\u540d\uff1a{}-{} \u8bb0\u5f55\u5931\u8d25 {}", new Object[]{pjp.getSignature().getDeclaringType().getSimpleName(), pjp.getSignature().getName(), e.getMessage(), e});
        }
    }

    private String parseExp(String exp, Object[] args, Object result, JoinPoint pjp, ServiceLog serviceLog) {
        if (StringUtils.isBlank((CharSequence)exp)) {
            return "";
        }
        try {
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("args", args);
            root.put("result", result);
            root.put("joinPoint", pjp);
            root.put("serviceLog", serviceLog);
            HashMap<String, Method> registerFunc = new HashMap<String, Method>();
            registerFunc.put("transformCode", ServiceLogAspect.class.getMethod("transformCode", String.class, String.class, String.class));
            return ExpressionUtil.parse((String)exp, root, registerFunc);
        }
        catch (Exception e) {
            logger.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25 {} {}", (Object)exp, (Object)e.getMessage());
            return exp;
        }
    }

    private String getIndexKeyFromArgs(Object[] args) {
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                BaseInfo baseInfo;
                List indexList;
                if (!(arg instanceof BaseInfo) || !CollectionUtils.isNotEmpty((Collection)(indexList = (baseInfo = (BaseInfo)arg).findIndexKeyInfo()))) continue;
                indexList = indexList.stream().map(key -> String.format("#%s#", key)).collect(Collectors.toList());
                return StringUtils.join(indexList, (String)",");
            }
        }
        return null;
    }

    public final UserInfo getUserInfo() {
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)this.session.getAttribute("userInfo");
        }
        catch (ClassCastException e) {
            Object obj = this.session.getAttribute("userInfo");
            String json = JSON.toJSONString((Object)obj);
            userInfo = (UserInfo)JSON.parseObject((String)json, UserInfo.class);
        }
        return userInfo;
    }

    public static String transformCode(String type, String module, String code) {
        String clazz = type;
        try {
            Class<?> enumClazz = Class.forName(clazz);
            Method nameByCode = enumClazz.getMethod("nameByCode", String.class);
            return (String)nameByCode.invoke(null, code);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5f02\u5e38 transformCode {} {} {} {}", new Object[]{type, module, code});
            return code;
        }
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

