/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.filesrv.web.operation;

import com.irdstudio.allintpaas.sdk.filesrv.facade.operation.SeqModelInfoService;
import com.irdstudio.allintpaas.sdk.filesrv.facade.operation.dto.SeqModelInfoDTO;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SeqModelInfoController
extends BaseController<SeqModelInfoDTO, SeqModelInfoService> {
    @RequestMapping(value={"/api/seq/model/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SeqModelInfoDTO>> querySeqModelInfoAll(SeqModelInfoDTO dto) {
        List outputVo = ((SeqModelInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/model/info/{seqId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SeqModelInfoDTO> queryByPk(@PathVariable(value="seqId") String seqId) {
        SeqModelInfoDTO inVo = new SeqModelInfoDTO();
        inVo.setSeqId(seqId);
        SeqModelInfoDTO outputVo = (SeqModelInfoDTO)((SeqModelInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/model/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SeqModelInfoDTO inSeqModelInfoDTO) {
        int outputVo = ((SeqModelInfoService)this.getService()).deleteByPk((Object)inSeqModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/model/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SeqModelInfoDTO inSeqModelInfoDTO) {
        this.setUserInfoToVO(inSeqModelInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSeqModelInfoDTO.setLastModifyUser(userId);
        inSeqModelInfoDTO.setLastModifyTime(now);
        int outputVo = ((SeqModelInfoService)this.getService()).updateByPk((Object)inSeqModelInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/seq/model/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSeqModelInfo(@RequestBody SeqModelInfoDTO inSeqModelInfoDTO) {
        this.setUserInfoToVO(inSeqModelInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inSeqModelInfoDTO.setCreateUser(userId);
        inSeqModelInfoDTO.setCreateTime(now);
        inSeqModelInfoDTO.setLastModifyUser(userId);
        inSeqModelInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inSeqModelInfoDTO.getSeqId())) {
            inSeqModelInfoDTO.setSeqId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((SeqModelInfoService)this.getService()).insert((Object)inSeqModelInfoDTO);
        return this.getResponseData(outputVo);
    }
}

