/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.notify.application.operation;

import com.irdstudio.allintpaas.sdk.notify.facade.operation.SdkNotifyMailService;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service(value="sdkNotifyMailServiceImpl")
public class SdkNotifyMailServiceImpl
implements SdkNotifyMailService {
    @Autowired
    protected JavaMailSender emailSender;
    @Value(value="${spring.mail.username}")
    private String fromAddress;

    public void sendMessage(String to, String subject, String text, Boolean htmlFlag, Map<String, File> attachments) {
        MimeMessage message = this.emailSender.createMimeMessage();
        boolean multipart = !Objects.isNull(attachments) && !attachments.isEmpty();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, multipart);
            helper.setFrom(this.fromAddress);
            helper.setTo(to);
            helper.setSubject(subject);
            if (htmlFlag != null && htmlFlag.booleanValue()) {
                helper.setText(text, htmlFlag.booleanValue());
            } else {
                helper.setText(text);
            }
            if (multipart) {
                for (Map.Entry<String, File> attach : attachments.entrySet()) {
                    String name = attach.getKey();
                    File attachFile = attach.getValue();
                    FileSystemResource file = new FileSystemResource(attachFile);
                    helper.addAttachment(name, (InputStreamSource)file);
                }
            }
            this.emailSender.send(message);
        }
        catch (Exception e) {
            throw new RuntimeException("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38:" + e.getMessage(), e);
        }
    }
}

