/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.beans.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ResourceBundle;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static Logger logger = LoggerFactory.getLogger(FtpUtil.class);
    private static String name;
    private static String password;
    private static String host;
    private static int port;
    private static String localDownloadPath;
    private static String localUploadPath;
    private static String remoteUploadPath;
    private static String remoteDownloadPath;
    private static String code;
    private static volatile boolean isInit;

    private static void init() throws Exception {
        try {
            ResourceBundle res = ResourceBundle.getBundle("ftp");
            host = res.getString("ftp.host");
            port = Integer.valueOf(res.getString("ftp.port"));
            name = res.getString("ftp.username");
            password = res.getString("ftp.pwd");
            localDownloadPath = res.getString("ftp.localDownloadPath");
            localUploadPath = res.getString("ftp.localUploadPath");
            remoteUploadPath = res.getString("ftp.remoteUploadPath");
            remoteDownloadPath = res.getString("ftp.remoteDownloadPath");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6ftp\u914d\u7f6e\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            throw new Exception("\u83b7\u53d6ftp\u914d\u7f6e\u4fe1\u606f\u51fa\u9519\uff01" + e);
        }
        isInit = true;
    }

    public static boolean downLoadFile(String fileName) throws Exception {
        if (!isInit) {
            FtpUtil.init();
        }
        FTPClient ftpClient = null;
        boolean result = false;
        OutputStream ous = null;
        logger.info("downLoadFile \u5f00\u59cb\u4e0b\u8f7d\uff1a" + fileName + "\u6587\u4ef6");
        try {
            if (!(ftpClient != null && ftpClient.isAvailable() || FtpUtil.connect(ftpClient = new FTPClient()))) {
                logger.info("\u94fe\u63a5ftp\u51fa\u9519\uff01");
                boolean bl = false;
                return bl;
            }
            ftpClient.changeWorkingDirectory(remoteDownloadPath);
            ftpClient.enterLocalPassiveMode();
            FTPFile[] files = ftpClient.listFiles(fileName);
            if (files.length == 0) {
                throw new IOException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            ous = new FileOutputStream(new File(localDownloadPath + fileName));
            boolean bl = result = ftpClient.retrieveFile(fileName, ous);
            return bl;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519\uff01", (Throwable)e);
            throw new Exception("\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519\uff01" + e);
        }
        finally {
            if (ous != null) {
                ous.close();
                ous = null;
            }
            if (ftpClient != null) {
                ftpClient.disconnect();
            }
        }
    }

    public static boolean uploadFile(String fileName) throws Exception {
        logger.info("uploadFile \u5f00\u59cb\u4e0a\u4f20\uff1a" + fileName + "\u6587\u4ef6");
        if (!isInit) {
            FtpUtil.init();
        }
        FTPClient ftpClient = null;
        boolean result = false;
        InputStream ins = null;
        try {
            if (!(ftpClient != null && ftpClient.isAvailable() || FtpUtil.connect(ftpClient = new FTPClient()))) {
                logger.info("\u94fe\u63a5ftp\u51fa\u9519\uff01");
                boolean bl = false;
                return bl;
            }
            logger.info("\u5f00\u59cb\u4e0a\u4f20" + fileName);
            ins = new FileInputStream(localUploadPath + fileName);
            ftpClient.changeWorkingDirectory(remoteUploadPath);
            result = ftpClient.storeFile(fileName, ins);
            logger.info("\u4e0a\u4f20\u7ed3\u675f");
        }
        catch (IOException e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01:" + e);
        }
        finally {
            if (ins != null) {
                ins.close();
                ins = null;
            }
            if (ftpClient != null) {
                ftpClient.disconnect();
            }
        }
        return result;
    }

    public static boolean isFileExists(String fileName) throws Exception {
        block10: {
            if (!isInit) {
                FtpUtil.init();
            }
            FTPClient ftpClient = null;
            try {
                if (!(ftpClient != null && ftpClient.isAvailable() || FtpUtil.connect(ftpClient = new FTPClient()))) {
                    logger.info("\u94fe\u63a5ftp\u51fa\u9519\uff01");
                    boolean bl = false;
                    return bl;
                }
                ftpClient.changeWorkingDirectory(remoteUploadPath);
                ftpClient.enterLocalPassiveMode();
                logger.info("\u5f00\u59cb\u6587\u4ef6\u8bfb\u53d6:" + fileName);
                FTPFile[] files = ftpClient.listFiles(fileName);
                if (files.length == 0) {
                    logger.info(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    break block10;
                }
                logger.info(fileName + "\u6587\u4ef6\u5b58\u5728");
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                logger.error("\u68c0\u67e5\u6587\u4ef6\u6587\u4ef6\u662f\u5426\u5b58\u5728\u51fa\u9519\uff01" + e);
                throw new Exception("\u68c0\u67e5\u6587\u4ef6\u6587\u4ef6\u662f\u5426\u5b58\u5728\u51fa\u9519" + e);
            }
            finally {
                if (ftpClient != null) {
                    ftpClient.disconnect();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteRemoteFile(String fileName) throws Exception {
        try {
            if (!isInit) {
                FtpUtil.init();
            }
        }
        catch (Exception e) {
            logger.error("init\u51fa\u9519\uff01" + e);
            return false;
        }
        FTPClient ftpClient = null;
        try {
            if (!(ftpClient != null && ftpClient.isAvailable() || FtpUtil.connect(ftpClient = new FTPClient()))) {
                logger.info("\u94fe\u63a5ftp\u51fa\u9519\uff01");
                boolean bl = false;
                return bl;
            }
            ftpClient.changeWorkingDirectory(remoteUploadPath);
            ftpClient.enterLocalPassiveMode();
            logger.info("\u5f00\u59cb\u6587\u4ef6\u8bfb\u53d6:" + fileName);
            FTPFile[] files = ftpClient.listFiles(fileName);
            if (files.length == 0) {
                logger.info(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25");
                boolean bl = false;
                return bl;
            }
            logger.info(fileName + "\u6587\u4ef6\u5b58\u5728,\u5f00\u59cb\u5220\u9664");
            ftpClient.deleteFile(fileName);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("\u68c0\u67e5\u6587\u4ef6\u6587\u4ef6\u662f\u5426\u5b58\u5728\u51fa\u9519\uff01" + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (ftpClient != null) {
                ftpClient.disconnect();
            }
        }
    }

    public static boolean connect(FTPClient ftpClient) throws SocketException, IOException {
        boolean result = false;
        ftpClient.connect(host, port);
        ftpClient.setControlEncoding(code);
        if (FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
            if (ftpClient.login(name, password)) {
                result = true;
            }
        } else {
            ftpClient.logout();
            if (ftpClient.isConnected()) {
                ftpClient.disconnect();
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        FtpUtil.uploadFile("123.txt");
    }

    static {
        code = "GBK";
        isInit = false;
    }
}

