/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.beans.web.controller;

import com.irdstudio.basic.beans.core.util.StringUtil;
import com.irdstudio.basic.beans.core.vo.ResponseData;
import com.irdstudio.basic.beans.web.controller.AbstractController;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class UploadAndDownloadSupport
extends AbstractController {
    public static final String FILE_SUCCESS = "S";
    public static final String FILE_FAILED = "F";
    public static final String FILE_UPLOAD_NAME = "file";
    public static final String UPLOAD_REQUEST_URL = "/api/upload";
    public static final String DOWNLOAD_REQUEST_URL = "/api/download";
    private final File uploadPath;

    public UploadAndDownloadSupport() {
        File file = new File(this.uploadPath());
        this.validateUploadPathAndThrow(file);
        this.uploadPath = file;
    }

    @PostMapping(value={"/api/upload"})
    public ResponseData<String> upload(@RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (StringUtil.isNullorBank((String)fileName)) {
            fileName = file.getName();
        }
        File destFile = new File(this.uploadPath.getAbsolutePath() + File.separator + fileName);
        try {
            file.transferTo(destFile);
        }
        catch (IOException | IllegalStateException e) {
            this.handleUploadException(e);
            return this.getResponseData(FILE_FAILED);
        }
        return this.getResponseData(FILE_SUCCESS);
    }

    protected void validateUploadPathAndThrow(File dest) throws IllegalArgumentException {
        if (!dest.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84\uff1a" + dest.getPath() + "\u4e0d\u5b58\u5728\uff01");
        }
        if (!dest.isDirectory()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84\uff1a" + dest.getPath() + "\u914d\u7f6e\u9519\u8bef\uff0c \u5fc5\u987b\u4e3a\u76ee\u5f55\u7c7b\u578b\uff01");
        }
    }

    protected void handleUploadException(Exception e) {
        logger.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519!", (Throwable)e);
    }

    protected abstract String uploadPath();

    @PostMapping(value={"/api/download"})
    public ResponseData<String> download(@RequestBody String requeString, HttpServletResponse response) {
        List<File> files = this.getFiles(requeString);
        try {
            for (File file : files) {
                this.doDownLoad(file, (OutputStream)response.getOutputStream());
            }
        }
        catch (Exception e) {
            this.handleDownloadException(e);
            return this.getResponseData(FILE_FAILED);
        }
        return null;
    }

    protected void doDownLoad(File file, OutputStream outputStream) throws IOException {
        Files.copy(file.toPath(), outputStream);
    }

    protected void handleDownloadException(Exception e) {
        logger.error(e.getMessage());
    }

    protected abstract List<File> getFiles(String var1);
}

