/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.api.rest;

import com.irdstudio.bfp.console.dao.domain.SubsCodeBase;
import com.irdstudio.bfp.console.service.facade.BpaInstInfoService;
import com.irdstudio.bfp.console.service.vo.BpaInstInfoHVO;
import com.irdstudio.bfp.console.service.vo.BpaInstInfoVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BpaInstInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="instBatchService")
    private BpaInstInfoService bpaInstInfoService;

    @RequestMapping(value={"/bat/inst/batchs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpaInstInfoVO>> queryBpaInstInfoAll(BpaInstInfoVO vo) {
        List<BpaInstInfoVO> outputVo = this.bpaInstInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/bat/inst/batchs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpaInstInfoVO>> queryBpmBpaInstInfoAll(BpaInstInfoVO vo) {
        String bpaName = vo.getBpaName();
        if (StringUtils.isNotBlank((String)bpaName)) {
            vo.setBpaName(bpaName);
        }
        List<BpaInstInfoVO> outputVo = this.bpaInstInfoService.queryBpmAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/bat/inst/batchs/his"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpaInstInfoHVO>> queryBpmBpaInstInfoAllHis(BpaInstInfoHVO vo) {
        List<BpaInstInfoHVO> outputVo = this.bpaInstInfoService.queryBpmHisAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/batch/{bpaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BpaInstInfoVO> queryByPk(@PathVariable(value="bpaId") String bpaId) {
        BpaInstInfoVO inVo = new BpaInstInfoVO();
        inVo.setBpaId(bpaId);
        BpaInstInfoVO outputVo = this.bpaInstInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/bat/inst/batch"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BpaInstInfoVO inBpaInstInfoVo) {
        int outputVo = this.bpaInstInfoService.deleteByPk(inBpaInstInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/batch"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BpaInstInfoVO inBpaInstInfoVo) {
        int outputVo = this.bpaInstInfoService.updateByPk(inBpaInstInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/batch/change/subs/code"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateBySubsCode(@RequestBody SubsCodeBase subsCodeBase) {
        int outputVo = this.bpaInstInfoService.updateBySubsCode(subsCodeBase);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBpaInstInfo(@RequestBody BpaInstInfoVO inBpaInstInfoVo) {
        int outputVo = this.bpaInstInfoService.insertBpaInstInfo(inBpaInstInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/stop/{bpaId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> stopBpaInstInfo(@PathVariable(value="bpaId") String bpaId) {
        BpaInstInfoVO bpaInstInfoVo = new BpaInstInfoVO();
        bpaInstInfoVo.setBpaId(bpaId);
        bpaInstInfoVo.setBpaInterveneState("1");
        int outputVo = this.bpaInstInfoService.deleteByPk(bpaInstInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/continue/{bpaId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> continueBpaInstInfo(@PathVariable(value="bpaId") String bpaId) {
        BpaInstInfoVO bpaInstInfoVo = new BpaInstInfoVO();
        bpaInstInfoVo.setBpaId(bpaId);
        bpaInstInfoVo.setBpaInterveneState("0");
        int outputVo = this.bpaInstInfoService.deleteByPk(bpaInstInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/end/{bpaId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> endBpaInstInfo(@PathVariable(value="bpaId") String bpaId) {
        BpaInstInfoVO bpaInstInfoVo = new BpaInstInfoVO();
        bpaInstInfoVo.setBpaId(bpaId);
        bpaInstInfoVo.setBpaInterveneState("2");
        int outputVo = this.bpaInstInfoService.deleteByPk(bpaInstInfoVo);
        return this.getResponseData(outputVo);
    }
}

