/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.api.rest;

import com.irdstudio.bfp.console.service.facade.BpaInstTaskService;
import com.irdstudio.bfp.console.service.facade.BpaTaskInfoService;
import com.irdstudio.bfp.console.service.vo.BpaInstTaskTree;
import com.irdstudio.bfp.console.service.vo.BpaInstTaskVO;
import com.irdstudio.bfp.console.service.vo.BpaTaskInfoVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BpaInstTaskController
extends AbstractController {
    @Autowired
    @Qualifier(value="instTaskService")
    private BpaInstTaskService bpaInstTaskService;
    @Autowired
    @Qualifier(value="taskConfigService")
    private BpaTaskInfoService bpaTaskInfoService;

    @RequestMapping(value={"/bat/inst/tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpaInstTaskVO>> queryBpaInstTaskAll(BpaInstTaskVO vo) {
        List<BpaInstTaskVO> outputVo = this.bpaInstTaskService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/bat/inst/tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpaInstTaskVO>> queryBpmBpaInstTaskAll(BpaInstTaskVO vo) {
        List<BpaInstTaskVO> outputVo = this.bpaInstTaskService.queryBpmAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/bat/inst/tasks/his"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpaInstTaskVO>> queryBpmBpaInstTaskAllHis(BpaInstTaskVO vo) {
        List<BpaInstTaskVO> outputVo = this.bpaInstTaskService.queryBpmHisAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/{bpaId}/{bpaOrder}/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BpaInstTaskVO> queryByPk(@PathVariable(value="bpaId") String bpaId, @PathVariable(value="bpaOrder") String bpaOrder, @PathVariable(value="taskId") String taskId) {
        BpaInstTaskVO inVo = new BpaInstTaskVO();
        inVo.setBpaId(bpaId);
        inVo.setBpaOrder(Integer.valueOf(bpaOrder));
        inVo.setTaskId(taskId);
        BpaInstTaskVO outputVo = this.bpaInstTaskService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/bat/inst/task"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BpaInstTaskVO inBpaInstTaskVo) {
        int outputVo = this.bpaInstTaskService.deleteByPk(inBpaInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BpaInstTaskVO inBpaInstTaskVo) {
        int outputVo = this.bpaInstTaskService.updateByPk(inBpaInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBpaInstTask(@RequestBody BpaInstTaskVO inBpaInstTaskVo) {
        int outputVo = this.bpaInstTaskService.insertBpaInstTask(inBpaInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/tree/{bpaSerialNo}/{bpaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BpaInstTaskTree> queryInstTaskTree(@PathVariable(value="bpaSerialNo") String bpaSerialNo, @PathVariable(value="bpaId") String bpaId) {
        BpaInstTaskVO inVo = new BpaInstTaskVO();
        inVo.setBpaSerialNo(bpaSerialNo);
        inVo.setBpaId(bpaId);
        List<BpaInstTaskTree> outputVo = this.bpaInstTaskService.queryBpaInstTaskTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/bpm/bat/inst/task/tree/{bpaSerialNo}/{bpaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BpaInstTaskTree> queryBpmInstTaskTree(@PathVariable(value="bpaSerialNo") String bpaSerialNo, @PathVariable(value="bpaId") String bpaId) {
        BpaInstTaskVO inVo = new BpaInstTaskVO();
        inVo.setBpaSerialNo(bpaSerialNo);
        inVo.setBpaId(bpaId);
        List<BpaInstTaskTree> outputVo = this.bpaInstTaskService.queryBpmBpaInstTaskTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/bpm/bat/inst/task/his/tree/{bpaSerialNo}/{bpaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BpaInstTaskTree> queryBpmInstTaskHisTree(@PathVariable(value="bpaSerialNo") String bpaSerialNo, @PathVariable(value="bpaId") String bpaId) {
        BpaInstTaskVO inVo = new BpaInstTaskVO();
        inVo.setBpaSerialNo(bpaSerialNo);
        inVo.setBpaId(bpaId);
        List<BpaInstTaskTree> outputVo = this.bpaInstTaskService.queryBpmBpaInstTaskHisTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/bat/inst/task/hangup"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangUp(@RequestBody BpaInstTaskVO inBpaInstTaskVo) {
        inBpaInstTaskVo.setTaskInterveneState("2");
        int outputVo = this.bpaInstTaskService.updateTaskInterveneState(inBpaInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/hangdown"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangDown(@RequestBody BpaInstTaskVO inBpaInstTaskVo) {
        inBpaInstTaskVo.setTaskInterveneState("0");
        int outputVo = this.bpaInstTaskService.updateTaskInterveneState(inBpaInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/skip"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> skip(@RequestBody BpaInstTaskVO inBpaInstTaskVo) {
        BpaTaskInfoVO params = new BpaTaskInfoVO();
        params.setTaskId(inBpaInstTaskVo.getTaskId());
        BpaTaskInfoVO configVO = this.bpaTaskInfoService.queryByPk(params);
        ResponseData data = null;
        if (configVO != null && StringUtils.isNotEmpty((CharSequence)configVO.getTaskSkipTactic()) && !configVO.getTaskSkipTactic().equals("2")) {
            inBpaInstTaskVo.setTaskInterveneState("1");
            int outputVo = this.bpaInstTaskService.updateTaskInterveneState(inBpaInstTaskVo);
            data = this.getResponseData(outputVo);
        } else {
            data = this.getResponseData(-1);
            data.setMessage("\u8be5\u4efb\u52a1\u4e0d\u5141\u8bb8\u7f6e\u8fc7\uff01");
        }
        return data;
    }
}

