/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.api.rest;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.bfp.console.service.facade.BpmNodeInfoService;
import com.irdstudio.bfp.console.service.facade.PluginParamTemplateService;
import com.irdstudio.bfp.console.service.vo.BpmNodeInfoVO;
import com.irdstudio.bfp.console.service.vo.PluginParamTemplateVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class PluginParamTemplateController
extends AbstractController {
    @Autowired
    @Qualifier(value="pluginParamTemplateServiceImpl")
    private PluginParamTemplateService pluginParamTemplateService;
    @Autowired
    @Qualifier(value="bpmNodeInfoServiceImpl")
    private BpmNodeInfoService bpmNodeInfoService;

    @RequestMapping(value={"/plugin/param/template/configs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PluginParamTemplateVO>> queryPluginParamTemplateAll(PluginParamTemplateVO vo) {
        List<PluginParamTemplateVO> outputVo = this.pluginParamTemplateService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/plugin/param/template/config/{paramId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PluginParamTemplateVO> queryByPk(@PathVariable(value="paramId") String paramId) {
        PluginParamTemplateVO inVo = new PluginParamTemplateVO();
        inVo.setParamId(paramId);
        PluginParamTemplateVO outputVo = this.pluginParamTemplateService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/plugin/param/template/config"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PluginParamTemplateVO inPluginParamTemplateVo) {
        int outputVo = this.pluginParamTemplateService.deleteByPk(inPluginParamTemplateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/plugin/param/template/config"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PluginParamTemplateVO inPluginParamTemplateVo) throws Exception {
        int outputVo = this.pluginParamTemplateService.updateByPk(inPluginParamTemplateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/plugin/param/template/config"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBpaBaseInfo(@RequestBody PluginParamTemplateVO inPluginParamTemplateVo) {
        int outputVo = this.pluginParamTemplateService.insertPluginParamTemplate(inPluginParamTemplateVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/plugin/param/template/get/{pluginId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PluginParamTemplateVO>> queryByPluginId(@PathVariable(value="pluginId") String pluginId) {
        PluginParamTemplateVO inVo = new PluginParamTemplateVO();
        inVo.setPluginId(pluginId);
        List<PluginParamTemplateVO> outputVo = this.pluginParamTemplateService.queryByPluginId(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"get/child/grid/column"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getColumnByParentId(@RequestBody Map<String, Object> params) {
        String parentId = params.get("parentId").toString();
        String nodeId = params.get("nodeId").toString();
        String paramCode = params.get("paramCode").toString();
        ArrayList columnList = new ArrayList();
        PluginParamTemplateVO inVo = new PluginParamTemplateVO();
        inVo.setParentParamId(parentId);
        List<PluginParamTemplateVO> outputVo = this.pluginParamTemplateService.queryAllOwner(inVo);
        for (PluginParamTemplateVO param : outputVo) {
            HashMap<String, String> columnMap = new HashMap<String, String>();
            columnMap.put("field", param.getParamCode());
            columnMap.put("title", param.getParamName());
            columnList.add(columnMap);
        }
        BpmNodeInfoVO nodeInfoVO = new BpmNodeInfoVO();
        nodeInfoVO.setBpmNodeId(nodeId);
        BpmNodeInfoVO nodeResult = this.bpmNodeInfoService.queryByPk(nodeInfoVO);
        String nodeParam = nodeResult.getBpmNodeParam();
        List dataList = new ArrayList();
        if (StringUtils.isNotBlank((String)nodeParam)) {
            JSONObject nodeJson = JSONObject.parseObject((String)nodeParam);
            dataList = (List)nodeJson.get((Object)paramCode);
        }
        HashMap resultMap = new HashMap();
        resultMap.put("column", columnList);
        resultMap.put("gridData", dataList);
        return resultMap;
    }

    @RequestMapping(value={"/plugin/get/child/param/{parentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PluginParamTemplateVO>> getChildParam(@PathVariable(value="parentId") String parentId) {
        PluginParamTemplateVO inVo = new PluginParamTemplateVO();
        inVo.setParentParamId(parentId);
        List<PluginParamTemplateVO> outputVo = this.pluginParamTemplateService.queryAllOwner(inVo);
        return this.getResponseData(outputVo);
    }
}

