/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.service.impl;

import com.irdstudio.bfp.console.dao.SDutyDao;
import com.irdstudio.bfp.console.dao.domain.SDuty;
import com.irdstudio.bfp.console.service.facade.SDutyService;
import com.irdstudio.bfp.console.service.vo.SDutyVo;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sDutyService")
public class SDutyServiceImpl
implements SDutyService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SDutyServiceImpl.class);
    @Autowired
    private SDutyDao sDutyDao;

    @Override
    public int insertSDuty(SDutyVo inSDutyVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSDutyVo.toString());
        int num = 0;
        try {
            SDuty sDuty = new SDuty();
            this.beanCopy((Object)inSDutyVo, (Object)sDuty);
            String time = TimeUtil.getCurrentDateTime();
            String userId = inSDutyVo.getLoginUserId();
            sDuty.setCreateUser(userId);
            sDuty.setLastUpdateUser(userId);
            sDuty.setCreateTime(time);
            sDuty.setLastUpdateTime(time);
            sDuty.setLegalOrgCode(inSDutyVo.getLoginUserOrgCode());
            num = this.sDutyDao.insertSDuty(sDuty);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(SDutyVo inSDutyVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inSDutyVo));
        int num = 0;
        try {
            SDuty sDuty = new SDuty();
            this.beanCopy((Object)inSDutyVo, (Object)sDuty);
            num = this.sDutyDao.deleteByPk(sDuty);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSDutyVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(SDutyVo inSDutyVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSDutyVo.toString());
        int num = 0;
        try {
            SDuty sDuty = new SDuty();
            this.beanCopy((Object)inSDutyVo, (Object)sDuty);
            sDuty.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            sDuty.setLastUpdateUser(inSDutyVo.getLoginUserId());
            num = this.sDutyDao.updateByPk(sDuty);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSDutyVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public SDutyVo queryByPk(SDutyVo inSDutyVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inSDutyVo));
        try {
            SDuty querySDuty = new SDuty();
            this.beanCopy((Object)inSDutyVo, (Object)querySDuty);
            SDuty queryRslSDuty = this.sDutyDao.queryByPk(querySDuty);
            if (Objects.nonNull((Object)queryRslSDuty)) {
                SDutyVo outSDutyVo = (SDutyVo)((Object)this.beanCopy((Object)queryRslSDuty, (Object)new SDutyVo()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outSDutyVo.toString());
                return outSDutyVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<SDutyVo> queryAllOwner(SDutyVo sDutyVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a" + sDutyVo.toString());
        List list = null;
        try {
            List<SDuty> sDuties = this.sDutyDao.queryAllOwnerByPage(sDutyVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sDuties.size());
            this.pageSet(sDuties, sDutyVo);
            list = (List)this.beansCopy(sDuties, SDutyVo.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SDutyVo> queryAllCurrOrg(SDutyVo sDutyVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<SDuty> sDuties = this.sDutyDao.queryAllCurrOrgByPage(sDutyVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sDuties.size());
        List list = null;
        try {
            this.pageSet(sDuties, sDutyVo);
            list = (List)this.beansCopy(sDuties, SDutyVo.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SDutyVo> queryAllCurrDownOrg(SDutyVo sDutyVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<SDuty> sDuties = this.sDutyDao.queryAllCurrDownOrgByPage(sDutyVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sDuties.size());
        List list = null;
        try {
            this.pageSet(sDuties, sDutyVo);
            list = (List)this.beansCopy(sDuties, SDutyVo.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

