/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.bfp.console.dao.BpaBaseInfoDao;
import com.irdstudio.bfp.console.dao.BpaStageInfoDao;
import com.irdstudio.bfp.console.dao.BpaTaskInfoDao;
import com.irdstudio.bfp.console.dao.BpmBaseInfoDao;
import com.irdstudio.bfp.console.dao.BpmLinkedInfoDao;
import com.irdstudio.bfp.console.dao.BpmNodeInfoDao;
import com.irdstudio.bfp.console.dao.BpmNodeRouteDao;
import com.irdstudio.bfp.console.dao.domain.BpaBaseInfo;
import com.irdstudio.bfp.console.dao.domain.BpaStageInfo;
import com.irdstudio.bfp.console.dao.domain.BpaTaskInfo;
import com.irdstudio.bfp.console.dao.domain.BpmBaseInfo;
import com.irdstudio.bfp.console.dao.domain.BpmLinkedInfo;
import com.irdstudio.bfp.console.dao.domain.BpmNodeInfo;
import com.irdstudio.bfp.console.dao.domain.BpmNodeRoute;
import com.irdstudio.bfp.console.dao.domain.SubsCodeBase;
import com.irdstudio.bfp.console.service.facade.BpmBaseInfoService;
import com.irdstudio.bfp.console.service.vo.BpmBaseInfoVO;
import com.irdstudio.bfp.console.service.vo.BpmNodeInfoVO;
import com.irdstudio.bfp.console.service.vo.BpmNodeRouteVO;
import com.irdstudio.bfp.console.utils.VersionUtil;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.core.util.StringUtils;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.ssm.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmBaseInfoServiceImpl")
public class BpmBaseInfoServiceImpl
implements BpmBaseInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(BpmBaseInfoServiceImpl.class);
    @Autowired
    private BpmBaseInfoDao bpmBaseInfoDao;
    @Autowired
    private BpmNodeInfoDao bpmNodeInfoDao;
    @Autowired
    private BpmLinkedInfoDao bpmLinkedInfoDao;
    @Autowired
    private BpaBaseInfoDao bpaBaseInfoDao;
    @Autowired
    private BpaStageInfoDao bpaStageInfoDao;
    @Autowired
    private BpaTaskInfoDao bpaTaskInfoDao;
    @Autowired
    private BpmNodeRouteDao bpmNodeRouteDao;

    @Override
    public int insertBpmBaseInfo(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inBpmBaseInfoVo.toString());
        int num = 0;
        try {
            String bpmCode = inBpmBaseInfoVo.getBpmCode();
            BpmBaseInfoVO bpmBaseInfoVO = new BpmBaseInfoVO();
            bpmBaseInfoVO.setBpmCode(bpmCode);
            List<BpmBaseInfo> bpmBaseInfoList = this.bpmBaseInfoDao.queryAllOwnerByPage(bpmBaseInfoVO);
            if (bpmBaseInfoList.size() > 0) {
                num = -2;
            } else {
                inBpmBaseInfoVo.setBpmId(KeyUtil.createUUIDKey());
                BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
                this.beanCopy((Object)inBpmBaseInfoVo, (Object)bpmBaseInfo);
                bpmBaseInfo.setBpmState("0");
                bpmBaseInfo.setBpmVersion("0.0.0");
                bpmBaseInfo.setCreateUser("admin");
                bpmBaseInfo.setCreateTime(TimeUtil.getCurrentDateTime());
                num = this.bpmBaseInfoDao.insertBpmBaseInfo(bpmBaseInfo);
                if (num > 0) {
                    BpmNodeInfo startNode = new BpmNodeInfo();
                    startNode.setBpmId(inBpmBaseInfoVo.getBpmId());
                    startNode.setBpmNodeId(KeyUtil.createUUIDKey());
                    startNode.setBpmNodeType("N01");
                    startNode.setBpmNodeName("\u5f00\u59cb\u8282\u70b9");
                    startNode.setH(35);
                    startNode.setW(200);
                    startNode.setX(215);
                    startNode.setY(25);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(startNode);
                    BpmNodeInfo endNode = new BpmNodeInfo();
                    endNode.setBpmId(inBpmBaseInfoVo.getBpmId());
                    endNode.setBpmNodeId(KeyUtil.createUUIDKey());
                    endNode.setBpmNodeType("N99");
                    endNode.setBpmNodeName("\u7ed3\u675f\u8282\u70b9");
                    endNode.setH(35);
                    endNode.setW(200);
                    endNode.setX(215);
                    endNode.setY(startNode.getY() + 100);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(endNode);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    @Override
    public int deleteByPk(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inBpmBaseInfoVo));
        int num = 0;
        try {
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)bpmBaseInfo);
            num = this.bpmBaseInfoDao.deleteByPk(bpmBaseInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmBaseInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inBpmBaseInfoVo.toString());
        int num = 0;
        try {
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)bpmBaseInfo);
            bpmBaseInfo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            num = this.bpmBaseInfoDao.updateByPk(bpmBaseInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmBaseInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateBySubsCode(SubsCodeBase subsCodeBase) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + subsCodeBase.toString());
        int num = 0;
        try {
            num = this.bpmBaseInfoDao.updateBySubsCode(subsCodeBase);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + subsCodeBase.getOldSubsCode() + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return 0;
    }

    @Override
    public BpmBaseInfoVO queryByPk(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inBpmBaseInfoVo));
        try {
            BpmBaseInfo queryBpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)queryBpmBaseInfo);
            BpmBaseInfo queryRslBpmBaseInfo = this.bpmBaseInfoDao.queryByPk(queryBpmBaseInfo);
            if (Objects.nonNull((Object)queryRslBpmBaseInfo)) {
                BpmBaseInfoVO outBpmBaseInfoVo = (BpmBaseInfoVO)((Object)this.beanCopy((Object)queryRslBpmBaseInfo, (Object)new BpmBaseInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outBpmBaseInfoVo.toString());
                return outBpmBaseInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<BpmBaseInfoVO> queryAllOwner(BpmBaseInfoVO bpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BpmBaseInfo> bpmBaseInfos = this.bpmBaseInfoDao.queryAllOwnerByPage(bpmBaseInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmBaseInfos.size());
            this.pageSet(bpmBaseInfos, bpmBaseInfoVo);
            list = (List)this.beansCopy(bpmBaseInfos, BpmBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpmBaseInfoVO> queryAllCurrOrg(BpmBaseInfoVO bpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmBaseInfo> bpmBaseInfos = this.bpmBaseInfoDao.queryAllCurrOrgByPage(bpmBaseInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmBaseInfos.size());
        List list = null;
        try {
            this.pageSet(bpmBaseInfos, bpmBaseInfoVo);
            list = (List)this.beansCopy(bpmBaseInfos, BpmBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Map<String, Object> queryBpmBaseInfoFlowData(String bpmId) {
        HashMap<String, Object> flowData = new HashMap<String, Object>();
        BpmBaseInfo queryBpmBaseInfo = new BpmBaseInfo();
        queryBpmBaseInfo.setBpmId(bpmId);
        try {
            BpmBaseInfo bpmBaseInfo = this.bpmBaseInfoDao.queryByPk(queryBpmBaseInfo);
            if (bpmBaseInfo != null) {
                BpmNodeInfoVO nodeParam = new BpmNodeInfoVO();
                nodeParam.setBpmId(bpmId);
                List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryBpmNodeInfoList(nodeParam);
                List<BpmLinkedInfo> bpmLinkeds = this.bpmLinkedInfoDao.queryBpmLinkedInfosByBpmId(bpmId);
                flowData.put(BpmBaseInfo.class.getSimpleName(), (Object)bpmBaseInfo);
                flowData.put(BpmNodeInfo.class.getSimpleName(), bpmNodeInfos);
                flowData.put(BpmLinkedInfo.class.getSimpleName(), bpmLinkeds);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d41\u7a0b\u914d\u7f6e\u5f02\u5e38\uff01{}", (Throwable)e);
            return null;
        }
        return flowData;
    }

    @Override
    public List<BpmBaseInfoVO> queryAllCurrDownOrg(BpmBaseInfoVO bpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmBaseInfo> bpmBaseInfos = this.bpmBaseInfoDao.queryAllCurrDownOrgByPage(bpmBaseInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmBaseInfos.size());
        List list = null;
        try {
            this.pageSet(bpmBaseInfos, bpmBaseInfoVo);
            list = (List)this.beansCopy(bpmBaseInfos, BpmBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Boolean saveBpmBaseInfoFlowData(Map<String, Object> flowData) {
        BaseInfo checkObj;
        List nodeInfos = (List)flowData.get(BpmNodeInfo.class.getSimpleName());
        List linkeds = (List)flowData.get(BpmLinkedInfo.class.getSimpleName());
        if (CollectionUtils.isNotEmpty((Collection)nodeInfos)) {
            List nodeList = JSON.parseArray((String)JSON.toJSONString((Object)nodeInfos), BpmNodeInfo.class);
            for (BpmNodeInfo node : nodeList) {
                try {
                    checkObj = this.bpmNodeInfoDao.queryByPk(node);
                    if (checkObj != null) {
                        this.bpmNodeInfoDao.updateByPk(node);
                        continue;
                    }
                    this.bpmNodeInfoDao.insertBpmNodeInfo(node);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)linkeds)) {
            List linkedList = JSON.parseArray((String)JSON.toJSONString((Object)linkeds), BpmLinkedInfo.class);
            for (BpmLinkedInfo linked : linkedList) {
                try {
                    checkObj = this.bpmLinkedInfoDao.queryByPk(linked);
                    if (checkObj != null) {
                        this.bpmLinkedInfoDao.updateByPk(linked);
                        continue;
                    }
                    this.bpmLinkedInfoDao.insertBpmLinkedInfo(linked);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean publishAutoFlow(BpmBaseInfoVO inBpmBaseInfoVo) {
        BpmBaseInfo oldBpmBaseInfo;
        String newVersion;
        VersionUtil versionUtil;
        Boolean flag = false;
        Boolean copyFlag = true;
        int baseInfoResult = 0;
        String newBpmId = null;
        BpmBaseInfo newBpmBaseInfo = new BpmBaseInfo();
        if ("0".equals(inBpmBaseInfoVo.getBpmState())) {
            copyFlag = false;
        }
        if (copyFlag.booleanValue()) {
            versionUtil = new VersionUtil();
            newVersion = versionUtil.autoUpgradeVersion(inBpmBaseInfoVo.getBpmVersion());
            oldBpmBaseInfo = new BpmBaseInfo();
            String oldBpmId = inBpmBaseInfoVo.getBpmId();
            oldBpmBaseInfo.setBpmId(oldBpmId);
            oldBpmBaseInfo.setLatestState("N");
            baseInfoResult = this.bpmBaseInfoDao.updateByPk(oldBpmBaseInfo);
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)newBpmBaseInfo);
            newBpmId = KeyUtil.createUUIDKey();
            newBpmBaseInfo.setBpmId(newBpmId);
            newBpmBaseInfo.setBpmVersion(newVersion);
            newBpmBaseInfo.setBpmState("1");
            newBpmBaseInfo.setLatestState("Y");
            newBpmBaseInfo.setCreateUser("admin");
            newBpmBaseInfo.setCreateTime(TimeUtil.getCurrentDateTime());
            newBpmBaseInfo.setLastUpdateUser("admin");
            newBpmBaseInfo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            int insertResult = this.bpmBaseInfoDao.insertBpmBaseInfo(newBpmBaseInfo);
            BpmNodeInfoVO bpmNodeInfoVO = new BpmNodeInfoVO();
            bpmNodeInfoVO.setBpmId(oldBpmId);
            List<BpmNodeInfo> nodeInfoList = this.bpmNodeInfoDao.queryBpmNodeInfoList(bpmNodeInfoVO);
            ArrayList<String> createdNodeList = new ArrayList<String>();
            HashMap<String, String> map = new HashMap<String, String>();
            for (BpmNodeInfo node : nodeInfoList) {
                boolean createFlag = true;
                String newSourceNodeId = null;
                String newTargetNodeId = null;
                if (createdNodeList.size() > 0) {
                    for (int i = 0; i < createdNodeList.size(); ++i) {
                        if (!node.getBpmNodeId().equals(createdNodeList.get(i))) continue;
                        createFlag = false;
                        break;
                    }
                }
                if (createFlag) {
                    BpmNodeInfo newNode = new BpmNodeInfo();
                    this.beanCopy((Object)node, (Object)newNode);
                    newSourceNodeId = KeyUtil.createUUIDKey();
                    newNode.setBpmNodeId(newSourceNodeId);
                    newNode.setBpmId(newBpmId);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(newNode);
                    map.put(node.getBpmNodeId(), newSourceNodeId);
                    createdNodeList.add(node.getBpmNodeId());
                } else {
                    newSourceNodeId = (String)map.get(node.getBpmNodeId());
                }
                BpmLinkedInfo linkedParam = new BpmLinkedInfo();
                linkedParam.setSourceNodeId(node.getBpmNodeId());
                BpmLinkedInfo linkedResult = this.bpmLinkedInfoDao.queryBySourceNode(linkedParam);
                if (linkedResult == null) continue;
                boolean linkFlag = true;
                for (int i = 0; i < createdNodeList.size(); ++i) {
                    if (!linkedResult.getTargetNodeId().equals(createdNodeList.get(i))) continue;
                    linkFlag = false;
                    break;
                }
                if (linkFlag) {
                    String targetNodeId = linkedResult.getTargetNodeId();
                    BpmNodeInfo targetNode = new BpmNodeInfo();
                    targetNode.setBpmNodeId(targetNodeId);
                    BpmNodeInfo targetNodeResult = this.bpmNodeInfoDao.queryByPk(targetNode);
                    newTargetNodeId = KeyUtil.createUUIDKey();
                    targetNodeResult.setBpmNodeId(newTargetNodeId);
                    targetNodeResult.setBpmId(newBpmId);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(targetNodeResult);
                    map.put(linkedResult.getTargetNodeId(), newTargetNodeId);
                    createdNodeList.add(targetNodeId);
                } else {
                    newTargetNodeId = (String)map.get(linkedResult.getTargetNodeId());
                }
                BpmLinkedInfo newLinkedInfo = new BpmLinkedInfo();
                this.beanCopy((Object)linkedResult, (Object)newLinkedInfo);
                newLinkedInfo.setLinkedId(KeyUtil.createUUIDKey());
                newLinkedInfo.setSourceNodeId(newSourceNodeId);
                newLinkedInfo.setTargetNodeId(newTargetNodeId);
                this.bpmLinkedInfoDao.insertBpmLinkedInfo(newLinkedInfo);
            }
        } else {
            versionUtil = new VersionUtil();
            newVersion = versionUtil.autoUpgradeVersion(inBpmBaseInfoVo.getBpmVersion());
            oldBpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)oldBpmBaseInfo);
            oldBpmBaseInfo.setBpmVersion(newVersion);
            oldBpmBaseInfo.setBpmState("1");
            oldBpmBaseInfo.setLastUpdateUser("admin");
            oldBpmBaseInfo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            baseInfoResult = this.bpmBaseInfoDao.updateByPk(oldBpmBaseInfo);
            newBpmId = oldBpmBaseInfo.getBpmId();
            this.beanCopy((Object)oldBpmBaseInfo, (Object)newBpmBaseInfo);
        }
        BpaBaseInfo bpaBaseInfo = new BpaBaseInfo();
        bpaBaseInfo.setBpaId(newBpmId);
        bpaBaseInfo.setBpaName(newBpmBaseInfo.getBpmName());
        bpaBaseInfo.setEquallyTaskAmount(newBpmBaseInfo.getEquallyTaskAmount());
        bpaBaseInfo.setIsRunAgain(newBpmBaseInfo.getIsRunAgain());
        bpaBaseInfo.setValidDate(TimeUtil.getCurDate());
        bpaBaseInfo.setLaunchType("2");
        bpaBaseInfo.setSubsCode(newBpmBaseInfo.getSubsCode());
        bpaBaseInfo.setAgentId("console-executor");
        int batConfResult = this.bpaBaseInfoDao.insertBpaBaseInfo(bpaBaseInfo);
        String sourceNode = "";
        ArrayList<BpmNodeInfo> bpmNodeInfoList = new ArrayList<BpmNodeInfo>();
        BpmNodeInfoVO paramNode = new BpmNodeInfoVO();
        paramNode.setBpmId(newBpmId);
        paramNode.setBpmNodeType("N01");
        BpmNodeInfo firstNode = this.bpmNodeInfoDao.queryNodeByBpmIdAndNodeType(paramNode);
        if (firstNode != null) {
            sourceNode = firstNode.getBpmNodeId();
            bpmNodeInfoList.add(firstNode);
        }
        boolean sortFlag = true;
        while (sortFlag && sourceNode != null) {
            BpmLinkedInfo linkedParam = new BpmLinkedInfo();
            linkedParam.setSourceNodeId(sourceNode);
            BpmLinkedInfo bpmLinkedInfo = this.bpmLinkedInfoDao.queryBySourceNode(linkedParam);
            if (bpmLinkedInfo != null) {
                BpmNodeInfo bpmNodeParam = new BpmNodeInfo();
                bpmNodeParam.setBpmNodeId(bpmLinkedInfo.getTargetNodeId());
                BpmNodeInfo bpmNodeInfo = this.bpmNodeInfoDao.queryByPk(bpmNodeParam);
                bpmNodeInfoList.add(bpmNodeInfo);
                sourceNode = bpmLinkedInfo.getTargetNodeId();
                continue;
            }
            sortFlag = false;
        }
        int stageNum = 0;
        for (BpmNodeInfo node : bpmNodeInfoList) {
            if ("N01".equals(node.getBpmNodeType()) || "N99".equals(node.getBpmNodeType())) continue;
            BpaStageInfo bpaStageInfo = new BpaStageInfo();
            String stageId = String.format("%02d", stageNum);
            bpaStageInfo.setStageId(stageId);
            bpaStageInfo.setStageName(node.getBpmNodeName());
            bpaStageInfo.setBpaId(newBpmId);
            this.bpaStageInfoDao.insertBpaStageInfo(bpaStageInfo);
            BpaTaskInfo bpaTaskInfo = new BpaTaskInfo();
            bpaTaskInfo.setTaskId(node.getBpmNodeId());
            bpaTaskInfo.setTaskName(node.getBpmNodeName());
            bpaTaskInfo.setBpaId(newBpmId);
            bpaTaskInfo.setStageId(bpaStageInfo.getStageId());
            bpaTaskInfo.setLocaleId("db");
            bpaTaskInfo.setPluginType("1");
            if (!StringUtils.stringIsEmptyOrNull((String)node.getBpmNodeCode())) {
                bpaTaskInfo.setPluginId(Integer.parseInt(node.getBpmNodeCode()));
            }
            bpaTaskInfo.setPluginSourceType("1");
            bpaTaskInfo.setPluginParaFlag(node.getBpmNodeId());
            bpaTaskInfo.setTaskPri("1");
            bpaTaskInfo.setTaskRunType("1");
            bpaTaskInfo.setTaskSkipTactic("2");
            bpaTaskInfo.setAgainRunSpace(300);
            bpaTaskInfo.setTaskUseState("0");
            bpaTaskInfo.setTaskUseArea("1");
            bpaTaskInfo.setSubsDsCode("");
            bpaTaskInfo.setRemark("");
            bpaTaskInfo.setPluginParam(node.getBpmNodeParam());
            this.bpaTaskInfoDao.insertBpaTaskInfo(bpaTaskInfo);
            ++stageNum;
        }
        if (baseInfoResult > 0 && batConfResult > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean publishWfiFlow(BpmBaseInfoVO inBpmBaseInfoVo) {
        Boolean flag = false;
        Boolean copyFlag = true;
        int baseInfoResult = 0;
        String newBpmId = null;
        BpmBaseInfo newBpmBaseInfo = new BpmBaseInfo();
        if ("0".equals(inBpmBaseInfoVo.getBpmState())) {
            copyFlag = false;
        }
        if (copyFlag.booleanValue()) {
            VersionUtil versionUtil = new VersionUtil();
            String newVersion = versionUtil.autoUpgradeVersion(inBpmBaseInfoVo.getBpmVersion());
            BpmBaseInfo oldBpmBaseInfo = new BpmBaseInfo();
            String oldBpmId = inBpmBaseInfoVo.getBpmId();
            oldBpmBaseInfo.setBpmId(oldBpmId);
            oldBpmBaseInfo.setLatestState("N");
            baseInfoResult = this.bpmBaseInfoDao.updateByPk(oldBpmBaseInfo);
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)newBpmBaseInfo);
            newBpmId = KeyUtil.createUUIDKey();
            newBpmBaseInfo.setBpmId(newBpmId);
            newBpmBaseInfo.setBpmVersion(newVersion);
            newBpmBaseInfo.setBpmState("1");
            newBpmBaseInfo.setLatestState("Y");
            newBpmBaseInfo.setCreateUser("admin");
            newBpmBaseInfo.setCreateTime(TimeUtil.getCurrentDateTime());
            newBpmBaseInfo.setLastUpdateUser("admin");
            newBpmBaseInfo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            int insertResult = this.bpmBaseInfoDao.insertBpmBaseInfo(newBpmBaseInfo);
            BpmNodeInfoVO bpmNodeInfoVO = new BpmNodeInfoVO();
            bpmNodeInfoVO.setBpmId(oldBpmId);
            List<BpmNodeInfo> nodeInfoList = this.bpmNodeInfoDao.queryBpmNodeInfoList(bpmNodeInfoVO);
            ArrayList<String> createdNodeList = new ArrayList<String>();
            HashMap<String, String> map = new HashMap<String, String>();
            for (BpmNodeInfo node : nodeInfoList) {
                boolean createFlag = true;
                String newSourceNodeId = null;
                String newTargetNodeId = null;
                if (createdNodeList.size() > 0) {
                    for (int i = 0; i < createdNodeList.size(); ++i) {
                        if (!node.getBpmNodeId().equals(createdNodeList.get(i))) continue;
                        createFlag = false;
                        break;
                    }
                }
                if (createFlag) {
                    BpmNodeInfo newNode = new BpmNodeInfo();
                    this.beanCopy((Object)node, (Object)newNode);
                    newSourceNodeId = KeyUtil.createUUIDKey();
                    newNode.setBpmNodeId(newSourceNodeId);
                    newNode.setBpmId(newBpmId);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(newNode);
                    map.put(node.getBpmNodeId(), newSourceNodeId);
                    createdNodeList.add(node.getBpmNodeId());
                } else {
                    newSourceNodeId = (String)map.get(node.getBpmNodeId());
                }
                BpmLinkedInfo linkedParam = new BpmLinkedInfo();
                linkedParam.setSourceNodeId(node.getBpmNodeId());
                BpmLinkedInfo linkedResult = this.bpmLinkedInfoDao.queryBySourceNode(linkedParam);
                if (linkedResult == null) continue;
                boolean linkFlag = true;
                for (int i = 0; i < createdNodeList.size(); ++i) {
                    if (!linkedResult.getTargetNodeId().equals(createdNodeList.get(i))) continue;
                    linkFlag = false;
                    break;
                }
                if (linkFlag) {
                    String targetNodeId = linkedResult.getTargetNodeId();
                    BpmNodeInfo targetNode = new BpmNodeInfo();
                    targetNode.setBpmNodeId(targetNodeId);
                    BpmNodeInfo targetNodeResult = this.bpmNodeInfoDao.queryByPk(targetNode);
                    newTargetNodeId = KeyUtil.createUUIDKey();
                    targetNodeResult.setBpmNodeId(newTargetNodeId);
                    targetNodeResult.setBpmId(newBpmId);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(targetNodeResult);
                    map.put(linkedResult.getTargetNodeId(), newTargetNodeId);
                    createdNodeList.add(targetNodeId);
                } else {
                    newTargetNodeId = (String)map.get(linkedResult.getTargetNodeId());
                }
                BpmLinkedInfo newLinkedInfo = new BpmLinkedInfo();
                this.beanCopy((Object)linkedResult, (Object)newLinkedInfo);
                String newLinkedId = KeyUtil.createUUIDKey();
                newLinkedInfo.setLinkedId(newLinkedId);
                newLinkedInfo.setSourceNodeId(newSourceNodeId);
                newLinkedInfo.setTargetNodeId(newTargetNodeId);
                this.bpmLinkedInfoDao.insertBpmLinkedInfo(newLinkedInfo);
                BpmNodeRouteVO routeParam = new BpmNodeRouteVO();
                routeParam.setLinkedId(linkedResult.getLinkedId());
                List<BpmNodeRoute> routeList = this.bpmNodeRouteDao.queryAllOwnerByPage(routeParam);
                BpmNodeRoute routeResult = routeList.get(0);
                routeResult.setCondId(KeyUtil.createUUIDKey());
                routeResult.setLinkedId(newLinkedId);
                this.bpmNodeRouteDao.insertBpmNodeRoute(routeResult);
            }
        } else {
            VersionUtil versionUtil = new VersionUtil();
            String newVersion = versionUtil.autoUpgradeVersion(inBpmBaseInfoVo.getBpmVersion());
            BpmBaseInfo oldBpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)oldBpmBaseInfo);
            oldBpmBaseInfo.setBpmVersion(newVersion);
            oldBpmBaseInfo.setBpmState("1");
            oldBpmBaseInfo.setLastUpdateUser("admin");
            oldBpmBaseInfo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            baseInfoResult = this.bpmBaseInfoDao.updateByPk(oldBpmBaseInfo);
        }
        if (baseInfoResult > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public int deleteBybpmCode(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inBpmBaseInfoVo));
        int num = 0;
        try {
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)bpmBaseInfo);
            num = this.bpmBaseInfoDao.deleteByBpmCode(bpmBaseInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmBaseInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }
}

