/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.service.impl;

import com.irdstudio.bfp.console.dao.BpmBaseInfoDao;
import com.irdstudio.bfp.console.dao.BpmLinkedInfoDao;
import com.irdstudio.bfp.console.dao.BpmNodeInfoDao;
import com.irdstudio.bfp.console.dao.SSubsDatasourceDao;
import com.irdstudio.bfp.console.dao.domain.BpmBaseInfo;
import com.irdstudio.bfp.console.dao.domain.BpmLinkedInfo;
import com.irdstudio.bfp.console.dao.domain.BpmNodeInfo;
import com.irdstudio.bfp.console.dao.domain.SSubsDatasource;
import com.irdstudio.bfp.console.dao.domain.SubsCodeBase;
import com.irdstudio.bfp.console.service.facade.SSubsDatasourceService;
import com.irdstudio.bfp.console.service.vo.BpmBaseInfoVO;
import com.irdstudio.bfp.console.service.vo.SSubsDatasourceVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.ssm.util.TimeUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sSubsDatasourceService")
public class SSubsDatasourceServiceImpl
implements SSubsDatasourceService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SSubsDatasourceServiceImpl.class);
    @Autowired
    private SSubsDatasourceDao sSubsDatasourceDao;
    @Autowired
    private BpmBaseInfoDao bpmBaseInfoDao;
    @Autowired
    private BpmNodeInfoDao bpmNodeInfoDao;
    @Autowired
    private BpmLinkedInfoDao bpmLinkedInfoDao;

    @Override
    public int insertSSubsDatasource(SSubsDatasourceVO inSSubsDatasourceVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSSubsDatasourceVo.toString());
        SSubsDatasource sSubsDatasource = new SSubsDatasource();
        this.beanCopy((Object)inSSubsDatasourceVo, (Object)sSubsDatasource);
        int num = 0;
        try {
            String subsCode = sSubsDatasource.getSubsCode();
            String subsDsCode = sSubsDatasource.getSubsDsCode();
            SSubsDatasourceVO sSubsDatasourceVO = new SSubsDatasourceVO();
            sSubsDatasourceVO.setSubsCode(subsCode);
            sSubsDatasourceVO.setSubsDsCode(subsDsCode);
            List<SSubsDatasource> sSubsDatasourceList = this.sSubsDatasourceDao.queryAllOwnerByPage(sSubsDatasourceVO);
            String bpmCode = inSSubsDatasourceVo.getSubsDsCode() + "_mysqlbackup";
            BpmBaseInfoVO bpmBaseInfoVO = new BpmBaseInfoVO();
            bpmBaseInfoVO.setBpmCode(bpmCode);
            List<BpmBaseInfo> bpmBaseInfoList = this.bpmBaseInfoDao.queryAllOwnerByPage(bpmBaseInfoVO);
            if (sSubsDatasourceList.size() > 0 || bpmBaseInfoList.size() > 0) {
                num = -2;
            } else {
                this.sSubsDatasourceDao.insertSSubsDatasource(sSubsDatasource);
                bpmBaseInfoVO.setBpmId(KeyUtil.createUUIDKey());
                BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
                this.beanCopy((Object)bpmBaseInfoVO, (Object)bpmBaseInfo);
                bpmBaseInfo.setBpmName(sSubsDatasource.getSubsDsName() + "\u5b9a\u65f6\u5907\u4efd\u670d\u52a1");
                bpmBaseInfo.setSubsCode(sSubsDatasource.getSubsCode());
                bpmBaseInfo.setBpmState("0");
                bpmBaseInfo.setBpmVersion("0.0.0");
                bpmBaseInfo.setCreateUser("admin");
                bpmBaseInfo.setBpmType("1");
                bpmBaseInfo.setCategoryTag("dataBackup");
                bpmBaseInfo.setLatestState("Y");
                bpmBaseInfo.setEffectState("Y");
                bpmBaseInfo.setIsRunAgain("Y");
                bpmBaseInfo.setEquallyTaskAmount(10);
                bpmBaseInfo.setCreateTime(TimeUtil.getCurrentDateTime());
                num = this.bpmBaseInfoDao.insertBpmBaseInfo(bpmBaseInfo);
                if (num > 0) {
                    BpmNodeInfo startNode = new BpmNodeInfo();
                    startNode.setBpmId(bpmBaseInfo.getBpmId());
                    startNode.setBpmNodeId(KeyUtil.createUUIDKey());
                    startNode.setBpmNodeType("N01");
                    startNode.setBpmNodeName("\u5f00\u59cb\u8282\u70b9");
                    startNode.setH(35);
                    startNode.setW(200);
                    startNode.setX(215);
                    startNode.setY(25);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(startNode);
                    BpmNodeInfo mysqlNode = new BpmNodeInfo();
                    mysqlNode.setBpmId(bpmBaseInfo.getBpmId());
                    mysqlNode.setBpmNodeId(KeyUtil.createUUIDKey());
                    mysqlNode.setBpmNodeType("N07");
                    mysqlNode.setBpmNodeName("MySQL\u5907\u4efd\u63d2\u4ef6");
                    mysqlNode.setBpmNodeCode("1096");
                    mysqlNode.setH(35);
                    mysqlNode.setW(200);
                    mysqlNode.setX(215);
                    mysqlNode.setY(startNode.getY() + 100);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(mysqlNode);
                    BpmLinkedInfo bpmLinkedInfo = new BpmLinkedInfo();
                    bpmLinkedInfo.setLinkedId(KeyUtil.createUUIDKey());
                    bpmLinkedInfo.setSourceNodeId(startNode.getBpmNodeId());
                    bpmLinkedInfo.setTargetNodeId(mysqlNode.getBpmNodeId());
                    bpmLinkedInfo.setX1(314);
                    bpmLinkedInfo.setY1(66);
                    bpmLinkedInfo.setX2(314);
                    bpmLinkedInfo.setY2(118);
                    bpmLinkedInfo.setLinkedDesc("start-->mysql");
                    this.bpmLinkedInfoDao.insertBpmLinkedInfo(bpmLinkedInfo);
                    BpmNodeInfo endNode = new BpmNodeInfo();
                    endNode.setBpmId(bpmBaseInfo.getBpmId());
                    endNode.setBpmNodeId(KeyUtil.createUUIDKey());
                    endNode.setBpmNodeType("N99");
                    endNode.setBpmNodeName("\u7ed3\u675f\u8282\u70b9");
                    endNode.setH(35);
                    endNode.setW(200);
                    endNode.setX(215);
                    endNode.setY(mysqlNode.getY() + 100);
                    this.bpmNodeInfoDao.insertBpmNodeInfo(endNode);
                    bpmLinkedInfo.setLinkedId(KeyUtil.createUUIDKey());
                    bpmLinkedInfo.setSourceNodeId(mysqlNode.getBpmNodeId());
                    bpmLinkedInfo.setTargetNodeId(endNode.getBpmNodeId());
                    bpmLinkedInfo.setLinkedDesc("mysql-->end");
                    bpmLinkedInfo.setX1(314);
                    bpmLinkedInfo.setY1(166);
                    bpmLinkedInfo.setX2(314);
                    bpmLinkedInfo.setY2(218);
                    this.bpmLinkedInfoDao.insertBpmLinkedInfo(bpmLinkedInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(SSubsDatasourceVO inSSubsDatasourceVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inSSubsDatasourceVo));
        int num = 0;
        try {
            SSubsDatasource sSubsDatasource = new SSubsDatasource();
            this.beanCopy((Object)inSSubsDatasourceVo, (Object)sSubsDatasource);
            num = this.sSubsDatasourceDao.deleteByPk(sSubsDatasource);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSSubsDatasourceVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(SSubsDatasourceVO inSSubsDatasourceVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSSubsDatasourceVo.toString());
        int num = 0;
        try {
            SSubsDatasource sSubsDatasource = new SSubsDatasource();
            this.beanCopy((Object)inSSubsDatasourceVo, (Object)sSubsDatasource);
            num = this.sSubsDatasourceDao.updateByPk(sSubsDatasource);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSSubsDatasourceVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateBySubsCode(SubsCodeBase subsCodeBase) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + subsCodeBase.toString());
        int num = 0;
        try {
            num = this.sSubsDatasourceDao.updateBySubsCode(subsCodeBase);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + subsCodeBase.getOldSubsCode() + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return 0;
    }

    @Override
    public SSubsDatasourceVO queryByPk(SSubsDatasourceVO inSSubsDatasourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inSSubsDatasourceVo));
        try {
            SSubsDatasource querySSubsDatasource = new SSubsDatasource();
            this.beanCopy((Object)inSSubsDatasourceVo, (Object)querySSubsDatasource);
            SSubsDatasource queryRslSSubsDatasource = this.sSubsDatasourceDao.queryByPk(querySSubsDatasource);
            if (Objects.nonNull((Object)queryRslSSubsDatasource)) {
                SSubsDatasourceVO outSSubsDatasourceVo = (SSubsDatasourceVO)((Object)this.beanCopy((Object)queryRslSSubsDatasource, (Object)new SSubsDatasourceVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outSSubsDatasourceVo.toString());
                return outSSubsDatasourceVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<SSubsDatasourceVO> queryAllOwner(SSubsDatasourceVO sSubsDatasourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<SSubsDatasource> sSubsDatasources = this.sSubsDatasourceDao.queryAllOwnerByPage(sSubsDatasourceVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sSubsDatasources.size());
            this.pageSet(sSubsDatasources, sSubsDatasourceVo);
            list = (List)this.beansCopy(sSubsDatasources, SSubsDatasourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SSubsDatasourceVO> queryAllCurrOrg(SSubsDatasourceVO sSubsDatasourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<SSubsDatasource> sSubsDatasources = this.sSubsDatasourceDao.queryAllCurrOrgByPage(sSubsDatasourceVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sSubsDatasources.size());
        List list = null;
        try {
            this.pageSet(sSubsDatasources, sSubsDatasourceVo);
            list = (List)this.beansCopy(sSubsDatasources, SSubsDatasourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SSubsDatasourceVO> queryAllCurrDownOrg(SSubsDatasourceVO sSubsDatasourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<SSubsDatasource> sSubsDatasources = this.sSubsDatasourceDao.queryAllCurrDownOrgByPage(sSubsDatasourceVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sSubsDatasources.size());
        List list = null;
        try {
            this.pageSet(sSubsDatasources, sSubsDatasourceVo);
            list = (List)this.beansCopy(sSubsDatasources, SSubsDatasourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

