/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.assembly.imdbcp.resource;

import com.irdstudio.bfp.executor.core.assembly.imdbcp.encode.CustomCallableStatement;
import com.irdstudio.bfp.executor.core.assembly.imdbcp.encode.Util;
import com.irdstudio.bfp.executor.core.assembly.imdbcp.resource.RsConnection;
import com.irdstudio.bfp.executor.core.assembly.imdbcp.resource.RsInterface;
import com.irdstudio.bfp.executor.core.assembly.imdbcp.resource.RsResultSet;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RsCallableStatement
extends CustomCallableStatement
implements RsInterface {
    private String lastSql = null;
    private long lastSqlTime = 0L;
    private RsConnection conn = null;

    public RsCallableStatement(CallableStatement _cs, String charSet, int encodeType) {
        super(_cs, charSet, encodeType);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet _rs = this.cs.executeQuery();
        RsResultSet rs = new RsResultSet(_rs, this.charSet, this.encodeType);
        this.conn.addResource(rs);
        rs.setLastSql(this.lastSql);
        return rs;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.setLastSql(sql);
        String enCodeSql = Util.encodeString(sql, this.charSet, this.encodeType);
        ResultSet _rs = this.cs.executeQuery(enCodeSql);
        RsResultSet rs = new RsResultSet(_rs, this.charSet, this.encodeType);
        this.conn.addResource(rs);
        rs.setLastSql(this.lastSql);
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.setLastSql(sql);
        return super.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.conn.removeResource(this);
        super.close();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.setLastSql(sql);
        return super.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet _rs = this.cs.getResultSet();
        RsResultSet rs = new RsResultSet(_rs, this.charSet, this.encodeType);
        this.conn.addResource(rs);
        rs.setLastSql(this.lastSql);
        return rs;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.setLastSql(sql);
        super.addBatch(sql);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet _rs = this.cs.getGeneratedKeys();
        RsResultSet rs = new RsResultSet(_rs, this.charSet, this.encodeType);
        this.conn.addResource(rs);
        rs.setLastSql(this.lastSql);
        return rs;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setLastSql(sql);
        return super.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.setLastSql(sql);
        return super.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.setLastSql(sql);
        return super.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setLastSql(sql);
        return super.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.setLastSql(sql);
        return super.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.setLastSql(sql);
        return super.execute(sql, columnNames);
    }

    @Override
    public String getLastSql() {
        return this.lastSql;
    }

    @Override
    public long getLastSqlTime() {
        return this.lastSqlTime;
    }

    @Override
    public void setLastSql(String sql) {
        this.lastSql = sql;
        this.conn.setLastSql(sql);
        this.lastSqlTime = System.currentTimeMillis();
    }

    @Override
    public RsConnection getBaseConnnection() {
        return this.conn;
    }

    @Override
    public void setBaseConnnection(RsConnection conn) {
        this.conn = conn;
    }
}

