/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.engine;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.bfp.executor.core.job.JavaDataJobDao;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.vo.BpmBaseInfo;
import com.irdstudio.bfp.executor.core.vo.BpmNodeInfo;
import com.irdstudio.bfp.executor.core.vo.BpwInstInfo;
import com.irdstudio.bfp.executor.core.vo.BpwInstTask;
import com.irdstudio.bfp.executor.core.vo.PluginApproveConf;
import com.irdstudio.bfp.executor.core.vo.SSubsInfo;
import com.irdstudio.bfp.executor.core.vo.SUser;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class BpwRunEngine {
    private static final String BATCH_RUN = "run";
    private static final String BATCH_STOP = "stop";
    private static final String BATCH_RERUN = "rerun";
    private static final String BATCH_CONTINUE = "continue";
    private String wfiSerialNo;
    private String bpmId;
    private String param;

    public BpwRunEngine(String wfiSerialNo, String bpmId, String param) {
        this.wfiSerialNo = wfiSerialNo;
        this.bpmId = bpmId;
        this.param = param;
    }

    public void start() throws Exception {
        this.doRunBatchFirst();
    }

    private void doRunBatchFirst() throws Exception {
        Connection conn = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            String sql = "select * from bpm_base_info where bpm_id = ? and bpm_type = '2' limit 1";
            values.clear();
            values.add(this.bpmId);
            BpmBaseInfo bpmBaseInfoFromDB = dao.querySingle(sql, values, BpmBaseInfo.class);
            if (bpmBaseInfoFromDB == null) {
                throw new Exception("\u5f53\u524d\u5ba1\u6279\u6d41\u7a0b\u7f16\u53f7\u3010" + this.bpmId + "\u3011\u4e0d\u5b58\u5728\u751f\u6548\u7684\u5ba1\u6279\u6d41\u7a0b\uff01");
            }
            sql = "select * from bpw_inst_info where wfi_serial_no = ? limit 1";
            values.clear();
            values.add(this.wfiSerialNo);
            BpwInstInfo bpwInstInfoFromDB = dao.querySingle(sql, values, BpwInstInfo.class);
            if (bpwInstInfoFromDB != null) {
                throw new Exception("\u5f53\u524d\u4e1a\u52a1\u6d41\u6c34\u53f7\u3010" + this.wfiSerialNo + "\u3011\u5b58\u5728\u672a\u5ba1\u6279\u5b8c\u7684\u5ba1\u6279\u6d41\u7a0b");
            }
            JSONObject result = JSONObject.parseObject((String)this.param);
            String user = result.get((Object)"sUser").toString();
            String sRole = result.get((Object)"sRole").toString();
            String sOrg = result.get((Object)"sOrg").toString();
            String subsCode = result.get((Object)"subsCode").toString();
            String wfiComment = result.get((Object)"wfiComment").toString();
            boolean userCheck = this.userCheck(user, sOrg, sRole, conn);
            if (!userCheck) {
                throw new Exception("\u6839\u636e\u7528\u6237\u7801\u3010" + user + "\u3011 \u6240\u5c5e\u673a\u6784 \u3010" + sOrg + "\u3011\u89d2\u8272 \u3010" + sRole + "\u3011\u67e5\u8be2\u4e3a\u7a7a\uff01");
            }
            this.subsCodeCheck(subsCode, conn);
            sql = "select * from bpm_node_info where bpm_node_id in (select a.target_node_id from bpm_linked_info a,(select * from bpm_node_info where bpm_id = ? and bpm_node_name = '\u5f00\u59cb\u8282\u70b9') b where a.source_node_id = b.bpm_node_id)";
            values.clear();
            values.add(this.bpmId);
            BpmNodeInfo bpmNodeInfo = dao.querySingle(sql, values, BpmNodeInfo.class);
            if (bpmNodeInfo == null) {
                throw new Exception("\u6839\u636e\u6d41\u7a0bid\u3010" + this.bpmId + "\u3011\u67e5\u8be2\u6d41\u7a0b\u8282\u70b9\u4fe1\u606f\u4e3a\u7a7a");
            }
            String nodeType = bpmNodeInfo.getBpmNodeType();
            if ("N03".equals(nodeType)) {
                sql = "select * from plugin_approve_conf where plugin_conf_id = ?";
                values.clear();
                values.add(bpmNodeInfo.getBpmNodeId());
                PluginApproveConf approveConf = dao.querySingle(sql, values, PluginApproveConf.class);
                if (approveConf == null) {
                    throw new Exception("\u5f53\u524d\u8282\u70b9\u3010" + bpmNodeInfo.getBpmNodeName() + "\u3011\u672a\u914d\u7f6e\u5ba1\u6279\u4fe1\u606f");
                }
            }
            String startTime = TimeUtil.getCurrentDateTime();
            PreparedStatement ps = null;
            ps = conn.prepareStatement("insert into bpw_inst_info (wfi_instance_id,wfi_serial_no,bpm_id,bpm_name,cur_node_id,cur_node_name,cur_approve_user,wfi_start_time,wfi_end_time,wfi_state) values (?,?,?,?,?,?,?,?,?,?)  ");
            String wfi_instance_id = UUID.randomUUID().toString().replaceAll("-", "");
            ps.setString(1, wfi_instance_id);
            ps.setString(2, this.wfiSerialNo);
            ps.setString(3, this.bpmId);
            ps.setString(4, bpmBaseInfoFromDB.getBpmName());
            ps.setString(5, bpmNodeInfo.getBpmNodeId());
            ps.setString(6, bpmNodeInfo.getBpmNodeName());
            ps.setString(7, user);
            ps.setString(8, startTime);
            ps.setString(9, "");
            ps.setString(10, "111");
            ps.execute();
            ps = conn.prepareStatement("insert into bpw_inst_node (wfi_node_id,wfi_instance_id,wfi_serial_no,bpm_node_id,bpm_node_name,start_time,end_time,approve_time,wfi_state) values (?,?,?,?,?,?,?,?,?)");
            String wfi_node_id = UUID.randomUUID().toString().replaceAll("-", "");
            ps.setString(1, wfi_node_id);
            ps.setString(2, wfi_instance_id);
            ps.setString(3, this.wfiSerialNo);
            ps.setString(4, bpmNodeInfo.getBpmNodeId());
            ps.setString(5, bpmNodeInfo.getBpmNodeName());
            ps.setString(6, startTime);
            ps.setString(7, "");
            ps.setString(8, "");
            ps.setString(9, "111");
            ps.execute();
            ps = conn.prepareStatement("insert into bpw_inst_task (wfi_task_id,wfi_node_id,wfi_serial_no,wfi_instance_id,wfi_task_content,bpm_node_id,bpm_node_name,start_time,end_time,approve_time,approve_user_id,approve_org_id) values (?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setString(1, wfi_instance_id);
            ps.setString(2, wfi_node_id);
            ps.setString(3, this.wfiSerialNo);
            ps.setString(4, wfi_instance_id);
            ps.setString(5, wfiComment);
            ps.setString(6, bpmNodeInfo.getBpmNodeId());
            ps.setString(7, bpmNodeInfo.getBpmNodeName());
            ps.setString(8, startTime);
            ps.setString(9, "");
            ps.setString(10, "");
            ps.setString(11, user);
            ps.setString(12, sOrg);
            ps.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doRunBatchNotFirst() throws Exception {
        Connection conn = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            String sql = "select * from bpm_base_info where bpm_id = ? and bpm_type = '2' and bpm_state = '1'  limit 1";
            values.clear();
            values.add(this.bpmId);
            BpmBaseInfo bpmBaseInfoFromDB = dao.querySingle(sql, values, BpmBaseInfo.class);
            if (bpmBaseInfoFromDB == null) {
                throw new Exception("\u5f53\u524d\u5ba1\u6279\u6d41\u7a0b\u7f16\u53f7\u3010" + this.bpmId + "\u3011\u4e0d\u5b58\u5728\u751f\u6548\u7684\u5ba1\u6279\u6d41\u7a0b\uff01");
            }
            sql = "select * from bpw_inst_info where wfi_serial_no = ? limit 1";
            values.clear();
            values.add(this.wfiSerialNo);
            BpwInstInfo bpwInstInfoFromDB = dao.querySingle(sql, values, BpwInstInfo.class);
            if (bpwInstInfoFromDB == null) {
                throw new Exception("\u5f53\u524d\u4e1a\u52a1\u6d41\u6c34\u53f7\u3010" + this.wfiSerialNo + "\u3011\u672a\u67e5\u8be2\u5230\u5ba1\u6279\u4e2d\u7684\u5ba1\u6279\u6d41\u7a0b\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77");
            }
            JSONObject result = JSONObject.parseObject((String)this.param);
            String sUser = result.get((Object)"sUser").toString();
            String sRole = result.get((Object)"sRole").toString();
            String sOrg = result.get((Object)"sOrg").toString();
            String subsCode = result.get((Object)"subsCode").toString();
            String wfiComment = result.get((Object)"wfiComment").toString();
            String nUser = result.get((Object)"nUser").toString();
            String nRole = result.get((Object)"nRole").toString();
            String nOrg = result.get((Object)"nOrg").toString();
            String approveOpinion = result.get((Object)"approveOpinion").toString();
            String approveComment = result.get((Object)"approveComment").toString();
            String bpmNodeId = result.get((Object)"bpmNodeId").toString();
            String wfiTaskId = result.get((Object)"wfiTaskId").toString();
            boolean userCheck = this.userCheck(sUser, sOrg, sRole, conn);
            if (!userCheck) {
                throw new Exception("\u6839\u636e\u7528\u6237\u7801\u3010" + sUser + "\u3011 \u6240\u5c5e\u673a\u6784 \u3010" + sOrg + "\u3011\u89d2\u8272 \u3010" + sRole + "\u3011\u67e5\u8be2\u4e3a\u7a7a\uff01");
            }
            userCheck = this.userCheck(nUser, nOrg, nRole, conn);
            if (!userCheck) {
                throw new Exception("\u6839\u636e\u7528\u6237\u7801\u3010" + nUser + "\u3011 \u6240\u5c5e\u673a\u6784 \u3010" + nOrg + "\u3011\u89d2\u8272 \u3010" + nRole + "\u3011\u67e5\u8be2\u4e3a\u7a7a\uff01");
            }
            this.subsCodeCheck(subsCode, conn);
            sql = "select * from bpw_inst_task where wfi_task_id = ? limit 1";
            values.clear();
            values.add(wfiTaskId);
            BpwInstTask bpwInstTask = dao.querySingle(sql, values, BpwInstTask.class);
            if (bpwInstTask == null) {
                throw new Exception("\u672a\u67e5\u5230\u5f53\u524d\u5ba1\u6279\u4efb\u52a1\u3010" + wfiTaskId + "\u3011\u4fe1\u606f");
            }
            if (!bpwInstTask.getApproveUserId().equals(sUser)) {
                throw new Exception("\u3010" + sUser + "\u3011\u975e\u5f53\u524d\u5ba1\u6279\u4efb\u52a1\u3010" + wfiTaskId + "\u3011\u5ba1\u6279\u4eba");
            }
            if (!bpwInstTask.getBpmNodeId().equals(bpmNodeId)) {
                throw new Exception("\u3010" + bpmNodeId + "\u3011\u975e\u5f53\u524d\u5ba1\u6279\u4efb\u52a1\u3010" + wfiTaskId + "\u3011\u5ba1\u6279\u8282\u70b9");
            }
            sql = "select * from bpm_node_info where bpm_node_id in (select target_node_id from bpm_linked_info where source_node_id = ?)";
            values.clear();
            values.add(bpmNodeId);
            List<BpmNodeInfo> list = dao.queryList(sql, values, BpmNodeInfo.class);
            if (list == null) {
                throw new Exception("\u5f53\u524d\u8282\u70b9\u3010" + bpmNodeId + "\u3011\u672a\u914d\u7f6e\u4e0b\u4e00\u8282\u70b9\uff0c\u6d41\u7a0b\u9519\u8bef");
            }
            if (list.size() > 1) {
            } else {
                BpmNodeInfo bpmNode = list.get(0);
                if ("N99".equals(bpmNode.getBpmNodeType())) {
                    if ("00".equals(approveComment)) {
                        String approveTime = TimeUtil.getCurrentDateTime();
                        sql = "update bpw_inst_task set approve_opinion = ?,approve_comment = ? where wfi_task_id = ?";
                        values.clear();
                        values.add(approveOpinion);
                        values.add(approveComment);
                        values.add(wfiTaskId);
                        dao.update(sql, values);
                        sql = "update bpw_inst_node set approve_time = ?,wfi_state = ? where wfi_node_id = ?";
                        values.clear();
                        values.add(approveTime);
                        values.add("997");
                        values.add(bpmNodeId);
                        dao.update(sql, values);
                        sql = "update bpw_inst_info set wfi_state = ? where wfi_serial_no = ?";
                        values.clear();
                        values.add("997");
                        values.add(this.wfiSerialNo);
                        dao.update(sql, values);
                    }
                } else {
                    String approveTime = TimeUtil.getCurrentDateTime();
                    if ("00".equals(approveOpinion)) {
                        String nodeType = bpmNode.getBpmNodeType();
                        if ("N03".equals(nodeType)) {
                            sql = "select * from plugin_approve_conf where plugin_conf_id = ?";
                            values.clear();
                            values.add(bpmNode.getBpmNodeId());
                            PluginApproveConf approveConf = dao.querySingle(sql, values, PluginApproveConf.class);
                            if (approveConf == null) {
                                throw new Exception("\u5f53\u524d\u8282\u70b9\u3010" + bpmNode.getBpmNodeName() + "\u3011\u672a\u914d\u7f6e\u5ba1\u6279\u4fe1\u606f");
                            }
                        }
                        sql = "update bpw_inst_info set cur_node_id = ?,cur_node_name = ?,cur_approve_user = ? where wfi_serial_no = ?";
                        values.clear();
                        values.add(bpmNode.getBpmNodeId());
                        values.add(bpmNode.getBpmNodeName());
                        values.add(nUser);
                        values.add(this.wfiSerialNo);
                        dao.update(sql, values);
                        sql = "update bpw_inst_node set approve_time = ?,wfi_state = ? where wfi_node_id = ?";
                        values.clear();
                        values.add(approveTime);
                        values.add("997");
                        values.add(bpmNodeId);
                        dao.update(sql, values);
                        sql = "update bpw_inst_task set approve_opinion = ?,approve_comment = ? where wfi_task_id = ?";
                        values.clear();
                        values.add(approveOpinion);
                        values.add(approveComment);
                        values.add(wfiTaskId);
                        dao.update(sql, values);
                        String startTime = TimeUtil.getCurrentDateTime();
                        PreparedStatement ps = null;
                        ps = conn.prepareStatement("insert into bpw_inst_node (wfi_node_id,wfi_instance_id,wfi_serial_no,bpm_node_id,bpm_node_name,start_time,end_time,approve_time,wfi_state) values (?,?,?,?,?,?,?,?,?)");
                        String wfi_node_id = UUID.randomUUID().toString().replaceAll("-", "");
                        ps.setString(1, wfi_node_id);
                        ps.setString(2, bpwInstInfoFromDB.getWfiInstanceId());
                        ps.setString(3, this.wfiSerialNo);
                        ps.setString(4, bpmNode.getBpmNodeId());
                        ps.setString(5, bpmNode.getBpmNodeName());
                        ps.setString(6, startTime);
                        ps.setString(7, "");
                        ps.setString(8, "");
                        ps.setString(9, "111");
                        ps.execute();
                        ps = conn.prepareStatement("insert into bpw_inst_task (wfi_task_id,wfi_node_id,wfi_serial_no,wfi_instance_id,wfi_task_content,bpm_node_id,bpm_node_name,start_time,end_time,approve_time,approve_user_id,approve_user_name,approve_org_id,approve_org_name,approve_opinion,approve_comment) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                        ps.setString(1, bpwInstInfoFromDB.getWfiInstanceId());
                        ps.setString(2, wfi_node_id);
                        ps.setString(3, this.wfiSerialNo);
                        ps.setString(4, bpwInstInfoFromDB.getWfiInstanceId());
                        ps.setString(5, wfiComment);
                        ps.setString(6, bpmNode.getBpmNodeId());
                        ps.setString(7, bpmNode.getBpmNodeName());
                        ps.setString(8, startTime);
                        ps.setString(9, "");
                        ps.setString(10, "");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private boolean userCheck(String userId, String orgId, String roleId, Connection conn) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from s_user a left join s_roleuser b on a.actorno = b.actorno where a.actorno = ? and a.orgid = ? and b.roleno = ?  and a.state = '1' and b.state = '1' ";
        values.add(userId);
        values.add(orgId);
        values.add(roleId);
        SUser nUserSe = dao.querySingle(sql, values, SUser.class);
        return nUserSe != null;
    }

    private boolean subsCodeCheck(String subsCode, Connection conn) throws Exception {
        if (StringUtils.isBlank((CharSequence)subsCode)) {
            throw new Exception("\u83b7\u53d6\u5ba1\u6279\u6d41\u7a0b\u6240\u5c5e\u7cfb\u7edf\u4ee3\u7801\u4e3a\u7a7a\uff01");
        }
        ArrayList<Object> values = new ArrayList<Object>();
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from s_subs_info where subs_code = ?";
        values.clear();
        values.add(subsCode);
        SSubsInfo sSubsInfo = dao.querySingle(sql, values, SSubsInfo.class);
        if (sSubsInfo == null) {
            throw new Exception("\u6839\u636e\u5b50\u7cfb\u7edf\u4ee3\u7801\u3010" + subsCode + "\u3011\u67e5\u8be2\u5b50\u7cfb\u7edf\u57fa\u7840\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return true;
    }

    private void beforeCallBack() throws Exception {
    }

    private void afterCallBack() throws Exception {
    }

    private void getTaskList() throws Exception {
        String userId = "";
        String orgId = "";
        String sql = "";
        if (StringUtil.isNotEmpty((String)userId)) {
            sql = "select a.wfi_task_id,a.wfi_node_id,a.wfi_serial_no,a.wfi_instance_id,a.bpm_node_id,a.wfi_task_content,a.bpm_node_name,a.approve_user_id,a.approve_user_name,a.approve_org_id,a.approve_org_name,c.approve_org_id,c.approve_org_name,c.approve_user_id,c.approve_user_name,c.approve_avail_opinion,c.approve_duty_id,c.approve_duty_name,c.copy_user_id,c.copy_user_name,c.copy_avail_opinion from bpw_inst_node b,bpw_inst_task a LEFT JOIN plugin_approve_conf c on a.bpm_node_id = c.plugin_conf_id    where a.wfi_node_id = b.wfi_node_id and a.approve_user_id = ?";
        }
        if (StringUtil.isNotEmpty((String)orgId)) {
            // empty if block
        }
    }
}

