/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.job;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.bfp.executor.core.job.BeanCache;
import com.irdstudio.bfp.executor.core.utils.BeanUtil;
import com.irdstudio.bfp.executor.core.vo.BaseVo;
import com.irdstudio.bfp.executor.core.vo.BeanColumnMap;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDataJobDao {
    private static final Logger logger = LoggerFactory.getLogger(JavaDataJobDao.class);
    private Connection conn;
    private boolean autoCommit;
    private int defaultBatchCount = 1000;

    public JavaDataJobDao(Connection conn, boolean autoCommit) {
        this.conn = conn;
        this.autoCommit = autoCommit;
        try {
            this.conn.setAutoCommit(this.autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void commit() {
        try {
            if (Objects.nonNull(this.conn) && this.autoCommit && !this.conn.getAutoCommit()) {
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public <T> List<T> queryList(String sql, Class<T> clazz) throws Exception {
        logger.debug("\u6267\u884c\u67e5\u8be2\u5217\u8868\u8bed\u53e5\uff1a{}", (Object)sql);
        List<T> list = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(sql);
            list = BeanUtil.resultSet2Beans(rs, clazz);
            logger.debug("\u6267\u884c\u67e5\u8be2\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(list));
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ResourceCloseUtil.closeResultSet(rs);
                ResourceCloseUtil.closeStatement((Statement)stmt);
                throw throwable;
            }
        }
        ResourceCloseUtil.closeResultSet((ResultSet)rs);
        ResourceCloseUtil.closeStatement((Statement)stmt);
        return list;
    }

    public <T> List<T> queryList(String preparedSql, List<Object> values, Class<T> clazz) throws Exception {
        logger.debug("\u6267\u884c\u67e5\u8be2\u5217\u8868\u8bed\u53e5\uff1a{}\uff0c\u53c2\u6570\u503c\uff1a{}", (Object)preparedSql, (Object)JSONObject.toJSONString(values));
        List<T> list = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(preparedSql);
            for (int i = 0; i < values.size(); ++i) {
                pstmt.setObject(i + 1, values.get(i));
            }
            rs = pstmt.executeQuery();
            list = BeanUtil.resultSet2Beans(rs, clazz);
            logger.debug("\u6267\u884c\u67e5\u8be2\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(list));
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ResourceCloseUtil.closeResultSet(rs);
                ResourceCloseUtil.closeStatement((Statement)pstmt);
                throw throwable;
            }
        }
        ResourceCloseUtil.closeResultSet((ResultSet)rs);
        ResourceCloseUtil.closeStatement((Statement)pstmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryCount(String sql) {
        int count;
        block6: {
            logger.debug("\u6267\u884c\u67e5\u8be2\u8bb0\u5f55\u6570\u8bed\u53e5\uff1a{}", (Object)sql);
            count = 0;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                logger.debug("\u6267\u884c\u67e5\u8be2\u8bb0\u5f55\u6570\u7ed3\u679c\uff1a{}", (Object)count);
                ResourceCloseUtil.closeResultSet((ResultSet)rs);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                ResourceCloseUtil.closeResultSet(rs);
                ResourceCloseUtil.closeStatement((Statement)stmt);
            }
            ResourceCloseUtil.closeStatement((Statement)stmt);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryCount(String preparedSql, List<Object> values) {
        int count;
        block7: {
            logger.debug("\u6267\u884c\u67e5\u8be2\u8bb0\u5f55\u6570\u8bed\u53e5\uff1a{}\uff0c\u53c2\u6570\u503c\uff1a{}", (Object)preparedSql, (Object)JSONObject.toJSONString(values));
            count = 0;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = this.conn.prepareStatement(preparedSql);
                for (int i = 0; i < values.size(); ++i) {
                    pstmt.setObject(i + 1, values.get(i));
                }
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                logger.debug("\u6267\u884c\u67e5\u8be2\u8bb0\u5f55\u6570\u7ed3\u679c\uff1a{}", (Object)count);
                ResourceCloseUtil.closeResultSet((ResultSet)rs);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                ResourceCloseUtil.closeResultSet(rs);
                ResourceCloseUtil.closeStatement((Statement)pstmt);
            }
            ResourceCloseUtil.closeStatement((Statement)pstmt);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql) {
        logger.debug("\u6267\u884c\u66f4\u65b0\u8bed\u53e5\uff1a{}", (Object)sql);
        int count = 0;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            count = stmt.executeUpdate(sql);
            this.commit();
            logger.debug("\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ResourceCloseUtil.closeStatement((Statement)stmt);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String preparedSql, List<Object> values) {
        logger.debug("\u6267\u884c\u66f4\u65b0\u8bed\u53e5\uff1a{}\uff0c\u53c2\u6570\u503c\uff1a{}", (Object)preparedSql, (Object)JSONObject.toJSONString(values));
        int count = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = this.conn.prepareStatement(preparedSql);
            for (int i = 0; i < values.size(); ++i) {
                pstmt.setObject(i + 1, values.get(i));
            }
            count = pstmt.executeUpdate();
            this.commit();
            logger.debug("\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)count);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ResourceCloseUtil.closeStatement(pstmt);
                throw throwable;
            }
            ResourceCloseUtil.closeStatement((Statement)pstmt);
        }
        ResourceCloseUtil.closeStatement((Statement)pstmt);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(String sql) {
        logger.debug("\u6267\u884c\u63d2\u5165\u8bed\u53e5\uff1a{}", (Object)sql);
        int count = 0;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            count = stmt.executeUpdate(sql);
            this.commit();
            logger.debug("\u63d2\u5165\u7ed3\u679c\uff1a{}", (Object)count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ResourceCloseUtil.closeStatement((Statement)stmt);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertAuto(BaseVo baseVo) {
        int count = 0;
        PreparedStatement pstmt = null;
        try {
            Map<String, Object> valueMap = BeanUtil.bean2Map(baseVo);
            List<BeanColumnMap> list = BeanCache.getBeanColumnMaps(baseVo.getClass());
            String sql = BeanUtil.getPrepareInsertSqlFromBean(baseVo.getClass());
            pstmt = this.conn.prepareStatement(sql);
            String beanMemberName = null;
            Object value = null;
            for (int i = 0; i < list.size(); ++i) {
                beanMemberName = list.get(i).getBeanMemberName();
                value = valueMap.containsKey(beanMemberName) ? valueMap.get(beanMemberName) : null;
                pstmt.setObject(i + 1, value);
            }
            count = pstmt.executeUpdate();
            this.commit();
            logger.debug("\u63d2\u5165\u7ed3\u679c\uff1a{}", (Object)count);
            ResourceCloseUtil.closeStatement((Statement)pstmt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ResourceCloseUtil.closeStatement(pstmt);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchInsert(List<? extends BaseVo> baseVos) {
        if (Objects.isNull(baseVos) || baseVos.isEmpty()) {
            return 0;
        }
        long start = System.currentTimeMillis();
        int totalCount = baseVos.size();
        BaseVo baseVo = baseVos.get(0);
        int count = 0;
        PreparedStatement pstmt = null;
        try {
            this.conn.setAutoCommit(false);
            List<BeanColumnMap> beanColumnMaps = BeanCache.getBeanColumnMaps(baseVo.getClass());
            String sql = BeanUtil.getPrepareInsertSqlFromBean(baseVo.getClass());
            pstmt = this.conn.prepareStatement(sql);
            Map<String, Object> valueMap = null;
            String beanMemberName = null;
            Object value = null;
            for (int i = 0; i < totalCount; ++i) {
                valueMap = BeanUtil.bean2Map(baseVos.get(i));
                for (int j = 0; j < beanColumnMaps.size(); ++j) {
                    beanMemberName = beanColumnMaps.get(j).getBeanMemberName();
                    value = valueMap.containsKey(beanMemberName) ? valueMap.get(beanMemberName) : null;
                    pstmt.setObject(j + 1, value);
                }
                pstmt.addBatch();
                if (i + 1 % this.defaultBatchCount != 0 && i != totalCount - 1) continue;
                pstmt.executeBatch();
                this.commit();
            }
            count = totalCount;
            ResourceCloseUtil.closeStatement((Statement)pstmt);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            ResourceCloseUtil.closeStatement(pstmt);
        }
        logger.debug("\u6267\u884c\u6279\u91cf\u63d2\u5165\u5b8c\u6bd5\uff0c\u8017\u65f6\u3010" + (System.currentTimeMillis() - start) + "\u3011ms\uff01");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String sql) {
        logger.debug("\u6267\u884c\u5220\u9664\u8bed\u53e5\uff1a{}", (Object)sql);
        int count = 0;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            count = stmt.executeUpdate(sql);
            this.commit();
            logger.debug("\u6267\u884c\u5220\u9664\u5f71\u54cd\u8bb0\u5f55\u6570\uff1a{}", (Object)count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ResourceCloseUtil.closeStatement((Statement)stmt);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String preparedSql, List<Object> values) {
        logger.debug("\u6267\u884c\u5220\u9664\u8bed\u53e5\uff1a{}\uff0c\u53c2\u6570\u503c\uff1a{}", (Object)preparedSql, (Object)JSONObject.toJSONString(values));
        int count = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = this.conn.prepareStatement(preparedSql);
            for (int i = 0; i < values.size(); ++i) {
                pstmt.setObject(i + 1, values.get(i));
            }
            count = pstmt.executeUpdate();
            this.commit();
            logger.debug("\u5220\u9664\u5f71\u54cd\u8bb0\u5f55\u6570\uff1a{}", (Object)count);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ResourceCloseUtil.closeStatement(pstmt);
                throw throwable;
            }
            ResourceCloseUtil.closeStatement((Statement)pstmt);
        }
        ResourceCloseUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public <T> T querySingle(String sql, Class<T> clazz) throws Exception {
        T t;
        logger.debug("\u6267\u884c\u67e5\u8be2\u5355\u6761\u8bb0\u5f55\u8bed\u53e5\uff1a{}", (Object)sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(sql);
            T bean = BeanUtil.resultSet2Bean(rs, clazz);
            logger.debug("\u67e5\u8be2\u5355\u6761\u8bb0\u5f55\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(bean));
            t = bean;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ResourceCloseUtil.closeStatement((Statement)stmt);
                ResourceCloseUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        ResourceCloseUtil.closeStatement((Statement)stmt);
        ResourceCloseUtil.closeResultSet((ResultSet)rs);
        return t;
    }

    public <T> T querySingle(String preparedSql, List<Object> values, Class<T> clazz) throws Exception {
        T t;
        logger.debug("\u6267\u884c\u67e5\u8be2\u5355\u6761\u8bb0\u5f55\u8bed\u53e5\uff1a{}\uff0c\u53c2\u6570\u503c\uff1a{}", (Object)preparedSql, (Object)JSONObject.toJSONString(values));
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(preparedSql);
            for (int i = 0; i < values.size(); ++i) {
                pstmt.setObject(i + 1, values.get(i));
            }
            rs = pstmt.executeQuery();
            T bean = BeanUtil.resultSet2Bean(rs, clazz);
            logger.debug("\u67e5\u8be2\u5355\u6761\u8bb0\u5f55\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(bean));
            t = bean;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ResourceCloseUtil.closeStatement(pstmt);
                ResourceCloseUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        ResourceCloseUtil.closeStatement((Statement)pstmt);
        ResourceCloseUtil.closeResultSet((ResultSet)rs);
        return t;
    }

    public void simpleDataMove(Class<?> fromClass, Class<?> toClass, String condition) {
        String fromTableName = BeanUtil.getTableName(fromClass);
        String toTableName = BeanUtil.getTableName(toClass);
        logger.debug("\u6267\u884c\u4ece\u3010{}\u3011\u8868\u628a\u6570\u636e\u8f6c\u79fb\u5230\u3010{}\u3011\u8868\uff0cWHERE\u6761\u4ef6\uff1a{}", new Object[]{fromTableName, toTableName, condition});
        String condition_ = this.resloveCondition(condition);
        String insertSql = BeanUtil.getSimpleDataMoveSql(fromClass, toClass) + condition_;
        String deleteSql = "DELETE FROM " + fromTableName + condition_;
        int count = this.insert(insertSql);
        if (count > 0) {
            logger.debug("\u6570\u636e\u8f6c\u79fb\u6210\u529f\uff0c\u5220\u9664\u3010{}\u3011\u8868\u6570\u636e\u3002", (Object)fromTableName);
            this.delete(deleteSql);
        }
    }

    private String resloveCondition(String condition) {
        if (condition == null || "".equals(condition)) {
            return " WHERE 1=1";
        }
        if ("WHERE".equals(condition.replaceAll("\\s", "").toUpperCase().substring(0, 5))) {
            return condition;
        }
        return " WHERE " + condition;
    }
}

