/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.plugin.fileop;

import com.irdstudio.bfp.executor.core.plugin.fileop.PluginFileopConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginFileopConfDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginFileopConfDao.class);
    Connection conn = null;

    public PluginFileopConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginFileopConf queryWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginFileopConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_fileop_conf WHERE plugin_conf_id=? and conf_sort=?");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginFileopConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setFileOp(rs.getString("file_op"));
                dc.setFileTarget(rs.getString("file_target"));
                dc.setOpCycleDay(rs.getInt("op_cycle_day"));
                dc.setLastOpDate(rs.getString("last_op_date"));
                dc.setDistanceDay(rs.getInt("distance_day"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginFileopConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginFileopConf> queryWithPluginConfId(String pluginConfId) throws SQLException {
        ArrayList<PluginFileopConf> dcList = new ArrayList<PluginFileopConf>();
        PluginFileopConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_fileop_conf WHERE plugin_conf_id=? order by conf_sort");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginFileopConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setFileOp(rs.getString("file_op"));
                dc.setFileTarget(rs.getString("file_target"));
                dc.setOpCycleDay(rs.getInt("op_cycle_day"));
                dc.setLastOpDate(rs.getString("last_op_date"));
                dc.setDistanceDay(rs.getInt("distance_day"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginFileopConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

