/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.plugin.ftp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClient {
    private static final Logger logger = LoggerFactory.getLogger(FtpClient.class);
    private final int SO_TIME_OUT = 3000;
    private final int BLOCK_SIZE = 1024;
    private String sp = "/";
    private String delimiter = "\r\n";
    private boolean DEBUG = false;
    private PrintStream ps = System.out;
    private String localIp = null;
    private Socket so = null;
    private BufferedReader socket_reader = null;
    private OutputStream socket_writer = null;
    StringBuffer response = new StringBuffer();

    public FtpClient() {
        try {
            this.localIp = InetAddress.getLocalHost().getHostAddress().replaceAll("[.]", ",");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
    }

    public boolean openSession(String remotehost, int port, String user, String pass) {
        if (this.so != null && !this.so.isClosed()) {
            this.closeSession();
        }
        this.so = new Socket();
        try {
            this.so.connect(new InetSocketAddress(remotehost, port), 3000);
            this.socket_reader = new BufferedReader(new InputStreamReader(this.so.getInputStream()));
            this.socket_writer = this.so.getOutputStream();
            if (!this.isPositiveResponse()) {
                return false;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
            return false;
        }
        return this.authenticate(user, pass);
    }

    public void closeSession() {
        if (this.so != null && this.so.isConnected()) {
            this.execCmd("quit" + this.delimiter);
            try {
                this.socket_writer.close();
                this.socket_reader.close();
                this.so.close();
            }
            catch (IOException e) {
                this.debugPrint(e.getMessage());
                logger.error(e.getMessage());
            }
        }
    }

    public boolean downloadDirectory(String remotedir, String localdir) {
        int i;
        if (!this.changeDirectory(remotedir)) {
            return false;
        }
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> dirs = new ArrayList<String>();
        try {
            this.getRemoteFileList(files, dirs);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
            return false;
        }
        int j = files.size();
        for (i = 0; i < j; ++i) {
            if (this.downloadFile(files.get(i).toString(), localdir)) continue;
            return false;
        }
        j = dirs.size();
        for (i = 0; i < j; ++i) {
            String tmp_dir = dirs.get(i).toString();
            String tmp_localdir = localdir + File.separator + tmp_dir;
            File tmp_file = new File(tmp_localdir);
            if (!tmp_file.exists()) {
                tmp_file.mkdirs();
            }
            if (this.downloadDirectory(remotedir + this.sp + tmp_dir, tmp_localdir)) continue;
            return false;
        }
        return true;
    }

    public boolean uploadDirectory(String localdir, String remotedir) {
        File dir = new File(localdir);
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                String tmp_dir = remotedir + this.sp + files[i].getName();
                this.makedir(tmp_dir);
                this.uploadDirectory(files[i].getAbsolutePath(), tmp_dir);
                continue;
            }
            if (this.uploadFile(files[i].getAbsolutePath(), remotedir)) continue;
            return false;
        }
        return true;
    }

    public boolean downloadFile(String remotefile, String localdir) {
        return this.downloadFile(remotefile, localdir, false);
    }

    public boolean downloadFile(String remotefile, OutputStream receiveStream) {
        return this.downloadFile(remotefile, receiveStream, false);
    }

    public boolean downloadFile(String remotefile, OutputStream receiveStream, boolean isUnCompress) {
        int d = remotefile.lastIndexOf(92);
        if (d == -1) {
            d = remotefile.lastIndexOf(47);
        }
        if (d != -1) {
            String remotedir = remotefile.substring(0, d);
            this.changeDirectory(remotedir);
        }
        String remotefilename = remotefile.substring(d + 1);
        this.setDataType("I");
        String cmd = "retr " + remotefilename;
        try {
            OutputStream os = this.getOutputStream(receiveStream, false);
            return this.executeDataCmd(cmd, os, isUnCompress);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
        return false;
    }

    public boolean downloadFile(String remotefile, String localdir, boolean isUnCompress) {
        int d = remotefile.lastIndexOf(92);
        if (d == -1) {
            d = remotefile.lastIndexOf(47);
        }
        if (d != -1) {
            String remotedir = remotefile.substring(0, d);
            this.changeDirectory(remotedir);
        }
        String remotefilename = remotefile.substring(d + 1);
        this.setDataType("I");
        String cmd = "retr " + remotefilename;
        File tmp_file = new File(localdir);
        if (!tmp_file.exists()) {
            tmp_file.mkdirs();
        }
        try {
            OutputStream os = this.getOutputStream(localdir + File.separator + remotefilename, false);
            return this.executeDataCmd(cmd, os, isUnCompress);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
        return false;
    }

    public boolean uploadFile(String localfile, String remotedir, boolean isCompress) {
        this.changeDirectory(remotedir);
        this.setDataType("I");
        String cmd = "stor " + new File(localfile).getName();
        try {
            InputStream is = this.getInputStream(localfile, false);
            return this.executeDataCmd(cmd, is, isCompress);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
        return false;
    }

    public boolean uploadFile(String localfile, String remotedir) {
        return this.uploadFile(localfile, remotedir, false);
    }

    public boolean changeDirectory(String remotedir) {
        this.execCmd("cwd " + remotedir);
        return this.isPositiveResponse();
    }

    public boolean changeDirectoryEx(String remotedir) {
        if (this.changeDirectory(remotedir)) {
            return true;
        }
        String[] dirs = null;
        String tmpD = null;
        dirs = remotedir.replaceAll("\\\\", "/").split("/");
        this.changeDirectory("/");
        for (int i = 0; i < dirs.length; ++i) {
            tmpD = dirs[i].trim();
            if (tmpD.equals("") || this.changeDirectory(tmpD)) continue;
            this.makedir(tmpD);
            if (this.changeDirectory(tmpD)) continue;
            return false;
        }
        return true;
    }

    public String getCurrentDirectory() {
        this.execCmd("pwd" + this.delimiter);
        if (!this.isPositiveResponse()) {
            return null;
        }
        int begin = this.response.toString().indexOf(34) + 1;
        int end = this.response.toString().lastIndexOf(34);
        String path = this.response.toString().substring(begin, end);
        return path;
    }

    public boolean makedir(String pathname) {
        this.execCmd("mkd " + pathname);
        return this.isPositiveResponse();
    }

    public boolean removedir(String pathname) {
        this.execCmd("rmd " + pathname);
        return this.isPositiveResponse();
    }

    public boolean removefile(String filename) {
        this.execCmd("dele " + filename + this.delimiter);
        return this.isPositiveResponse();
    }

    public boolean renamefile(String filename, String newname) {
        this.execCmd("rnfr " + filename + this.delimiter);
        if (!this.isPositiveResponse()) {
            return false;
        }
        this.execCmd("rnto " + newname + this.delimiter);
        return this.isPositiveResponse();
    }

    public boolean getRemoteFileList(ArrayList<String> files, ArrayList<String> dirs) throws Exception {
        StringBuffer tmp_list;
        String cmd = "list" + this.delimiter;
        if (!this.executeDataCmd(cmd, tmp_list = new StringBuffer())) {
            return false;
        }
        StringTokenizer token = new StringTokenizer(tmp_list.toString(), this.delimiter);
        while (token.hasMoreTokens()) {
            String tmp_str = token.nextToken();
            this.debugPrint(tmp_str);
            if (tmp_str.length() <= 0) continue;
            switch (tmp_str.charAt(0)) {
                case '-': {
                    files.add(this.parseListName(tmp_str));
                    break;
                }
                case 'd': {
                    dirs.add(this.parseListName(tmp_str));
                }
            }
        }
        return false;
    }

    public boolean isExistsOnServer(String dir) {
        String cmd = "nlst" + this.delimiter;
        StringBuffer tmp_list = new StringBuffer();
        try {
            if (!this.executeDataCmd(cmd, tmp_list)) {
                return false;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
            return false;
        }
        StringTokenizer token = new StringTokenizer(tmp_list.toString(), this.delimiter);
        String tmp_str = dir;
        if (this.DEBUG) {
            this.debugPrint(tmp_list.toString());
        }
        String tmp = null;
        while (token.hasMoreTokens()) {
            tmp = token.nextToken();
            if (!tmp_str.equals(tmp.replaceFirst("\r", ""))) continue;
            return true;
        }
        return false;
    }

    private String parseListName(String tmp_str) {
        int begin = tmp_str.lastIndexOf(32);
        return tmp_str.substring(begin + 1);
    }

    public void setFtpServerSeparator(String info) {
        if (info.indexOf("/") != -1) {
            this.sp = "/";
            this.delimiter = "\n";
        }
        if (info.indexOf("\\") != -1) {
            this.sp = "\\";
        }
    }

    public String getFtpServerSeparator() {
        return this.sp;
    }

    public String getResponseText() {
        return this.response.toString();
    }

    public void setDebug(boolean isDebug) {
        this.DEBUG = isDebug;
    }

    public void setDebugStream(PrintStream p) {
        this.ps = p;
    }

    public boolean setDebugStream(String logfile) {
        try {
            this.ps = new PrintStream(new FileOutputStream(logfile));
            return true;
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean executeDataCmd(String cmd, InputStream fis, boolean isCompress) throws IOException, SocketException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean executeDataCmd(String cmd, OutputStream fos, boolean isUnCompress) throws IOException, SocketException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean executeDataCmd(String cmd, StringBuffer filelist) throws IOException, SocketException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean setServerPort(ServerSocket so) {
        int port = so.getLocalPort();
        this.execCmd("port " + this.localIp + "," + port / 256 + "," + port % 256);
        return this.isPositiveResponse();
    }

    private boolean authenticate(String user, String pass) {
        this.execCmd("user " + user);
        if (!this.isPositiveResponse()) {
            return false;
        }
        this.execCmd("pass " + pass);
        return this.isPositiveResponse();
    }

    private void execCmd(String cmd) {
        cmd = cmd + this.delimiter;
        this.debugPrint(cmd);
        try {
            this.socket_writer.write(cmd.getBytes());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
    }

    private boolean isPositiveResponse() {
        this.getServerResponse();
        int errcode = this.getResponseErrorCode();
        if (this.isPositivePreliminaryResponse(errcode)) {
            this.getServerResponse();
            return this.isPositiveCompleteResponse(this.getResponseErrorCode());
        }
        return this.isPositiveCompleteResponse(errcode) || this.isPositiveIntermediateResponse(errcode);
    }

    private int getResponseErrorCode() {
        return Integer.parseInt(this.response.toString().substring(0, 3));
    }

    private boolean isPositivePreliminaryResponse(int errcode) {
        return errcode >= 100 && errcode < 200;
    }

    private boolean isPositiveCompleteResponse(int errcode) {
        return errcode >= 200 && errcode < 300;
    }

    private boolean isPositiveIntermediateResponse(int errcode) {
        return errcode >= 300 && errcode < 400;
    }

    private void getServerResponse() {
        this.response.setLength(0);
        String tmp = null;
        try {
            do {
                tmp = this.socket_reader.readLine();
                this.debugPrint(tmp);
                this.response.append(tmp);
            } while (Character.isDigit(tmp.charAt(0)) && tmp.charAt(3) == '-');
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
    }

    private boolean setDataType(String tp) {
        try {
            this.execCmd("type " + tp);
            if (!this.isPositiveResponse()) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
            return false;
        }
        return true;
    }

    private void transferData(InputStream is, OutputStream os) {
        int amount = 0;
        byte[] data = new byte[1024];
        try {
            while ((amount = is.read(data, 0, 1024)) > 0) {
                os.write(data, 0, amount);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
    }

    private void transferData(InputStream is, StringBuffer sb) {
        int amount = 0;
        byte[] data = new byte[1024];
        try {
            while ((amount = is.read(data, 0, 1024)) > 0) {
                sb.append(new String(data, 0, amount));
            }
            is.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.debugPrint(e.getMessage());
        }
    }

    private OutputStream getOutputStream(String filename, boolean isCompress) throws FileNotFoundException, IOException {
        if (isCompress) {
            return new GZIPOutputStream(new FileOutputStream(filename));
        }
        return new FileOutputStream(filename);
    }

    private OutputStream getOutputStream(OutputStream os, boolean isCompress) throws IOException {
        if (isCompress) {
            return new GZIPOutputStream(os, 1024);
        }
        return os;
    }

    private InputStream getInputStream(String filename, boolean isUnCompress) throws FileNotFoundException, IOException {
        if (isUnCompress) {
            return new GZIPInputStream(new FileInputStream(filename));
        }
        return new FileInputStream(filename);
    }

    private InputStream getInputStream(InputStream is, boolean isCompress) throws IOException {
        if (isCompress) {
            return new GZIPInputStream(is, 1024);
        }
        return is;
    }

    private void debugPrint(String info) {
        if (this.DEBUG) {
            this.ps.println("DEBUG-------------->" + info);
        }
    }
}

