/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.utils;

import com.alibaba.fastjson.JSON;
import com.irdstudio.bfp.executor.core.annotation.TableMode;
import com.irdstudio.bfp.executor.core.job.BeanCache;
import com.irdstudio.bfp.executor.core.vo.BeanColumnMap;
import com.irdstudio.bfp.executor.core.vo.BeanColumnMaps;
import com.irdstudio.bfp.executor.core.vo.BeanTableMap;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);
    private static String TEMPLATE_FILES_ROOT_PATH = "/template";
    private static GroupTemplate groupTemplate;
    private static final String RS_TO_BEANS_TEMPLATE = "resultset.beans.json.template";
    private static final String RS_TO_BEAN_TEMPLATE = "resultset.bean.json.template";

    public static <T> T resultSet2Bean(ResultSet rs, Class<T> clazz) throws Exception {
        BeanColumnMaps beanColumnMaps = new BeanColumnMaps();
        List<BeanColumnMap> mappings = BeanCache.getBeanColumnMaps(clazz);
        Object columnValue = null;
        if (rs.next()) {
            Iterator<BeanColumnMap> iterator = mappings.iterator();
            while (iterator.hasNext()) {
                BeanColumnMap mapping;
                columnValue = rs.getObject((mapping = iterator.next()).getColumnName());
                mapping.setValue(columnValue == null ? null : columnValue.toString());
                mapping.setValueIsNull(columnValue == null || "".equals(columnValue.toString()));
            }
        } else {
            return null;
        }
        beanColumnMaps.setMappings(mappings);
        String jsonStr = BeanUtil.getTemplateAll(RS_TO_BEAN_TEMPLATE, beanColumnMaps);
        Object bean = JSON.parseObject((String)jsonStr, clazz);
        return (T)bean;
    }

    public static <T> List<T> resultSet2Beans(ResultSet rs, Class<T> clazz) throws Exception {
        BeanTableMap beanTableMap = new BeanTableMap();
        ArrayList<BeanColumnMaps> beanColumnMapsList = new ArrayList<BeanColumnMaps>();
        List<BeanColumnMap> sameBeanColumnMaps = BeanCache.getBeanColumnMaps(clazz);
        BeanColumnMaps beanColumnMaps = null;
        ArrayList<BeanColumnMap> mappings = null;
        BeanColumnMap beanColumnMap = null;
        Object columnValue = null;
        String columnValue_ = null;
        while (rs.next()) {
            beanColumnMaps = new BeanColumnMaps();
            mappings = new ArrayList<BeanColumnMap>();
            for (BeanColumnMap sameBeanColumnMap : sameBeanColumnMaps) {
                beanColumnMap = new BeanColumnMap();
                columnValue = rs.getObject(sameBeanColumnMap.getColumnName());
                String string = columnValue == null ? null : (columnValue_ = columnValue.toString() == null ? null : columnValue.toString());
                if (columnValue_ != null && columnValue_.indexOf("\"") != -1) {
                    columnValue_ = columnValue_.replaceAll("\"", "\\\\\"");
                }
                beanColumnMap.setBeanMemberName(sameBeanColumnMap.getBeanMemberName());
                beanColumnMap.setNumber(sameBeanColumnMap.isNumber());
                beanColumnMap.setValue(columnValue_);
                beanColumnMap.setValueIsNull(columnValue == null || "".equals(columnValue.toString()));
                mappings.add(beanColumnMap);
            }
            beanColumnMaps.setMappings(mappings);
            beanColumnMapsList.add(beanColumnMaps);
        }
        if (Objects.isNull(beanColumnMapsList) || beanColumnMapsList.isEmpty()) {
            return null;
        }
        beanTableMap.setBeanColumnMapList(beanColumnMapsList);
        String listJsonStr = BeanUtil.getTemplateAll(RS_TO_BEANS_TEMPLATE, beanTableMap);
        List beans = JSON.parseArray((String)listJsonStr, clazz);
        return beans;
    }

    public static String getPrepareInsertSqlFromBean(Class<?> clazz) {
        int i;
        List<BeanColumnMap> list = BeanCache.getBeanColumnMaps(clazz);
        StringBuffer strb = new StringBuffer();
        strb.append("INSERT INTO ").append(BeanUtil.getTableName(clazz)).append(" (");
        int columnSize = list.size();
        for (i = 0; i < columnSize; ++i) {
            if (i == columnSize - 1) {
                strb.append(list.get(i).getColumnName()).append(") VALUES (");
                continue;
            }
            strb.append(list.get(i).getColumnName()).append(", ");
        }
        for (i = 0; i < columnSize; ++i) {
            if (i == columnSize - 1) {
                strb.append("?)");
                continue;
            }
            strb.append("?, ");
        }
        logger.debug("\u4ece\u5b9e\u4f53\u7c7b\u4e2d\u83b7\u53d6\u9884\u7f16\u8bd1INSERT\u8bed\u53e5\u4e3a\uff1a" + strb);
        return strb.toString();
    }

    public static String getTableName(Class<?> clazz) {
        TableMode tm = clazz.getAnnotation(TableMode.class);
        return tm == null ? "" : tm.dbName();
    }

    public static String getSimpleDataMoveSql(Class<?> fromClass, Class<?> toClass) {
        StringBuffer sql = new StringBuffer();
        String fromTableName = BeanUtil.getTableName(fromClass);
        String toTableName = BeanUtil.getTableName(toClass);
        String sameColumnsStr = BeanUtil.getSameColumnStrFromTwoBeans(fromClass, toClass);
        sql.append("INSERT INTO ").append(toTableName).append(" (").append(sameColumnsStr);
        sql.append(") SELECT ").append(sameColumnsStr).append(" FROM ").append(fromTableName);
        return sql.toString();
    }

    public static String getSameColumnStrFromTwoBeans(Class<?> clazz1, Class<?> clazz2) {
        StringBuffer str = new StringBuffer();
        List<String> columns = BeanUtil.getSameColumnListFromTwoBeans(clazz1, clazz2);
        for (int i = 0; i < columns.size(); ++i) {
            if (i == columns.size() - 1) {
                str.append(columns.get(i));
                continue;
            }
            str.append(columns.get(i)).append(", ");
        }
        return str.toString();
    }

    public static List<String> getSameColumnListFromTwoBeans(Class<?> clazz1, Class<?> clazz2) {
        String tableName1 = BeanUtil.getTableName(clazz1);
        String tableName2 = BeanUtil.getTableName(clazz2);
        List<String> columns = BeanCache.getTwoBeansSameColumns(tableName1 + tableName2);
        if (Objects.isNull(columns)) {
            columns = BeanCache.getTwoBeansSameColumns(tableName2 + tableName1);
        }
        if (Objects.isNull(columns)) {
            columns = new ArrayList<String>();
            List<BeanColumnMap> list1 = BeanCache.getBeanColumnMaps(clazz1);
            List<BeanColumnMap> list2 = BeanCache.getBeanColumnMaps(clazz2);
            for (BeanColumnMap m1 : list1) {
                for (BeanColumnMap m2 : list2) {
                    if (!m1.getColumnName().equalsIgnoreCase(m2.getColumnName())) continue;
                    columns.add(m1.getColumnName());
                }
            }
            BeanCache.setTwoBeansSameColumns(tableName1 + tableName2, columns);
        }
        return columns;
    }

    private static String getTemplateAll(String templateName, Object bean) {
        Map<String, Object> paramMap = null;
        if (bean != null) {
            paramMap = BeanUtil.beanAll2Map(bean);
        }
        return BeanUtil.getTemplate(templateName, paramMap);
    }

    private static String getTemplate(String templatePath, Map<String, Object> paramMap) {
        if (Objects.isNull(templatePath)) {
            throw new NullPointerException("\u4f20\u5165\u6a21\u677f\u4e3a\u7a7a\uff01");
        }
        Template template = groupTemplate.getTemplate(templatePath);
        template.binding(paramMap);
        paramMap.keySet().stream().forEach(s -> {
            if (paramMap.get(s) instanceof List) {
                template.binding(s, paramMap.get(s));
            }
        });
        return template.render();
    }

    public static Map<String, Object> bean2Map(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                Object value;
                String key = property.getName();
                if (key.equals("class") || (value = (getter = property.getReadMethod()).invoke(bean, new Object[0])) == null) continue;
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bean2Map fail: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> beanAll2Map(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(bean, new Object[0]);
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bean2Map fail: " + e.getMessage(), e);
        }
    }

    public static void map2Bean(Map<String, Object> map, Object bean) {
        if (map == null || bean == null) {
            throw new NullPointerException();
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("map2Bean fail: " + e.getMessage(), e);
        }
    }

    static {
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader(TEMPLATE_FILES_ROOT_PATH);
        Configuration cfg = null;
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
    }
}

