/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.engine;

import com.irdstudio.bfp.executor.core.BpaRunProcess;
import com.irdstudio.bfp.executor.core.dao.domain.BpaBaseInfo;
import com.irdstudio.bfp.executor.core.job.JavaDataJobDao;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.util.DataMoveUtil;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.util.TableMove;
import com.irdstudio.bfp.executor.core.utils.pub.ConnectionUtil;
import com.irdstudio.bfp.executor.core.vo.BpaInstInfo;
import com.irdstudio.bfp.executor.core.vo.BpaInstTask;
import com.irdstudio.bfp.executor.core.vo.BpaTaskInfo;
import com.irdstudio.bfp.executor.core.vo.SSubsInfo;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BpaMultipleEngine {
    private static final String BATCH_RUN = "run";
    private static final String BATCH_STOP = "stop";
    private static final String BATCH_RERUN = "rerun";
    private static final String BATCH_CONTINUE = "continue";
    private String batchAction;
    private String batchId;
    private String batchSerialNo;

    public BpaMultipleEngine(String batchAction, String batchId, String batchSerialNo) {
        this.batchId = batchId;
        this.batchSerialNo = batchSerialNo;
        this.batchAction = batchAction.toLowerCase();
    }

    public void start() throws Exception {
        if (BATCH_RUN.equals(this.batchAction)) {
            this.doRunBatch();
        } else if (BATCH_STOP.equals(this.batchAction)) {
            this.doStopBatch();
        } else if (BATCH_RERUN.equals(this.batchAction)) {
            this.doRerunBatch();
        } else if (BATCH_CONTINUE.equals(this.batchAction)) {
            this.doContinueBatch();
        }
    }

    private void doRunBatch() throws Exception {
        Connection conn = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            String sql = "select count(1) from bpa_inst_info where bpa_serial_no = ?";
            values.clear();
            values.add(this.batchSerialNo);
            int count = dao.queryCount(sql, values);
            if (count > 0) {
                throw new Exception("\u5f53\u524d\u4e1a\u52a1\u6d41\u6c34\u53f7\u5df2\u7ecf\u53d1\u8d77\u81ea\u52a8\u6d41\u7a0b\uff0c\u4e0d\u5141\u8bb8\u518d\u53d1\u8d77\uff01");
            }
            sql = "select * from bpa_base_info where bpa_id = ?";
            values.clear();
            values.add(this.batchId);
            BpaBaseInfo bpaBaseInfo = dao.querySingle(sql, values, BpaBaseInfo.class);
            if (Objects.isNull((Object)bpaBaseInfo)) {
                throw new Exception("\u83b7\u53d6\u81ea\u52a8\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String subsCode = bpaBaseInfo.getSubsCode();
            if (StringUtils.isBlank((CharSequence)subsCode)) {
                throw new Exception("\u83b7\u53d6\u81ea\u52a8\u6d41\u7a0b\u6240\u5c5e\u7cfb\u7edf\u4ee3\u7801\u4e3a\u7a7a\uff01");
            }
            sql = "select * from s_subs_info where subs_code = ?";
            values.clear();
            values.add(subsCode);
            SSubsInfo sSubsInfo = dao.querySingle(sql, values, SSubsInfo.class);
            if (sSubsInfo == null) {
                throw new Exception("\u6839\u636e\u5b50\u7cfb\u7edf\u4ee3\u7801\u3010" + subsCode + "\u3011\u67e5\u8be2\u5b50\u7cfb\u7edf\u57fa\u7840\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String batchDate = TimeUtil.getCurDate();
            BpaInstInfo batInstBatch = new BpaInstInfo();
            batInstBatch.setBpaSerialNo(this.batchSerialNo);
            batInstBatch.setBpaId(bpaBaseInfo.getBpaId());
            batInstBatch.setBpaName(bpaBaseInfo.getBpaName());
            batInstBatch.setBpaState("8");
            batInstBatch.setBpaInterveneState("0");
            batInstBatch.setBpaDate(batchDate);
            batInstBatch.setStartTime(TimeUtil.getCurrentDateTime());
            batInstBatch.setSubsCode(sSubsInfo.getSubsCode());
            dao.insertAuto(batInstBatch);
            sql = "insert into bpa_inst_task (bpa_serial_no, task_id, task_name, bpa_id, bpa_date, stage_id, stage_name, task_run_state, task_intervene_state) select '" + this.batchSerialNo + "' as bpa_serial_no, a.task_id, a.task_name, b.bpa_id, '" + batchDate + "' as bpa_date, a.stage_id, b.stage_name, '" + "0" + "' as task_run_state, '" + "0" + "' as task_intervene_state from bpa_task_info a, bpa_stage_info b where a.bpa_id = '" + this.batchId + "' and a.task_use_state = '0' and (a.task_use_area = '1' or a.task_use_area = '2') and a.bpa_id = b.bpa_id  and a.stage_id = b.stage_id";
            count = dao.update(sql);
            if (count > 0) {
                String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
                BpaRunProcess batRunProcess = new BpaRunProcess(this.batchSerialNo, bpaBaseInfo, logPath);
                batRunProcess.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doStopBatch() throws Exception {
        Connection conn = null;
        String sql = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            sql = "select * from bpa_base_info where bpa_id = ?";
            values.add(this.batchId);
            BpaBaseInfo bpaBaseInfo = dao.querySingle(sql, values, BpaBaseInfo.class);
            if (bpaBaseInfo == null) {
                throw new Exception("\u6839\u636e\u81ea\u52a8\u6d41\u7a0b\u6807\u8bc6\u67e5\u8be2\u81ea\u52a8\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            sql = "select * from bpa_inst_task where bpa_serial_no = ? and task_run_state = ?";
            values.clear();
            values.add(this.batchSerialNo);
            values.add("2");
            List<BpaInstTask> bpaInstTaskList = dao.queryList(sql, values, BpaInstTask.class);
            if (bpaInstTaskList == null || bpaInstTaskList.size() == 0) {
                throw new Exception("\u5f53\u524d\u81ea\u52a8\u6d41\u7a0b\u4e0d\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff01");
            }
            Iterator<BpaInstTask> it = bpaInstTaskList.iterator();
            while (it.hasNext()) {
                String taskId = it.next().getTaskId();
                sql = "select * from bpa_task_info where previous_task_id = ?";
                values.clear();
                values.add(taskId);
                List<BpaTaskInfo> bpaTaskInfoList = dao.queryList(sql, values, BpaTaskInfo.class);
                if (bpaTaskInfoList.size() == 0) continue;
                Iterator<BpaTaskInfo> bpaTaskInfoIt = bpaTaskInfoList.iterator();
                while (bpaTaskInfoIt.hasNext()) {
                    String nextTaskId = bpaTaskInfoIt.next().getTaskId();
                    sql = "update bpa_inst_task set task_run_state = ? where bpa_serial_no = ? and task_id = ?";
                    values.clear();
                    values.add("7");
                    values.add(this.batchSerialNo);
                    values.add(nextTaskId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doRerunBatch() throws Exception {
        Connection conn = null;
        String sql = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            conn = ConnectionUtil.getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            sql = "select * from bpa_base_info where bpa_id = ?";
            values.add(this.batchId);
            BpaBaseInfo batchConfig = dao.querySingle(sql, values, BpaBaseInfo.class);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u81ea\u52a8\u6d41\u7a0b\u6807\u8bc6\u67e5\u8be2\u81ea\u52a8\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String isRunAgain = batchConfig.getIsRunAgain();
            if (StringUtils.isBlank((CharSequence)isRunAgain)) {
                throw new Exception("\u67e5\u8be2\u662f\u5426\u5141\u8bb8\u91cd\u8dd1\u6807\u8bc6\u4e3a\u7a7a\uff01");
            }
            if ("N".equals(isRunAgain)) {
                throw new Exception("\u8be5\u81ea\u52a8\u6d41\u7a0b\u4e0d\u652f\u6301\u91cd\u8dd1\uff01");
            }
            sql = "select * from bpa_inst_info where bpa_serial_no = ?";
            values.clear();
            values.add(this.batchSerialNo);
            BpaInstInfo batchInst = dao.querySingle(sql, values, BpaInstInfo.class);
            if (batchInst == null) {
                throw new Exception("\u672a\u627e\u5230\u91cd\u8dd1\u7684\u81ea\u52a8\u6d41\u7a0b\uff01");
            }
            String batchState = batchInst.getBpaState();
            if ("8".equals(batchState) || "3".equals(batchState)) {
                throw new Exception("\u81ea\u52a8\u6d41\u7a0b\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u91cd\u8dd1\uff01");
            }
            String cond = " where bpa_id = '" + this.batchId + "'";
            this.dataMove(conn, "bpa_inst_info", "bpa_inst_info_h", cond);
            this.dataMove(conn, "bpa_inst_task", "bpa_inst_task_h", cond);
            String condi1 = " where bpa_id = '" + this.batchId + "'";
            TableMove batchDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "bpa_inst_info", "bpa_inst_info");
            batchDataMoveUtil.setCondition(condi1);
            String batchSerialNo = batchInst.getBpaSerialNo();
            String lastTwoSerial = batchSerialNo.substring(batchSerialNo.length() - 1, batchSerialNo.length());
            lastTwoSerial = Integer.parseInt(lastTwoSerial) < 10 ? "0" + (Integer.parseInt(lastTwoSerial) + 1) : "" + (Integer.parseInt(lastTwoSerial) + 1);
            batchSerialNo = batchSerialNo.substring(0, batchSerialNo.length() - 2) + lastTwoSerial;
            batchDataMoveUtil.addValueMapping("bpa_serial_no", batchSerialNo);
            batchDataMoveUtil.addValueMapping("bpa_order", batchInst.getBpaOrder() + 1);
            batchDataMoveUtil.executeCopy();
            String condi = " where bpa_id = '" + this.batchId + "' and task_use_state='0' and (task_use_area = '1' or task_use_area = '3') ";
            TableMove taskDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "bpa_task_info", "bpa_inst_task");
            taskDataMoveUtil.setCondition(condi);
            taskDataMoveUtil.executeCopy();
            String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
            BpaRunProcess batRunProcess = new BpaRunProcess(this.batchSerialNo, batchConfig, logPath);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ConnectionUtil.releaseConnection(conn);
        }
    }

    private void doContinueBatch() throws Exception {
        Connection conn = null;
        String sql = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            JavaDataJobDao dao = new JavaDataJobDao(conn, true);
            sql = "select * from bpa_base_info where bpa_id = ?";
            values.add(this.batchId);
            BpaBaseInfo batchConfig = dao.querySingle(sql, values, BpaBaseInfo.class);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u81ea\u52a8\u6d41\u7a0b\u6807\u8bc6\u67e5\u8be2\u81ea\u52a8\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            sql = "update bpa_inst_task set task_run_state=?, start_time='', end_time='', cost_time=0 where bpa_serial_no=? and task_run_state='7'";
            values.clear();
            values.add("1");
            values.add(this.batchSerialNo);
            dao.update(sql, values);
            String logPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"agent.batch.log.path");
            BpaRunProcess batRunProcess = new BpaRunProcess(this.batchSerialNo, batchConfig, logPath);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    public void dataMove(Connection conn, String srcTableName, String destTableName, String cond) throws SQLException {
        TableMove dataMoveInst = DataMoveUtil.createTableMoveInst(conn, srcTableName, destTableName);
        dataMoveInst.setCondition(cond);
        dataMoveInst.executeCut();
    }
}

