/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.jmx.mbean;

import com.irdstudio.bfp.executor.rest.jmx.mbean.HealthMBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Health
implements HealthMBean {
    private static final Logger logger = LoggerFactory.getLogger(HealthMBean.class);
    private String status = "starting";
    private static CountDownLatch LATCH = new CountDownLatch(1);
    private static AtomicBoolean INIT = new AtomicBoolean(false);
    private static Health INSTANCE = new Health();

    private Health() {
    }

    @Override
    public void startup() {
        this.status = "success";
    }

    @Override
    public void await() {
        try {
            LATCH.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String preload() {
        return this.status;
    }

    @Override
    public boolean shutdown() {
        LATCH.countDown();
        return true;
    }

    public static Health getInstance() {
        return INSTANCE;
    }

    public static void registMBean() {
        if (INIT.compareAndSet(false, true)) {
            try {
                MBeanServer mBeanServer = Health.getMBeanServer();
                mBeanServer.registerMBean(INSTANCE, Health.getHealthName());
            }
            catch (Throwable e) {
                logger.error("registMBean()\u65b9\u6cd5\u5f02\u5e38", e);
            }
        }
    }

    public static void markStartup() {
        try {
            MBeanServer mBeanServer = Health.getMBeanServer();
            mBeanServer.invoke(Health.getHealthName(), "startup", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            logger.error("markStartup()\u65b9\u6cd5\u5f02\u5e38", t);
        }
    }

    public static void markAwait() throws InterruptedException {
        try {
            MBeanServer mBeanServer = Health.getMBeanServer();
            mBeanServer.invoke(Health.getHealthName(), "await", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            logger.error("markAwait()\u65b9\u6cd5\u5f02\u5e38", t);
        }
    }

    private static MBeanServer getMBeanServer() {
        MBeanServer mBeanServer = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : ManagementFactory.getPlatformMBeanServer();
        return mBeanServer;
    }

    private static ObjectName getHealthName() throws MalformedObjectNameException {
        ObjectName name = new ObjectName("com.gdrcu.lp:type=Health");
        return name;
    }
}

