/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core;

import com.irdstudio.bfp.executor.core.job.JavaDataJobDao;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.executor.SafeReleaseUtil;
import com.irdstudio.bfp.executor.core.vo.BpaBaseInfo;
import com.irdstudio.bfp.executor.core.vo.BpaInstInfo;
import com.irdstudio.bfp.executor.core.vo.BpaTaskInfo;
import com.irdstudio.bfp.executor.core.vo.SSubsInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class BpaDataUtil {
    public static synchronized BpaTaskInfo getBpaTaskInfo(Connection conn, String taskId) throws Exception {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new SQLException("\u4efb\u52a1\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from bpa_task_info where task_id = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(taskId);
        BpaTaskInfo bpaTaskInfo = dao.querySingle(sql, values, BpaTaskInfo.class);
        return bpaTaskInfo;
    }

    public static synchronized BpaBaseInfo getBpaBaseInfo(Connection conn, String batchId) throws Exception {
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from bpa_base_info where bpa_id = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(batchId);
        BpaBaseInfo config = dao.querySingle(sql, values, BpaBaseInfo.class);
        return config;
    }

    public static synchronized BpaInstInfo getBpaInstInfo(Connection conn, String batchSerialNo) throws Exception {
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from bpa_inst_info where bpa_serial_no = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(batchSerialNo);
        BpaInstInfo batch = dao.querySingle(sql, values, BpaInstInfo.class);
        return batch;
    }

    public static synchronized SSubsInfo getSSubsInfo(Connection conn, String subsCode) throws Exception {
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from s_subs_info where subs_code = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(subsCode);
        SSubsInfo info = dao.querySingle(sql, values, SSubsInfo.class);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTaskSkiped(String taskId) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        boolean isSkiped;
        block5: {
            isSkiped = false;
            ps = null;
            rs = null;
            String state = "";
            conn = null;
            try {
                conn = TConnPool.getDefaultPool().getConnection();
                ps = conn.prepareStatement("SELECT task_intervene_state FROM bpa_inst_task WHERE task_id=?");
                ps.setString(1, taskId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    state = rs.getString("task_intervene_state");
                }
                if (state == null || !state.equals("1") && !state.equals("3")) break block5;
                isSkiped = true;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SafeReleaseUtil.close(rs, null, ps);
                    TConnPool.getDefaultPool().releaseConnection(conn);
                    throw throwable;
                }
                SafeReleaseUtil.close(rs, null, ps);
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        SafeReleaseUtil.close(rs, null, ps);
        TConnPool.getDefaultPool().releaseConnection(conn);
        return isSkiped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTaskState(String taskId) {
        Connection conn;
        String state;
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            ps = null;
            rs = null;
            state = "";
            conn = null;
            try {
                conn = TConnPool.getDefaultPool().getConnection();
                ps = conn.prepareStatement("SELECT task_intervene_state FROM bpa_inst_task WHERE task_id=?");
                ps.setString(1, taskId);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                state = rs.getString("task_intervene_state");
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SafeReleaseUtil.close(rs, null, ps);
                    TConnPool.getDefaultPool().releaseConnection(conn);
                    throw throwable;
                }
                SafeReleaseUtil.close(rs, null, ps);
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        SafeReleaseUtil.close(rs, null, ps);
        TConnPool.getDefaultPool().releaseConnection(conn);
        return state;
    }
}

