/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.assembly.jxp.parser;

import com.irdstudio.bfp.executor.core.assembly.jxp.conf.SqlSection;
import com.irdstudio.bfp.executor.core.assembly.jxp.parser.ParamParser;
import com.irdstudio.bfp.executor.core.assembly.jxp.util.LogUtil;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.utils.vo.VariableValue;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlParser {
    private SqlSection sd = null;
    private VariableValue vv = null;

    public SqlParser(SqlSection sd, VariableValue vv) {
        this.sd = sd;
        this.vv = vv;
    }

    public static SqlParser getInstance(SqlSection sd, VariableValue vv) {
        return new SqlParser(sd, vv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String sql = "";
        double before = System.currentTimeMillis();
        String[] sqls = this.sd.getSqls();
        LogUtil.out("\u6267\u884cSQL\u533a\u4e2d\u7684SQL\u8bed\u53e5...");
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            for (int i = 0; i < sqls.length; ++i) {
                if (sqls[i] == null || "".equals(sqls[i].trim())) continue;
                Statement st = null;
                try {
                    sql = ParamParser.parseVariable(sqls[i], this.vv, null);
                    LogUtil.out(sql);
                    st = conn.createStatement();
                    st.execute(sql);
                    continue;
                }
                catch (SQLException e) {
                    LogUtil.log("\u6267\u884c:" + sql + "\u51fa\u9519!\n");
                    LogUtil.log(e.getMessage(), "ISO-8859-1");
                    continue;
                }
                finally {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    st = null;
                }
            }
        }
        catch (SQLException e1) {
            LogUtil.out("SqlParser\u6267\u884c\u51fa\u9519\uff01");
            LogUtil.writeError(e1);
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        double after = System.currentTimeMillis();
        LogUtil.out("need [" + (after - before) / 1000.0 + "] second");
    }
}

