/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.dao;

import com.irdstudio.bfp.executor.core.dao.domain.BpaInstInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BpaInstInfoDao {
    Connection conn = null;

    public BpaInstInfoDao(Connection conn) {
        this.conn = conn;
    }

    public int insertBpaInstInfo(BpaInstInfo bpaInstInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into bpa_inst_info ( bpa_serial_no,bpa_id,bpa_order,bpa_name,bpa_date,bpa_intervene_state,bpa_state,start_time,end_time,need_run_count,exist_run_count,not_run_count,succeed_run_count,faild_run_count,warn_run_count,skip_run_count,subs_code,cost_time,stage_name,stage_id,remark) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setObject(1, bpaInstInfo.getBpaSerialNo());
            ps.setObject(2, bpaInstInfo.getBpaId());
            ps.setObject(3, bpaInstInfo.getBpaOrder());
            ps.setObject(4, bpaInstInfo.getBpaName());
            ps.setObject(5, bpaInstInfo.getBpaDate());
            ps.setObject(6, bpaInstInfo.getBpaInterveneState());
            ps.setObject(7, bpaInstInfo.getBpaState());
            ps.setObject(8, bpaInstInfo.getStartTime());
            ps.setObject(9, bpaInstInfo.getEndTime());
            ps.setObject(10, bpaInstInfo.getNeedRunCount());
            ps.setObject(11, bpaInstInfo.getExistRunCount());
            ps.setObject(12, bpaInstInfo.getNotRunCount());
            ps.setObject(13, bpaInstInfo.getSucceedRunCount());
            ps.setObject(14, bpaInstInfo.getFaildRunCount());
            ps.setObject(15, bpaInstInfo.getWarnRunCount());
            ps.setObject(16, bpaInstInfo.getSkipRunCount());
            ps.setObject(17, bpaInstInfo.getSubsCode());
            ps.setObject(18, bpaInstInfo.getCostTime());
            ps.setObject(19, bpaInstInfo.getStageName());
            ps.setObject(20, bpaInstInfo.getStageId());
            ps.setObject(21, bpaInstInfo.getRemark());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert BpaInstInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteByPk(BpaInstInfo bpaInstInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("delete from bpa_inst_info where 1=1 AND bpa_serial_no = ? ");
            ps.setObject(1, bpaInstInfo.getBpaSerialNo());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("delete BpaInstInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int updateByPk(BpaInstInfo bpaInstInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("update bpa_inst_info set  bpa_serial_no = ? , bpa_id = ? , bpa_order = ? , bpa_name = ? , bpa_date = ? , bpa_intervene_state = ? , bpa_state = ? , start_time = ? , end_time = ? , need_run_count = ? , exist_run_count = ? , not_run_count = ? , succeed_run_count = ? , faild_run_count = ? , warn_run_count = ? , skip_run_count = ? , subs_code = ? , cost_time = ? , stage_name = ? , stage_id = ? , remark = ?  where 1=1 AND bpa_serial_no = ? ");
            ps.setObject(1, bpaInstInfo.getBpaSerialNo());
            ps.setObject(2, bpaInstInfo.getBpaId());
            ps.setObject(3, bpaInstInfo.getBpaOrder());
            ps.setObject(4, bpaInstInfo.getBpaName());
            ps.setObject(5, bpaInstInfo.getBpaDate());
            ps.setObject(6, bpaInstInfo.getBpaInterveneState());
            ps.setObject(7, bpaInstInfo.getBpaState());
            ps.setObject(8, bpaInstInfo.getStartTime());
            ps.setObject(9, bpaInstInfo.getEndTime());
            ps.setObject(10, bpaInstInfo.getNeedRunCount());
            ps.setObject(11, bpaInstInfo.getExistRunCount());
            ps.setObject(12, bpaInstInfo.getNotRunCount());
            ps.setObject(13, bpaInstInfo.getSucceedRunCount());
            ps.setObject(14, bpaInstInfo.getFaildRunCount());
            ps.setObject(15, bpaInstInfo.getWarnRunCount());
            ps.setObject(16, bpaInstInfo.getSkipRunCount());
            ps.setObject(17, bpaInstInfo.getSubsCode());
            ps.setObject(18, bpaInstInfo.getCostTime());
            ps.setObject(19, bpaInstInfo.getStageName());
            ps.setObject(20, bpaInstInfo.getStageId());
            ps.setObject(21, bpaInstInfo.getRemark());
            ps.setObject(22, bpaInstInfo.getBpaSerialNo());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("update BpaInstInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public BpaInstInfo queryByPk(BpaInstInfo bpaInstInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        BpaInstInfo result = null;
        try {
            ps = this.conn.prepareStatement("select bpa_serial_no,bpa_id,bpa_order,bpa_name,bpa_date,bpa_intervene_state,bpa_state,start_time,end_time,need_run_count,exist_run_count,not_run_count,succeed_run_count,faild_run_count,warn_run_count,skip_run_count,subs_code,cost_time,stage_name,stage_id,remark from bpa_inst_info where 1=1  AND bpa_serial_no = ? ");
            ps.setObject(1, bpaInstInfo.getBpaSerialNo());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = new BpaInstInfo();
                result.setBpaSerialNo(rs.getString("bpa_serial_no"));
                result.setBpaId(rs.getString("bpa_id"));
                result.setBpaName(rs.getString("bpa_name"));
                result.setBpaDate(rs.getString("bpa_date"));
                result.setBpaInterveneState(rs.getString("bpa_intervene_state"));
                result.setBpaState(rs.getString("bpa_state"));
                result.setStartTime(rs.getString("start_time"));
                result.setEndTime(rs.getString("end_time"));
                result.setSubsCode(rs.getString("subs_code"));
                result.setCostTime(rs.getBigDecimal("cost_time"));
                result.setStageName(rs.getString("stage_name"));
                result.setStageId(rs.getString("stage_id"));
                result.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update BpaInstInfo is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    public List<BpaInstInfo> queryAll(BpaInstInfo bpaInstInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<BpaInstInfo> result = new ArrayList<BpaInstInfo>();
        try {
            String sql = "select bpa_serial_no,bpa_id,bpa_order,bpa_name,bpa_date,bpa_intervene_state,bpa_state,start_time,end_time,need_run_count,exist_run_count,not_run_count,succeed_run_count,faild_run_count,warn_run_count,skip_run_count,subs_code,cost_time,stage_name,stage_id,remarkfrom bpa_inst_info where 1=1 ";
            if (bpaInstInfo.getBpaSerialNo() != null) {
                sql = sql + " AND bpa_serial_no =  '" + bpaInstInfo.getBpaSerialNo() + "'";
            }
            if (bpaInstInfo.getBpaId() != null) {
                sql = sql + " AND bpa_id =  '" + bpaInstInfo.getBpaId() + "'";
            }
            if (bpaInstInfo.getBpaOrder() != null) {
                sql = sql + " AND bpa_order =  '" + bpaInstInfo.getBpaOrder() + "'";
            }
            if (bpaInstInfo.getBpaName() != null) {
                sql = sql + " AND bpa_name =  '" + bpaInstInfo.getBpaName() + "'";
            }
            if (bpaInstInfo.getBpaDate() != null) {
                sql = sql + " AND bpa_date =  '" + bpaInstInfo.getBpaDate() + "'";
            }
            if (bpaInstInfo.getBpaInterveneState() != null) {
                sql = sql + " AND bpa_intervene_state =  '" + bpaInstInfo.getBpaInterveneState() + "'";
            }
            if (bpaInstInfo.getBpaState() != null) {
                sql = sql + " AND bpa_state =  '" + bpaInstInfo.getBpaState() + "'";
            }
            if (bpaInstInfo.getStartTime() != null) {
                sql = sql + " AND start_time =  '" + bpaInstInfo.getStartTime() + "'";
            }
            if (bpaInstInfo.getEndTime() != null) {
                sql = sql + " AND end_time =  '" + bpaInstInfo.getEndTime() + "'";
            }
            if (bpaInstInfo.getNeedRunCount() != null) {
                sql = sql + " AND need_run_count =  '" + bpaInstInfo.getNeedRunCount() + "'";
            }
            if (bpaInstInfo.getExistRunCount() != null) {
                sql = sql + " AND exist_run_count =  '" + bpaInstInfo.getExistRunCount() + "'";
            }
            if (bpaInstInfo.getNotRunCount() != null) {
                sql = sql + " AND not_run_count =  '" + bpaInstInfo.getNotRunCount() + "'";
            }
            if (bpaInstInfo.getSucceedRunCount() != null) {
                sql = sql + " AND succeed_run_count =  '" + bpaInstInfo.getSucceedRunCount() + "'";
            }
            if (bpaInstInfo.getFaildRunCount() != null) {
                sql = sql + " AND faild_run_count =  '" + bpaInstInfo.getFaildRunCount() + "'";
            }
            if (bpaInstInfo.getWarnRunCount() != null) {
                sql = sql + " AND warn_run_count =  '" + bpaInstInfo.getWarnRunCount() + "'";
            }
            if (bpaInstInfo.getSkipRunCount() != null) {
                sql = sql + " AND skip_run_count =  '" + bpaInstInfo.getSkipRunCount() + "'";
            }
            if (bpaInstInfo.getSubsCode() != null) {
                sql = sql + " AND subs_code =  '" + bpaInstInfo.getSubsCode() + "'";
            }
            if (bpaInstInfo.getCostTime() != null) {
                sql = sql + " AND cost_time =  '" + bpaInstInfo.getCostTime() + "'";
            }
            if (bpaInstInfo.getStageName() != null) {
                sql = sql + " AND stage_name =  '" + bpaInstInfo.getStageName() + "'";
            }
            if (bpaInstInfo.getStageId() != null) {
                sql = sql + " AND stage_id =  '" + bpaInstInfo.getStageId() + "'";
            }
            if (bpaInstInfo.getRemark() != null) {
                sql = sql + " AND remark =  '" + bpaInstInfo.getRemark() + "'";
            }
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                BpaInstInfo obj = new BpaInstInfo();
                obj.setBpaSerialNo(rs.getString("bpa_serial_no"));
                obj.setBpaId(rs.getString("bpa_id"));
                obj.setBpaName(rs.getString("bpa_name"));
                obj.setBpaDate(rs.getString("bpa_date"));
                obj.setBpaInterveneState(rs.getString("bpa_intervene_state"));
                obj.setBpaState(rs.getString("bpa_state"));
                obj.setStartTime(rs.getString("start_time"));
                obj.setEndTime(rs.getString("end_time"));
                obj.setSubsCode(rs.getString("subs_code"));
                obj.setCostTime(rs.getBigDecimal("cost_time"));
                obj.setStageName(rs.getString("stage_name"));
                obj.setStageId(rs.getString("stage_id"));
                obj.setRemark(rs.getString("remark"));
                result.add(obj);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update BpaInstInfo is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    public int recordTransfer() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "INSERT INTO bpa_inst_info_h SELECT * FROM bpa_inst_info WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteRecord() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "DELETE FROM bpa_inst_info WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

