/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.plugin.common;

import com.irdstudio.bfp.executor.core.plugin.common.PluginDefine;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDefineDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginDefineDao.class);
    Connection conn = null;

    public PluginDefineDao(Connection conn) {
        this.conn = conn;
    }

    public PluginDefine queryWithKeys(int pluginId) throws SQLException {
        PluginDefine dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_define WHERE plugin_id=?");
            ps.setInt(1, pluginId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginDefine();
                dc.setPluginId(rs.getInt("plugin_id"));
                dc.setPluginName(rs.getString("plugin_name"));
                dc.setPluginDealClass(rs.getString("plugin_class") == null ? rs.getString("plugin_class") : rs.getString("plugin_class").trim());
                dc.setPluginDesc(rs.getString("plugin_desc"));
                dc.setNeedOtherDsVar(rs.getString("need_other_ds_var"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginDefineWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

