/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.plugin.datajob;

import com.irdstudio.bfp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bfp.executor.core.utils.pub.PathUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLSqlJobPlugin
extends AbstractPlugin {
    String[] sqls = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        return false;
    }

    @Override
    public boolean readPluginConfigureFromFile(String szConfIdentify) {
        return this.readXMLConfigureSQLs(szConfIdentify);
    }

    @Override
    public boolean execute() {
        this.logger.info("\u6267\u884c\u4f5c\u4e1a\u914d\u7f6e(XML)\u7684SQL\u811a\u672c...");
        boolean flag = true;
        for (int i = 0; i < this.sqls.length; ++i) {
            if ("".equals(this.sqls[i].trim())) continue;
            String sql = this.context.toParseSysVariable(this.sqls[i]);
            boolean subFlag = this.executeSql(sql);
            if (subFlag) {
                this.writeSuccessLog("\u6267\u884c\u4f5c\u4e1a\u914d\u7f6e\u7684SQL\u811a\u672c", sql);
                continue;
            }
            this.writeFaildLog("\u6267\u884c\u4f5c\u4e1a\u914d\u7f6e\u7684SQL\u811a\u672c", sql + "," + this.context.getSzLastErrorMsg());
            flag = subFlag;
            break;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readXMLConfigureSQLs(String xmlConfigFile) {
        xmlConfigFile = PathUtil.getClassRootPath() + xmlConfigFile;
        this.logger.info(xmlConfigFile);
        boolean flag = true;
        if (xmlConfigFile != null && !"".equals(xmlConfigFile)) {
            SAXBuilder sb = new SAXBuilder();
            Document doc = null;
            try {
                doc = sb.build((InputStream)new FileInputStream(xmlConfigFile));
                Element root = doc.getRootElement();
                String allSQL = root.getText();
                if (allSQL == null || "".equals(allSQL)) {
                    flag = false;
                } else {
                    this.sqls = allSQL.split(";");
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error("\u6587\u4ef6" + xmlConfigFile + "\u6ca1\u6709\u627e\u5230!", e);
                flag = false;
            }
            catch (JDOMException e) {
                this.logger.error("\u8bfbXML\u6587\u4ef6\u5f02\u5e38,\u8bf7\u68c0\u67e5XML\u6587\u4ef6!", e);
                flag = false;
            }
            catch (IOException e) {
                this.logger.error("\u8bfbXML\u6587\u4ef6\u5f02\u5e38,\u8bf7\u68c0\u67e5XML\u6587\u4ef6!", e);
            }
            finally {
                doc = null;
            }
        }
        return flag;
    }
}

