/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.plugin.datapack;

import com.irdstudio.bfp.executor.core.assembly.jxp.conf.ConfigureEntry;
import com.irdstudio.bfp.executor.core.assembly.jxp.loader.MainLoader;
import com.irdstudio.bfp.executor.core.assembly.jxp.parser.CoreParser;
import com.irdstudio.bfp.executor.core.assembly.jxp.util.LogUtil;
import com.irdstudio.bfp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bfp.executor.core.plugin.datapack.PluginDatapackConf;
import com.irdstudio.bfp.executor.core.plugin.datapack.PluginDatapackConfDao;
import com.irdstudio.bfp.executor.core.utils.vo.VariableValue;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class DataPackPlugin
extends AbstractPlugin {
    List<PluginDatapackConf> dpcList;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginDatapackConfDao dpcDao = new PluginDatapackConfDao(conn);
        this.dpcList = dpcDao.queryPluginDatapackConfWithPluginConfId(szConfIdentify);
        if (this.dpcList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u7ec4\u5305\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        for (int i = 0; i < this.dpcList.size(); ++i) {
            PluginDatapackConf pdc = this.dpcList.get(i);
            if (this.isInValidConf(this.context.getCurrentDataDate(), pdc.getValidDate(), pdc.getInvalidDate())) continue;
            boolean curFlag = true;
            this.logger.info("\u51c6\u5907\u751f\u6210\u6570\u636e\u62a5\u6587\uff1a" + pdc.getPackDesc() + "...");
            VariableValue vv = this.context.getVv();
            vv.addVariable("report_date_10", this.context.getCurrentDataDate());
            vv.addVariable("report_date_8", this.context.getCurrentDataDate().replaceAll("-", ""));
            vv.addVariable("report_year_4", this.context.getCurrentDataDate().substring(0, 4));
            vv.addVariable("report_month_2", this.context.getCurrentDataDate().substring(5, 7));
            String targetFile = this.context.toParseSysVariable(pdc.getPackGenerateFile());
            String configFile = this.context.toParseSysVariable(pdc.getPackConfigFile());
            try {
                LogUtil.setLogger(this.logger);
                ConfigureEntry cxd = MainLoader.loadCoreXml(configFile);
                if (cxd == null) {
                    throw new Exception("\u62a5\u6587\u7ec4\u5305\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u6587\u4ef6\u683c\u5f0f\u5b58\u5728\u9519\u8bef!");
                }
                try (FileOutputStream fos = new FileOutputStream(targetFile);
                     OutputStreamWriter fo = new OutputStreamWriter((OutputStream)fos, pdc.getPackFileEncoding());){
                    fo.write("<?xml version=\"1.0\" encoding=\"" + pdc.getPackFileEncoding() + "\" standalone=\"no\"?>");
                    CoreParser parser = new CoreParser();
                    parser.linkConfigureEntry(cxd);
                    parser.linkFileObject(fo);
                    parser.linkVariableValue(vv);
                    if (parser.run()) {
                        this.writeSuccessLog("\u751f\u6210\u6570\u636e\u62a5\u6587\u6587\u4ef6");
                        continue;
                    }
                    this.writeFaildLog("\u751f\u6210\u6570\u636e\u62a5\u6587\u6587\u4ef6", targetFile);
                    continue;
                }
            }
            catch (FileNotFoundException e) {
                curFlag = false;
                this.context.setSzLastErrorMsg(e.getMessage());
                this.logger.error(e.getMessage());
                continue;
            }
            catch (IOException e) {
                curFlag = false;
                this.context.setSzLastErrorMsg(e.getMessage());
                this.logger.error(e.getMessage());
                continue;
            }
            catch (Exception e) {
                curFlag = false;
                this.context.setSzLastErrorMsg(e.getMessage());
                this.logger.error(e.getMessage());
                continue;
            }
            finally {
                if (curFlag) {
                    this.writeSuccessLog("\u6839\u636e" + configFile + "\u751f\u6210" + targetFile);
                } else {
                    this.writeFaildLog("\u6839\u636e" + configFile + "\u751f\u6210" + targetFile);
                    flag = curFlag;
                }
            }
        }
        return flag;
    }
}

