/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.plugin.dubbo;

import com.alibaba.dubbo.rpc.service.GenericService;
import com.irdstudio.bfp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bfp.executor.core.plugin.dubbo.DubboClient;
import com.irdstudio.bfp.executor.core.plugin.hsf.PluginServiceConf;
import com.irdstudio.bfp.executor.core.plugin.hsf.PluginServiceConfDao;
import com.irdstudio.bfp.executor.core.plugin.hsf.PluginServiceParam;
import com.irdstudio.bfp.executor.core.plugin.hsf.PluginServiceParamDao;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.core.tinycore.log.ILogger;
import com.irdstudio.bfp.executor.core.tinycore.log.TLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DubboServicePlugin
extends AbstractPlugin {
    protected ILogger logger = TLogger.getLogger(DubboServicePlugin.class.getSimpleName());
    private List<PluginServiceConf> serviceList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Connection conn = null;
        boolean flag = false;
        try {
            conn = this.getPluginConnection();
            PluginServiceParamDao paramDao = new PluginServiceParamDao(conn);
            if (this.serviceList != null) {
                for (int i = 0; i < this.serviceList.size(); ++i) {
                    Map resultMap;
                    PluginServiceConf conf = this.serviceList.get(i);
                    GenericService svc = null;
                    svc = conf.getTimeout() == null ? DubboClient.getDubboClient().buildGenericService(conf.getServiceInterface(), conf.getGroup(), conf.getVersion()) : DubboClient.getDubboClient().buildGenericService(conf.getServiceInterface(), conf.getTimeout().intValue(), conf.getGroup(), conf.getVersion());
                    List<PluginServiceParam> paramList = null;
                    if (StringUtils.isNotEmpty((CharSequence)conf.getPluginConfId())) {
                        paramList = paramDao.queryWithCond("where param_group_id = '" + conf.getParamGroupId() + "'", " order by service_param_name");
                    }
                    String[] paramTypeArr = null;
                    Object[] paramValueArr = null;
                    if (paramList != null && paramList.size() > 0) {
                        paramTypeArr = new String[paramList.size()];
                        paramValueArr = new Object[paramList.size()];
                        for (int index = 0; index < paramList.size(); ++index) {
                            PluginServiceParam param = paramList.get(index);
                            paramTypeArr[index] = param.getServiceParamType();
                            paramValueArr[index] = this.context.toParseSysVariable(param.getServiceParamValue());
                        }
                    }
                    this.logger.info("service id: " + conf.getServiceId() + ", interface: " + conf.getServiceInterface() + ",version: " + conf.getVersion() + ", group: " + conf.getGroup() + ",timeout: " + conf.getTimeout() + ", param type: " + paramTypeArr + ", param value: " + paramValueArr);
                    Object result = svc.$invoke(conf.getServiceMethod(), paramTypeArr, paramValueArr);
                    this.logger.info("service call result: " + result);
                    if (result == null) continue;
                    this.logger.info("service call result class: " + result.getClass());
                    if (result instanceof Boolean) {
                        this.logger.info("service return result: " + result);
                        Boolean resultBoolean = (Boolean)result;
                        if (resultBoolean.booleanValue()) continue;
                        throw new Exception("service: " + conf.getServiceInterface() + " call error");
                    }
                    if (!(result instanceof Map) || !(resultMap = (Map)result).containsKey("class") || resultMap.get("class") == null || !resultMap.get("class").toString().contains("Exception")) continue;
                    this.logger.debug("result map key class: " + resultMap.get("class").getClass());
                    throw new Exception(result.toString());
                }
            }
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            this.logger.error("Dubbo\u63d2\u4ef6\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage(), e);
            this.context.setSzLastErrorMsg(e.getMessage());
        }
        finally {
            if (conn != null) {
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        return flag;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginServiceConfDao plcDao = new PluginServiceConfDao(conn);
        this.serviceList = plcDao.queryWithCond(" where plugin_conf_id='" + szConfIdentify + "'", "order by conf_sort");
        if (this.serviceList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u670d\u52a1\u914d\u7f6e!");
            return false;
        }
        return true;
    }
}

