/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.plugin.webapp;

import com.irdstudio.bfp.executor.core.plugin.webapp.PluginWebappConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PluginWebappConfDao {
    Connection conn = null;

    public PluginWebappConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginWebappConf queryPluginWebappConfWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginWebappConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_webapp_conf WHERE plugin_conf_id=?,conf_sort=? with ur");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginWebappConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setWsAddr(rs.getString("ws_addr"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setAppType(rs.getString("app_type"));
                dc.setNsUri(rs.getString("NS_URI"));
                dc.setRemark(rs.getString("remark"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginWebappConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginWebappConf> queryPluginWebappConfWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<PluginWebappConf> dcList = new ArrayList<PluginWebappConf>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_webapp_conf " + szCondition + " " + szOrderBy + " with ur");
            rs = ps.executeQuery();
            while (rs.next()) {
                PluginWebappConf dc = new PluginWebappConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setWsAddr(rs.getString("ws_addr"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setAppType(rs.getString("app_type"));
                dc.setNsUri(rs.getString("NS_URI"));
                dc.setRemark(rs.getString("remark"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginWebappConfWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

